/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.HeapEstimatorCache;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.virtual.ListValue;

public abstract class ListValueBuilder {
    protected long estimatedHeapSize;
    protected ValueRepresentation valueRepresentation = ValueRepresentation.ANYTHING;
    private static final long ARRAY_LIST_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ArrayList.class);
    private static final Collector<AnyValue, UnknownSizeListValueBuilder, ListValue> LIST_VALUE_COLLECTOR = new Collector<AnyValue, UnknownSizeListValueBuilder, ListValue>(){

        @Override
        public Supplier<UnknownSizeListValueBuilder> supplier() {
            return UnknownSizeListValueBuilder::new;
        }

        @Override
        public BiConsumer<UnknownSizeListValueBuilder, AnyValue> accumulator() {
            return ListValueBuilder::add;
        }

        @Override
        public BinaryOperator<UnknownSizeListValueBuilder> combiner() {
            return UnknownSizeListValueBuilder::combine;
        }

        @Override
        public Function<UnknownSizeListValueBuilder, ListValue> finisher() {
            return UnknownSizeListValueBuilder::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    };

    public static Collector<AnyValue, ?, ListValue> collector() {
        return LIST_VALUE_COLLECTOR;
    }

    public static ListValueBuilder newListBuilder(int size) {
        return new FixedSizeListValueBuilder(size);
    }

    public static ListValueBuilder newListBuilder() {
        return new UnknownSizeListValueBuilder();
    }

    protected ListValueBuilder() {
    }

    public final void add(AnyValue value) {
        this.estimatedHeapSize += value.estimatedHeapUsage();
        this.valueRepresentation = this.valueRepresentation.coerce(value.valueRepresentation());
        this.internalAdd(value);
    }

    public final void add(AnyValue value, HeapEstimatorCache heapEstimatorCache) {
        this.estimatedHeapSize += value.estimatedHeapUsage(heapEstimatorCache);
        this.valueRepresentation = this.valueRepresentation.coerce(value.valueRepresentation());
        this.internalAdd(value);
    }

    public abstract ListValue build();

    protected abstract void internalAdd(AnyValue var1);

    private static class FixedSizeListValueBuilder
    extends ListValueBuilder {
        private final AnyValue[] values;
        private int index;

        private FixedSizeListValueBuilder(int size) {
            this.values = new AnyValue[size];
        }

        @Override
        public ListValue build() {
            return new ListValue.ArrayListValue(this.values, this.estimatedHeapSize, this.valueRepresentation);
        }

        @Override
        public void internalAdd(AnyValue value) {
            this.values[this.index++] = value;
        }
    }

    private static class UnknownSizeListValueBuilder
    extends ListValueBuilder {
        private final List<AnyValue> values = new ArrayList<AnyValue>();

        UnknownSizeListValueBuilder() {
            this.estimatedHeapSize += ARRAY_LIST_SHALLOW_SIZE;
        }

        public UnknownSizeListValueBuilder combine(UnknownSizeListValueBuilder rhs) {
            this.values.addAll(rhs.values);
            this.estimatedHeapSize += rhs.estimatedHeapSize;
            return this;
        }

        @Override
        public ListValue build() {
            return new ListValue.JavaListListValue(this.values, this.estimatedHeapSize, this.valueRepresentation);
        }

        @Override
        public void internalAdd(AnyValue value) {
            this.values.add(value);
        }
    }
}

