/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.virtual.VirtualNodeValue;

public class NodeIdReference
extends VirtualNodeValue {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeIdReference.class);
    private final long id;

    NodeIdReference(long id) {
        this.id = id;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.writeNodeReference(this.id);
    }

    @Override
    public String getTypeName() {
        return "NodeIdReference";
    }

    public String toString() {
        return String.format("(%d)", this.id);
    }

    @Override
    public long id() {
        return this.id;
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE;
    }
}

