/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.hashing.HashFunction;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TextValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CharValue
extends TextValue {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(CharValue.class);
    private final char value;

    CharValue(char value) {
        this.value = value;
    }

    @Override
    public boolean equalTo(Object other) {
        return other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(char x) {
        return this.value == x;
    }

    @Override
    public boolean equals(String x) {
        return x.length() == 1 && x.charAt(0) == this.value;
    }

    @Override
    protected int computeHashToMemoize() {
        return 31 + this.value;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        return CharValue.updateHash(hashFunction, hash, this.value);
    }

    public static long updateHash(HashFunction hashFunction, long hash, char value) {
        hash = hashFunction.update(hash, (long)value);
        return hashFunction.update(hash, 1L);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeString(this.value);
    }

    @Override
    public Object asObjectCopy() {
        return Character.valueOf(this.value);
    }

    @Override
    public String prettyPrint() {
        return String.format("'%s'", Character.valueOf(this.value));
    }

    @Override
    public String stringValue() {
        return Character.toString(this.value);
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public TextValue substring(int start, int length) {
        if (length != 1 && start != 0) {
            return StringValue.EMPTY;
        }
        return this;
    }

    @Override
    public TextValue trim() {
        if (Character.isWhitespace(this.value)) {
            return StringValue.EMPTY;
        }
        return this;
    }

    @Override
    public TextValue ltrim() {
        return this.trim();
    }

    @Override
    public TextValue rtrim() {
        return this.trim();
    }

    @Override
    public TextValue toLower() {
        return new CharValue(Character.toLowerCase(this.value));
    }

    @Override
    public TextValue toUpper() {
        return new CharValue(Character.toUpperCase(this.value));
    }

    @Override
    public ListValue split(String separator) {
        if (separator.equals(this.stringValue())) {
            return EMPTY_SPLIT;
        }
        return VirtualValues.list(this);
    }

    @Override
    public ListValue split(List<String> separators) {
        if (separators.stream().anyMatch(sep -> sep.equals(this.stringValue()))) {
            return EMPTY_SPLIT;
        }
        return VirtualValues.list(this);
    }

    @Override
    public TextValue replace(String find, String replace) {
        assert (find != null);
        assert (replace != null);
        if (this.stringValue().equals(find)) {
            return Values.stringValue(replace);
        }
        return this;
    }

    @Override
    public TextValue reverse() {
        return this;
    }

    @Override
    public TextValue plus(TextValue other) {
        return Values.stringValue(this.value + other.stringValue());
    }

    @Override
    public boolean startsWith(TextValue other) {
        return other.length() == 1 && other.stringValue().charAt(0) == this.value;
    }

    @Override
    public boolean endsWith(TextValue other) {
        return this.startsWith(other);
    }

    @Override
    public boolean contains(TextValue other) {
        return this.startsWith(other);
    }

    public char value() {
        return this.value;
    }

    @Override
    public int compareTo(TextValue other) {
        return TextValues.compareCharToString(this.value, other.stringValue());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapChar(this);
    }

    @Override
    protected Matcher matcher(Pattern pattern) {
        return pattern.matcher(String.valueOf(this.value));
    }

    public String toString() {
        return String.format("%s('%s')", this.getTypeName(), Character.valueOf(this.value));
    }

    @Override
    public String getTypeName() {
        return "Char";
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE;
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.UTF16_TEXT;
    }
}

