/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public abstract class PathReference
extends VirtualPathValue {
    public static PathReference path(long[] nodes, long[] relationships) {
        return new PathReferencePrimitive(nodes, relationships);
    }

    public static PathReference path(VirtualNodeValue[] nodes, VirtualRelationshipValue[] relationships) {
        return new PathReferenceReferences(nodes, relationships);
    }

    @Override
    public abstract ListValue relationshipsAsList();

    private static class PathReferencePrimitive
    extends PathReference {
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PathReferencePrimitive.class);
        private final long[] nodes;
        private final long[] relationships;

        PathReferencePrimitive(long[] nodes, long[] relationships) {
            this.nodes = nodes;
            this.relationships = relationships;
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE;
        }

        @Override
        public long startNodeId() {
            return this.nodes[0];
        }

        @Override
        public long endNodeId() {
            return this.nodes[this.nodes.length - 1];
        }

        @Override
        public long[] nodeIds() {
            return this.nodes;
        }

        @Override
        public long[] relationshipIds() {
            return this.relationships;
        }

        @Override
        public ListValue relationshipsAsList() {
            int size = this.relationships.length;
            ListValueBuilder builder = ListValueBuilder.newListBuilder(size);
            for (long relationship : this.relationships) {
                builder.add(VirtualValues.relationship(relationship));
            }
            return builder.build();
        }

        @Override
        public int size() {
            return this.relationships.length;
        }

        @Override
        public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
            writer.writePathReference(this.nodes, this.relationships);
        }

        @Override
        public ListValue asList() {
            int size = this.nodes.length + this.relationships.length;
            ListValueBuilder builder = ListValueBuilder.newListBuilder(size);
            for (int i = 0; i < size; ++i) {
                if (i % 2 == 0) {
                    builder.add(VirtualValues.node(this.nodes[i / 2]));
                    continue;
                }
                builder.add(VirtualValues.relationship(this.relationships[i / 2]));
            }
            return builder.build();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getTypeName() + "{");
            sb.append("(").append(this.nodes[0]).append(")");
            for (int i = 0; i < this.relationships.length; ++i) {
                sb.append("-");
                sb.append("[").append(this.relationships[i]).append("]");
                sb.append("-");
                sb.append("(").append(this.nodes[i + 1]).append(")");
            }
            sb.append('}');
            return sb.toString();
        }
    }

    private static class PathReferenceReferences
    extends PathReference {
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PathReferencePrimitive.class);
        private final VirtualNodeValue[] nodes;
        private final VirtualRelationshipValue[] relationships;

        PathReferenceReferences(VirtualNodeValue[] nodes, VirtualRelationshipValue[] relationships) {
            this.nodes = nodes;
            this.relationships = relationships;
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE;
        }

        @Override
        public long startNodeId() {
            return this.nodes[0].id();
        }

        @Override
        public long endNodeId() {
            return this.nodes[this.nodes.length - 1].id();
        }

        @Override
        public long[] nodeIds() {
            long[] res = new long[this.nodes.length];
            for (int i = 0; i < this.nodes.length; ++i) {
                res[i] = this.nodes[i].id();
            }
            return res;
        }

        @Override
        public long[] relationshipIds() {
            long[] res = new long[this.relationships.length];
            for (int i = 0; i < this.relationships.length; ++i) {
                res[i] = this.relationships[i].id();
            }
            return res;
        }

        @Override
        public ListValue relationshipsAsList() {
            return VirtualValues.fromRelationships(this.relationships);
        }

        @Override
        public int size() {
            return this.relationships.length;
        }

        @Override
        public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
            writer.writePathReference(this.nodes, this.relationships);
        }

        @Override
        public ListValue asList() {
            int size = this.nodes.length + this.relationships.length;
            ListValueBuilder builder = ListValueBuilder.newListBuilder(size);
            for (int i = 0; i < size; ++i) {
                if (i % 2 == 0) {
                    builder.add(this.nodes[i / 2]);
                    continue;
                }
                builder.add(this.relationships[i / 2]);
            }
            return builder.build();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getTypeName() + "{");
            sb.append("(").append(this.nodes[0].id()).append(")");
            for (int i = 0; i < this.relationships.length; ++i) {
                sb.append("-");
                sb.append("[").append(this.relationships[i].id()).append("]");
                sb.append("-");
                sb.append("(").append(this.nodes[i + 1].id()).append(")");
            }
            sb.append('}');
            return sb.toString();
        }
    }
}

