/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import java.util.List;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.NonPrimitiveArray;
import org.neo4j.values.storable.NumberArray;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.virtual.BooleanArrayList;
import org.neo4j.values.virtual.ByteArrayNumberList;
import org.neo4j.values.virtual.DoubleArrayNumberList;
import org.neo4j.values.virtual.FloatArrayNumberList;
import org.neo4j.values.virtual.IntArrayNumberList;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.LongArrayNumberList;
import org.neo4j.values.virtual.ShortArrayNumberList;

public class ListValueAsJava {
    private ListValueAsJava() {
    }

    public static List<?> asObject(ListValue.ArrayValueListValue value) {
        ArrayValue array = value.toStorableArray();
        if (array instanceof NumberArray) {
            NumberArray numberArray = (NumberArray)array;
            return ListValueAsJava.numberArrayAsObject(numberArray);
        }
        if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            return Arrays.asList(stringArray.asObject());
        }
        if (array instanceof BooleanArray) {
            BooleanArray booleanArray = (BooleanArray)array;
            return new BooleanArrayList(booleanArray.asObject());
        }
        if (array instanceof NonPrimitiveArray) {
            NonPrimitiveArray nonPrimitiveArray = (NonPrimitiveArray)array;
            return Arrays.asList(nonPrimitiveArray.asObject());
        }
        return null;
    }

    private static List<?> numberArrayAsObject(NumberArray array) {
        if (array instanceof DoubleArray) {
            DoubleArray doubleArray = (DoubleArray)array;
            return new DoubleArrayNumberList(doubleArray.asObject());
        }
        if (array instanceof FloatArray) {
            FloatArray floatArray = (FloatArray)array;
            return new FloatArrayNumberList(floatArray.asObject());
        }
        if (array instanceof IntArray) {
            IntArray intArray = (IntArray)array;
            return new IntArrayNumberList(intArray.asObject());
        }
        if (array instanceof LongArray) {
            LongArray longArray = (LongArray)array;
            return new LongArrayNumberList(longArray.asObject());
        }
        if (array instanceof ShortArray) {
            ShortArray shortArray = (ShortArray)array;
            return new ShortArrayNumberList(shortArray.asObject());
        }
        if (array instanceof ByteArray) {
            ByteArray byteArray = (ByteArray)array;
            return new ByteArrayNumberList(byteArray.asObjectCopy());
        }
        return null;
    }
}

