/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class ShortArray
extends IntegralArray {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ShortArray.class);
    private final short[] value;

    ShortArray(short[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public long longValue(int index) {
        return this.value[index];
    }

    @Override
    protected int computeHashToMemoize() {
        return NumberValues.hash(this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapShortArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(byte[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(short[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public boolean equals(int[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(long[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(float[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(double[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public short[] asObjectCopy() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Deprecated
    public short[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int offset) {
        return Values.shortValue(this.value[offset]);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }

    @Override
    public String getTypeName() {
        return "ShortArray";
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((short[])this.value);
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof ShortValue;
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        short[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = ((ShortValue)added).value();
        return new ShortArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        short[] newArray = new short[this.value.length + 1];
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        newArray[0] = ((ShortValue)prepended).value();
        return new ShortArray(newArray);
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.INT16_ARRAY;
    }
}

