/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class RelationshipReference
extends VirtualRelationshipValue {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipReference.class);
    private final long id;

    RelationshipReference(long id) {
        this.id = id;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.writeRelationshipReference(this.id);
    }

    @Override
    public String getTypeName() {
        return "RelationshipReference";
    }

    public String toString() {
        return String.format("-[%d]-", this.id);
    }

    @Override
    public long id() {
        return this.id;
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE;
    }
}

