/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.Comparison;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ArrayHelpers;
import org.neo4j.values.virtual.VirtualValueGroup;
import org.neo4j.values.virtual.VirtualValues;

public abstract class ListValue
extends VirtualValue
implements SequenceValue,
Iterable<AnyValue> {
    private static final long ARRAY_VALUE_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ArrayValueListValue.class);
    private static final long ARRAY_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ArrayListValue.class);
    private static final long JAVA_LIST_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(JavaListListValue.class);
    private static final long LIST_SLICE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ListSlice.class);
    private static final long REVERSED_LIST_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ReversedList.class);
    private static final long INTEGRAL_RANGE_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(IntegralRangeListValue.class);
    private static final long CONCAT_LIST_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ConcatList.class);
    private static final long APPEND_LIST_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AppendList.class);
    private static final long PREPEND_LIST_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PrependList.class);

    public abstract int size();

    @Override
    public abstract AnyValue value(int var1);

    @Override
    public String getTypeName() {
        return "List";
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean nonEmpty() {
        return this.size() != 0;
    }

    public boolean storable() {
        return false;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder().append(this.getTypeName()).append('{');
        for (i = 0; i < this.size() - 1; ++i) {
            sb.append(this.value(i));
            sb.append(", ");
        }
        if (this.size() > 0) {
            sb.append(this.value(i));
        }
        sb.append('}');
        return sb.toString();
    }

    public ArrayValue toStorableArray() {
        throw new UnsupportedOperationException("List cannot be turned into a storable array");
    }

    @Override
    public boolean isSequenceValue() {
        return true;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapSequence(this);
    }

    @Override
    public boolean equals(VirtualValue other) {
        return other != null && other.isSequenceValue() && this.equals((SequenceValue)((Object)other));
    }

    public AnyValue head() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("head of empty list");
        }
        return this.value(0);
    }

    public AnyValue last() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("last of empty list");
        }
        return this.value(size - 1);
    }

    @Override
    public Iterator<AnyValue> iterator() {
        return new Iterator<AnyValue>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < ListValue.this.size();
            }

            @Override
            public AnyValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ListValue.this.value(this.count++);
            }
        };
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.LIST;
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        ListValue otherList = (ListValue)other;
        return this.compareToSequence(otherList, comparator);
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        ListValue otherList = (ListValue)other;
        return this.ternaryCompareToSequence(otherList, comparator);
    }

    public AnyValue[] asArray() {
        switch (this.iterationPreference()) {
            case RANDOM_ACCESS: {
                return this.randomAccessAsArray();
            }
            case ITERATION: {
                return this.iterationAsArray();
            }
        }
        throw new IllegalStateException("not a valid iteration preference");
    }

    @Override
    protected int computeHashToMemoize() {
        switch (this.iterationPreference()) {
            case RANDOM_ACCESS: {
                return this.randomAccessComputeHash();
            }
            case ITERATION: {
                return this.iterationComputeHash();
            }
        }
        throw new IllegalStateException("not a valid iteration preference");
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        switch (this.iterationPreference()) {
            case RANDOM_ACCESS: {
                this.randomAccessWriteTo(writer);
                break;
            }
            case ITERATION: {
                this.iterationWriteTo(writer);
                break;
            }
            default: {
                throw new IllegalStateException("not a valid iteration preference");
            }
        }
    }

    public ListValue slice(int from, int to) {
        int t;
        int f = Math.max(from, 0);
        if (f > (t = Math.min(to, this.size()))) {
            return VirtualValues.EMPTY_LIST;
        }
        return new ListSlice(this, f, t);
    }

    public ListValue tail() {
        return this.slice(1, this.size());
    }

    public ListValue drop(int n) {
        int size = this.size();
        int start = Math.max(0, Math.min(n, size));
        return new ListSlice(this, start, size);
    }

    public ListValue take(int n) {
        int end = Math.max(0, Math.min(n, this.size()));
        return new ListSlice(this, 0, end);
    }

    public ListValue reverse() {
        return new ReversedList(this);
    }

    public ListValue append(AnyValue value) {
        return new AppendList(this, value);
    }

    public ListValue prepend(AnyValue value) {
        return new PrependList(this, value);
    }

    public ListValue distinct() {
        long keptValuesHeapSize = 0L;
        HashSet<AnyValue> seen = new HashSet<AnyValue>();
        ArrayList<AnyValue> kept = new ArrayList<AnyValue>();
        for (AnyValue value : this) {
            if (!seen.add(value)) continue;
            kept.add(value);
            keptValuesHeapSize += value.estimatedHeapUsage();
        }
        return new JavaListListValue(kept, keptValuesHeapSize);
    }

    private AnyValue[] iterationAsArray() {
        ArrayList<AnyValue> values = new ArrayList<AnyValue>();
        int size = 0;
        for (AnyValue value : this) {
            values.add(value);
            ++size;
        }
        return values.toArray(new AnyValue[size]);
    }

    private AnyValue[] randomAccessAsArray() {
        int size = this.size();
        AnyValue[] values = new AnyValue[size];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.value(i);
        }
        return values;
    }

    private int randomAccessComputeHash() {
        int hashCode = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hashCode = 31 * hashCode + this.value(i).hashCode();
        }
        return hashCode;
    }

    private int iterationComputeHash() {
        int hashCode = 1;
        for (AnyValue value : this) {
            hashCode = 31 * hashCode + value.hashCode();
        }
        return hashCode;
    }

    private <E extends Exception> void randomAccessWriteTo(AnyValueWriter<E> writer) throws E {
        writer.beginList(this.size());
        for (int i = 0; i < this.size(); ++i) {
            this.value(i).writeTo(writer);
        }
        writer.endList();
    }

    private <E extends Exception> void iterationWriteTo(AnyValueWriter<E> writer) throws E {
        writer.beginList(this.size());
        for (AnyValue value : this) {
            value.writeTo(writer);
        }
        writer.endList();
    }

    static final class PrependList
    extends ListValue {
        private final ListValue base;
        private final AnyValue prepended;

        PrependList(ListValue base, AnyValue prepended) {
            this.base = base;
            this.prepended = prepended;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.base.iterationPreference();
        }

        @Override
        public int size() {
            return 1 + this.base.size();
        }

        @Override
        public AnyValue value(int offset) {
            int size = this.base.size();
            if (offset < 1) {
                return this.prepended;
            }
            if (offset < size + 1) {
                return this.base.value(offset - 1);
            }
            throw new IndexOutOfBoundsException(offset + " is outside range " + size);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            switch (this.base.iterationPreference()) {
                case RANDOM_ACCESS: {
                    return super.iterator();
                }
                case ITERATION: {
                    return Iterators.prependTo(this.base.iterator(), (Object[])new AnyValue[]{this.prepended});
                }
            }
            throw new IllegalStateException("unknown iteration preference");
        }

        public long estimatedHeapUsage() {
            return PREPEND_LIST_SHALLOW_SIZE + this.base.estimatedHeapUsage() + this.prepended.estimatedHeapUsage();
        }
    }

    static final class AppendList
    extends ListValue {
        private final ListValue base;
        private final AnyValue appended;

        AppendList(ListValue base, AnyValue appended) {
            this.base = base;
            this.appended = appended;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.base.iterationPreference();
        }

        @Override
        public int size() {
            return this.base.size() + 1;
        }

        @Override
        public AnyValue value(int offset) {
            int size = this.base.size();
            if (offset < size) {
                return this.base.value(offset);
            }
            if (offset < size + 1) {
                return this.appended;
            }
            throw new IndexOutOfBoundsException(offset + " is outside range " + size);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            switch (this.base.iterationPreference()) {
                case RANDOM_ACCESS: {
                    return super.iterator();
                }
                case ITERATION: {
                    return Iterators.appendTo(this.base.iterator(), (Object[])new AnyValue[]{this.appended});
                }
            }
            throw new IllegalStateException("unknown iteration preference");
        }

        public long estimatedHeapUsage() {
            return APPEND_LIST_SHALLOW_SIZE + this.base.estimatedHeapUsage() + this.appended.estimatedHeapUsage();
        }
    }

    static final class ConcatList
    extends ListValue {
        private final ListValue[] lists;
        private int size = -1;

        ConcatList(ListValue[] lists) {
            this.lists = lists;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        @Override
        public int size() {
            if (this.size < 0) {
                int s = 0;
                for (ListValue list : this.lists) {
                    s += list.size();
                }
                this.size = s;
            }
            return this.size;
        }

        @Override
        public AnyValue value(int offset) {
            for (ListValue list : this.lists) {
                int size = list.size();
                if (offset < size) {
                    return list.value(offset);
                }
                offset -= size;
            }
            throw new IndexOutOfBoundsException();
        }

        public long estimatedHeapUsage() {
            int s = 0;
            for (ListValue list : this.lists) {
                s = (int)((long)s + list.estimatedHeapUsage());
            }
            return CONCAT_LIST_SHALLOW_SIZE + (long)s;
        }
    }

    static final class IntegralRangeListValue
    extends ListValue {
        private final long start;
        private final long end;
        private final long step;
        private int length = -1;

        IntegralRangeListValue(long start, long end, long step) {
            this.start = start;
            this.end = end;
            this.step = step;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public String toString() {
            return "Range(" + this.start + "..." + this.end + ", step = " + this.step + ")";
        }

        @Override
        public int size() {
            if (this.length == -1) {
                long l = (this.end - this.start) / this.step + 1L;
                if (l > 0x7FFFFFF7L) {
                    throw new OutOfMemoryError("Cannot index an collection of size " + l);
                }
                this.length = Math.max((int)l, 0);
            }
            return this.length;
        }

        @Override
        public AnyValue value(int offset) {
            if (offset >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return Values.longValue(this.start + (long)offset * this.step);
        }

        @Override
        protected int computeHashToMemoize() {
            int hashCode = 1;
            long current = this.start;
            int size = this.size();
            int i = 0;
            while (i < size) {
                hashCode = 31 * hashCode + Long.hashCode(current);
                ++i;
                current += this.step;
            }
            return hashCode;
        }

        public long estimatedHeapUsage() {
            return INTEGRAL_RANGE_LIST_VALUE_SHALLOW_SIZE;
        }
    }

    static final class ReversedList
    extends ListValue {
        private final ListValue inner;

        ReversedList(ListValue inner) {
            this.inner = inner;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.inner.iterationPreference();
        }

        @Override
        public int size() {
            return this.inner.size();
        }

        @Override
        public AnyValue value(int offset) {
            return this.inner.value(this.size() - 1 - offset);
        }

        public long estimatedHeapUsage() {
            return REVERSED_LIST_SHALLOW_SIZE + this.inner.estimatedHeapUsage();
        }
    }

    static final class ListSlice
    extends ListValue {
        private final ListValue inner;
        private final int from;
        private final int to;

        ListSlice(ListValue inner, int from, int to) {
            assert (from >= 0);
            assert (to <= inner.size());
            assert (from <= to);
            this.inner = inner;
            this.from = from;
            this.to = to;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.inner.iterationPreference();
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public AnyValue value(int offset) {
            return this.inner.value(offset + this.from);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            switch (this.inner.iterationPreference()) {
                case RANDOM_ACCESS: {
                    return super.iterator();
                }
                case ITERATION: {
                    return new PrefetchingIterator<AnyValue>(){
                        private int count;
                        private Iterator<AnyValue> innerIterator;
                        {
                            this.innerIterator = inner.iterator();
                        }

                        protected AnyValue fetchNextOrNull() {
                            while (this.count < from && this.innerIterator.hasNext()) {
                                this.innerIterator.next();
                                ++this.count;
                            }
                            if (this.count < from || this.count >= to || !this.innerIterator.hasNext()) {
                                return null;
                            }
                            ++this.count;
                            return this.innerIterator.next();
                        }
                    };
                }
            }
            throw new IllegalStateException("unknown iteration preference");
        }

        public long estimatedHeapUsage() {
            return LIST_SLICE_SHALLOW_SIZE + this.inner.estimatedHeapUsage();
        }
    }

    static final class JavaListListValue
    extends ListValue {
        private final List<AnyValue> values;
        private final long payloadSize;

        JavaListListValue(List<AnyValue> values, long payloadSize) {
            this.payloadSize = payloadSize;
            assert (values != null);
            assert (!ArrayHelpers.containsNull(values));
            this.values = values;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.ITERATION;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public AnyValue value(int offset) {
            return this.values.get(offset);
        }

        @Override
        public AnyValue[] asArray() {
            return this.values.toArray(new AnyValue[0]);
        }

        @Override
        protected int computeHashToMemoize() {
            return this.values.hashCode();
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return this.values.iterator();
        }

        public long estimatedHeapUsage() {
            return JAVA_LIST_LIST_VALUE_SHALLOW_SIZE + this.payloadSize;
        }
    }

    static final class ArrayListValue
    extends ListValue {
        private final AnyValue[] values;
        private final long payloadSize;

        ArrayListValue(AnyValue[] values, long payloadSize) {
            assert (values != null);
            this.payloadSize = HeapEstimator.shallowSizeOfObjectArray((int)values.length) + payloadSize;
            assert (!ArrayHelpers.containsNull(values));
            this.values = values;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public AnyValue value(int offset) {
            return this.values[offset];
        }

        @Override
        public AnyValue[] asArray() {
            return this.values;
        }

        @Override
        protected int computeHashToMemoize() {
            return Arrays.hashCode(this.values);
        }

        public long estimatedHeapUsage() {
            return ARRAY_LIST_VALUE_SHALLOW_SIZE + this.payloadSize;
        }
    }

    static final class ArrayValueListValue
    extends ListValue {
        private final ArrayValue array;

        ArrayValueListValue(ArrayValue array) {
            this.array = array;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public boolean storable() {
            return true;
        }

        @Override
        public ArrayValue toStorableArray() {
            return this.array;
        }

        @Override
        public int size() {
            return this.array.length();
        }

        @Override
        public AnyValue value(int offset) {
            return this.array.value(offset);
        }

        @Override
        protected int computeHashToMemoize() {
            return this.array.hashCode();
        }

        public long estimatedHeapUsage() {
            return ARRAY_VALUE_LIST_VALUE_SHALLOW_SIZE + this.array.estimatedHeapUsage();
        }
    }
}

