/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;

public class PrettyPrinter
implements AnyValueWriter<RuntimeException> {
    private final Deque<Writer> stack = new ArrayDeque<Writer>();
    private final String quoteMark;
    private final StringBuilder builder;
    private final AnyValueWriter.EntityMode entityMode;

    public PrettyPrinter() {
        this(AnyValueWriter.EntityMode.FULL);
    }

    public PrettyPrinter(AnyValueWriter.EntityMode entityMode) {
        this("\"", entityMode);
    }

    public PrettyPrinter(String quoteMark, AnyValueWriter.EntityMode entityMode) {
        this.quoteMark = quoteMark;
        this.entityMode = entityMode;
        this.builder = new StringBuilder(64);
        this.stack.push(new ValueWriter(this.builder, quoteMark));
    }

    @Override
    public AnyValueWriter.EntityMode entityMode() {
        return this.entityMode;
    }

    @Override
    public void writeNodeReference(long nodeId) {
        this.append("(id=").append(String.valueOf(nodeId)).append(")");
    }

    @Override
    public void writeNode(long nodeId, TextArray labels, MapValue properties) {
        this.append("(id=").append(String.valueOf(nodeId));
        String sep = " ";
        for (int i = 0; i < labels.length(); ++i) {
            this.append(sep);
            this.append(":").append(labels.stringValue(i));
            sep = "";
        }
        if (properties.size() > 0) {
            this.append(" ");
            properties.writeTo(this);
        }
        this.append(")");
    }

    @Override
    public void writeRelationshipReference(long relId) {
        this.append("-[id=").append(String.valueOf(relId)).append("]-");
    }

    @Override
    public void writeRelationship(long relId, long startNodeId, long endNodeId, TextValue type, MapValue properties) {
        this.append("-[id=").append(String.valueOf(relId)).append(" :").append(type.stringValue());
        if (properties.size() > 0) {
            this.append(" ");
            properties.writeTo(this);
        }
        this.append("]-");
    }

    @Override
    public void beginMap(int size) {
        this.stack.push(new MapWriter(this.builder, this.quoteMark));
    }

    @Override
    public void endMap() {
        assert (!this.stack.isEmpty());
        this.stack.pop().done();
        if (!this.stack.isEmpty()) {
            this.stack.peek().next();
        }
    }

    @Override
    public void beginList(int size) {
        this.stack.push(new ListWriter(this.builder, this.quoteMark));
    }

    @Override
    public void endList() {
        assert (!this.stack.isEmpty());
        this.stack.pop().done();
        if (!this.stack.isEmpty()) {
            this.stack.peek().next();
        }
    }

    @Override
    public void writePath(NodeValue[] nodes, RelationshipValue[] relationships) {
        if (nodes.length == 0) {
            return;
        }
        nodes[0].writeTo(this);
        for (int i = 0; i < relationships.length; ++i) {
            relationships[i].writeTo(this);
            this.append(">");
            nodes[i + 1].writeTo(this);
        }
    }

    @Override
    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws RuntimeException {
        this.append("{geometry: {type: \"Point\", coordinates: ");
        this.append(Arrays.toString(coordinate));
        this.append(", crs: {type: link, properties: {href: \"");
        this.append(crs.getHref());
        this.append("\", code: ");
        this.append(Integer.toString(crs.getCode()));
        this.append("}}}}");
    }

    @Override
    public void writeDuration(long months, long days, long seconds, int nanos) throws RuntimeException {
        this.append("{duration: {months: ");
        this.append(Long.toString(months));
        this.append(", days: ");
        this.append(Long.toString(days));
        this.append(", seconds: ");
        this.append(Long.toString(seconds));
        this.append(", nanos: ");
        this.append(Long.toString(nanos));
        this.append("}}");
    }

    @Override
    public void writeDate(LocalDate localDate) throws RuntimeException {
        this.append("{date: ");
        this.appendQuoted(localDate.toString());
        this.append("}");
    }

    @Override
    public void writeLocalTime(LocalTime localTime) throws RuntimeException {
        this.append("{localTime: ");
        this.appendQuoted(localTime.toString());
        this.append("}");
    }

    @Override
    public void writeTime(OffsetTime offsetTime) throws RuntimeException {
        this.append("{time: ");
        this.appendQuoted(offsetTime.toString());
        this.append("}");
    }

    @Override
    public void writeLocalDateTime(LocalDateTime localDateTime) throws RuntimeException {
        this.append("{localDateTime: ");
        this.appendQuoted(localDateTime.toString());
        this.append("}");
    }

    @Override
    public void writeDateTime(ZonedDateTime zonedDateTime) throws RuntimeException {
        this.append("{datetime: ");
        this.appendQuoted(zonedDateTime.toString());
        this.append("}");
    }

    @Override
    public void writeNull() {
        this.append("<null>");
    }

    @Override
    public void writeBoolean(boolean value) {
        this.append(Boolean.toString(value));
    }

    @Override
    public void writeInteger(byte value) {
        this.append(Byte.toString(value));
    }

    @Override
    public void writeInteger(short value) {
        this.append(Short.toString(value));
    }

    @Override
    public void writeInteger(int value) {
        this.append(Integer.toString(value));
    }

    @Override
    public void writeInteger(long value) {
        this.append(Long.toString(value));
    }

    @Override
    public void writeFloatingPoint(float value) {
        this.append(Float.toString(value));
    }

    @Override
    public void writeFloatingPoint(double value) {
        this.append(Double.toString(value));
    }

    @Override
    public void writeString(String value) {
        this.appendQuoted(value);
    }

    @Override
    public void writeString(char value) {
        this.writeString(Character.toString(value));
    }

    @Override
    public void beginArray(int size, ValueWriter.ArrayType arrayType) {
        this.stack.push(new ListWriter(this.builder, this.quoteMark));
    }

    @Override
    public void endArray() {
        assert (!this.stack.isEmpty());
        this.stack.pop().done();
    }

    @Override
    public void writeByteArray(byte[] value) {
        String sep = "";
        this.append("[");
        for (byte b : value) {
            this.append(sep);
            this.append(Byte.toString(b));
            sep = ", ";
        }
        this.append("]");
    }

    public String value() {
        assert (this.stack.size() == 1);
        this.stack.getLast().done();
        return this.builder.toString();
    }

    public void valueInto(StringBuilder target) {
        assert (this.stack.size() == 1);
        this.stack.getLast().done();
        target.append((CharSequence)this.builder);
    }

    private Writer append(String value) {
        assert (!this.stack.isEmpty());
        Writer head = this.stack.peek();
        head.append(value);
        return head;
    }

    private void appendQuoted(String value) {
        assert (!this.stack.isEmpty());
        Writer head = this.stack.peek();
        head.appendQuoted(value);
    }

    private class ListWriter
    extends BaseWriter {
        private String sep;

        ListWriter(StringBuilder builder, String quoteMark) {
            super(builder, quoteMark);
            this.sep = "";
            builder.append('[');
        }

        @Override
        public Writer append(String value) {
            this.builder.append(this.sep).append(value);
            this.sep = ", ";
            return this;
        }

        @Override
        public void appendQuoted(String value) {
            this.builder.append(this.sep).append(PrettyPrinter.this.quoteMark).append(value).append(PrettyPrinter.this.quoteMark);
            this.sep = ", ";
        }

        @Override
        public void done() {
            this.builder.append(']');
        }
    }

    private static class MapWriter
    extends BaseWriter {
        private boolean writeKey = true;
        private String sep = "";

        MapWriter(StringBuilder builder, String quoteMark) {
            super(builder, quoteMark);
            builder.append('{');
        }

        @Override
        public Writer append(String value) {
            if (this.writeKey) {
                this.builder.append(this.sep).append(value).append(": ");
            } else {
                this.builder.append(value);
            }
            this.writeKey = !this.writeKey;
            this.sep = ", ";
            return this;
        }

        @Override
        public void appendQuoted(String value) {
            if (this.writeKey) {
                this.append(value);
            } else {
                super.appendQuoted(value);
            }
        }

        @Override
        public void next() {
            this.writeKey = true;
        }

        @Override
        public void done() {
            this.builder.append('}');
        }
    }

    private static class ValueWriter
    extends BaseWriter {
        private ValueWriter(StringBuilder builder, String quoteMark) {
            super(builder, quoteMark);
        }

        @Override
        public Writer append(String value) {
            this.builder.append(value);
            return this;
        }
    }

    private static abstract class BaseWriter
    implements Writer {
        protected final StringBuilder builder;
        private final String quoteMark;

        protected BaseWriter(StringBuilder builder, String quoteMark) {
            this.builder = builder;
            this.quoteMark = quoteMark;
        }

        @Override
        public void appendQuoted(String value) {
            this.builder.append(this.quoteMark);
            this.append(value);
            this.builder.append(this.quoteMark);
        }

        @Override
        public void next() {
        }

        @Override
        public void done() {
        }
    }

    private static interface Writer {
        public Writer append(String var1);

        public void appendQuoted(String var1);

        public void next();

        public void done();
    }
}

