/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.LocalDateTime;
import java.util.Arrays;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public class LocalDateTimeArray
extends TemporalArray<LocalDateTime, LocalDateTimeValue> {
    private final LocalDateTime[] value;

    LocalDateTimeArray(LocalDateTime[] value) {
        assert (value != null);
        this.value = value;
    }

    protected LocalDateTime[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLocalDateTimeArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(LocalDateTime[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        this.writeTo(writer, ValueWriter.ArrayType.LOCAL_DATE_TIME, this.value);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.LOCAL_DATE_TIME_ARRAY;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((LocalDateTimeArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "LocalDateTimeArray";
    }
}

