/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.invoke.MethodHandle;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DurationBuilder;
import org.neo4j.values.storable.DurationFields;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InvalidValuesArgumentException;
import org.neo4j.values.utils.TemporalArithmeticException;
import org.neo4j.values.utils.TemporalUtil;
import org.neo4j.values.utils.UnsupportedTemporalUnitException;
import org.neo4j.values.virtual.MapValue;

public final class DurationValue
extends ScalarValue
implements TemporalAmount,
Comparable<DurationValue> {
    public static final DurationValue MIN_VALUE = DurationValue.duration(0L, 0L, Long.MIN_VALUE, 0L);
    public static final DurationValue MAX_VALUE = DurationValue.duration(0L, 0L, Long.MAX_VALUE, 999999999L);
    public static final DurationValue ZERO = new DurationValue(0L, 0L, 0L, 0L);
    private static final List<TemporalUnit> UNITS = Collections.unmodifiableList(Arrays.asList(ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS));
    private static final Comparator<DurationValue> COMPARATOR = Comparator.comparingLong(DurationValue::getAverageLengthInSeconds).thenComparingLong(d -> d.nanos).thenComparingLong(d -> d.months).thenComparingLong(d -> d.days).thenComparingLong(d -> d.seconds);
    private final long months;
    private final long days;
    private final long seconds;
    private final int nanos;
    private static final String UNIT_BASED_PATTERN = "(?:(?<years>[-+]?[0-9]+(?:[.,][0-9]+)?)Y)?(?:(?<months>[-+]?[0-9]+(?:[.,][0-9]+)?)M)?(?:(?<weeks>[-+]?[0-9]+(?:[.,][0-9]+)?)W)?(?:(?<days>[-+]?[0-9]+(?:[.,][0-9]+)?)D)?(?<T>T(?:(?<hours>[-+]?[0-9]+(?:[.,][0-9]+)?)H)?(?:(?<minutes>[-+]?[0-9]+(?:[.,][0-9]+)?)M)?(?:(?<seconds>[-+]?[0-9]+)(?:[.,](?<subseconds>[0-9]{1,9}))?S)?)?";
    private static final String DATE_BASED_PATTERN = "(?:(?<year>[0-9]{4})(?:-(?<longMonth>[0-9]{2})-(?<longDay>[0-9]{2})|(?<shortMonth>[0-9]{2})(?<shortDay>[0-9]{2})))?(?<time>T(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:[.,](?<shortSub>[0-9]{1,9}))?)?)?|(?<longHour>[0-9]{2}):(?<longMinute>[0-9]{2})(?::(?<longSecond>[0-9]{2})(?:[.,](?<longSub>[0-9]{1,9}))?)?))?";
    private static final Pattern PATTERN = Pattern.compile("(?<sign>[-+]?)P(?:(?:(?<years>[-+]?[0-9]+(?:[.,][0-9]+)?)Y)?(?:(?<months>[-+]?[0-9]+(?:[.,][0-9]+)?)M)?(?:(?<weeks>[-+]?[0-9]+(?:[.,][0-9]+)?)W)?(?:(?<days>[-+]?[0-9]+(?:[.,][0-9]+)?)D)?(?<T>T(?:(?<hours>[-+]?[0-9]+(?:[.,][0-9]+)?)H)?(?:(?<minutes>[-+]?[0-9]+(?:[.,][0-9]+)?)M)?(?:(?<seconds>[-+]?[0-9]+)(?:[.,](?<subseconds>[0-9]{1,9}))?S)?)?|(?:(?<year>[0-9]{4})(?:-(?<longMonth>[0-9]{2})-(?<longDay>[0-9]{2})|(?<shortMonth>[0-9]{2})(?<shortDay>[0-9]{2})))?(?<time>T(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:[.,](?<shortSub>[0-9]{1,9}))?)?)?|(?<longHour>[0-9]{2}):(?<longMinute>[0-9]{2})(?::(?<longSecond>[0-9]{2})(?:[.,](?<longSub>[0-9]{1,9}))?)?))?)", 2);

    public static DurationValue duration(Duration value) {
        Objects.requireNonNull(value, "Duration");
        return DurationValue.newDuration(0L, 0L, value.getSeconds(), value.getNano());
    }

    public static DurationValue duration(Period value) {
        Objects.requireNonNull(value, "Period");
        return DurationValue.newDuration(value.toTotalMonths(), value.getDays(), 0L, 0L);
    }

    public static DurationValue duration(long months, long days, long seconds, long nanos) {
        return DurationValue.newDuration(months, days, seconds, nanos);
    }

    public static DurationValue parse(CharSequence text) {
        return TemporalValue.parse(DurationValue.class, PATTERN, DurationValue::parse, text);
    }

    public static DurationValue parse(TextValue text) {
        return TemporalValue.parse(DurationValue.class, PATTERN, DurationValue::parse, text);
    }

    static DurationValue build(Map<String, ? extends AnyValue> input) {
        StructureBuilder<AnyValue, DurationValue> builder = DurationValue.builder();
        for (Map.Entry<String, ? extends AnyValue> entry : input.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public static DurationValue build(MapValue map) {
        return StructureBuilder.build(DurationValue.builder(), map);
    }

    public static DurationValue between(TemporalUnit unit, Temporal from, Temporal to) {
        if (unit == null) {
            return DurationValue.durationBetween(from, to);
        }
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case MONTHS: {
                    return DurationValue.newDuration(DurationValue.assertValidUntil(from, to, unit), 0L, 0L, 0L);
                }
                case DAYS: {
                    return DurationValue.newDuration(0L, DurationValue.assertValidUntil(from, to, unit), 0L, 0L);
                }
                case SECONDS: {
                    return DurationValue.durationInSecondsAndNanos(from, to);
                }
            }
            throw new UnsupportedTemporalUnitException("Unsupported unit: " + unit);
        }
        throw new UnsupportedTemporalUnitException("Unsupported unit: " + unit);
    }

    static StructureBuilder<AnyValue, DurationValue> builder() {
        return new DurationBuilder<AnyValue, DurationValue>(){

            @Override
            DurationValue create(AnyValue years, AnyValue months, AnyValue weeks, AnyValue days, AnyValue hours, AnyValue minutes, AnyValue seconds, AnyValue milliseconds, AnyValue microseconds, AnyValue nanoseconds) {
                return DurationValue.approximate(NumberValue.safeCastFloatingPoint("years", years, 0.0) * 12.0 + NumberValue.safeCastFloatingPoint("months", months, 0.0), NumberValue.safeCastFloatingPoint("weeks", weeks, 0.0) * 7.0 + NumberValue.safeCastFloatingPoint("days", days, 0.0), NumberValue.safeCastFloatingPoint("hours", hours, 0.0) * 3600.0 + NumberValue.safeCastFloatingPoint("minutes", minutes, 0.0) * 60.0 + NumberValue.safeCastFloatingPoint("seconds", seconds, 0.0), NumberValue.safeCastFloatingPoint("milliseconds", milliseconds, 0.0) * 1000000.0 + NumberValue.safeCastFloatingPoint("microseconds", microseconds, 0.0) * 1000.0 + NumberValue.safeCastFloatingPoint("nanoseconds", nanoseconds, 0.0));
            }
        };
    }

    private static DurationValue newDuration(long months, long days, long seconds, long nanos) {
        return seconds == 0L && days == 0L && months == 0L && nanos == 0L ? ZERO : new DurationValue(months, days, seconds, nanos);
    }

    private DurationValue(long months, long days, long seconds, long nanos) {
        this.assertNoOverflow(months, days, seconds, nanos);
        seconds = this.secondsWithNanos(seconds, nanos);
        if ((nanos %= 1000000000L) < 0L) {
            --seconds;
            nanos += 1000000000L;
        }
        this.months = months;
        this.days = days;
        this.seconds = seconds;
        this.nanos = (int)nanos;
    }

    @Override
    public int compareTo(DurationValue other) {
        return COMPARATOR.compare(this, other);
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareTo((DurationValue)otherValue);
    }

    private long getAverageLengthInSeconds() {
        return this.calcAverageLengthInSeconds(this.months, this.days, this.seconds);
    }

    private long calcAverageLengthInSeconds(long months, long days, long seconds) {
        long daysInSeconds = Math.multiplyExact(days, TemporalUtil.SECONDS_PER_DAY);
        long monthsInSeconds = Math.multiplyExact(months, 2629746L);
        return Math.addExact(seconds, Math.addExact(daysInSeconds, monthsInSeconds));
    }

    private long secondsWithNanos(long seconds, long nanos) {
        return Math.addExact(seconds, nanos / 1000000000L);
    }

    private void assertNoOverflow(long months, long days, long seconds, long nanos) {
        try {
            this.calcAverageLengthInSeconds(months, days, seconds);
            this.secondsWithNanos(seconds, nanos);
        }
        catch (ArithmeticException e) {
            throw this.invalidDuration(months, days, seconds, nanos, e);
        }
    }

    long nanosOfDay() {
        return this.seconds % TemporalUtil.SECONDS_PER_DAY * 1000000000L + (long)this.nanos;
    }

    long totalMonths() {
        return this.months;
    }

    long totalDays() {
        return this.days + this.seconds / TemporalUtil.SECONDS_PER_DAY;
    }

    private static DurationValue parse(Matcher matcher) {
        String year = matcher.group("year");
        String time = matcher.group("time");
        if (year != null || time != null) {
            return DurationValue.parseDateDuration(year, matcher, time != null);
        }
        return DurationValue.parseDuration(matcher);
    }

    private static DurationValue parseDuration(Matcher matcher) {
        int sign = "-".equals(matcher.group("sign")) ? -1 : 1;
        String y = matcher.group("years");
        String m = matcher.group("months");
        String w = matcher.group("weeks");
        String d = matcher.group("days");
        String t = matcher.group("T");
        if (y == null && m == null && w == null && d == null && t == null || "T".equalsIgnoreCase(t)) {
            return null;
        }
        int pos = DurationValue.fractionPoint(y);
        if (pos >= 0) {
            if (m != null || w != null || d != null || t != null) {
                return null;
            }
            return DurationValue.approximate(DurationValue.parseFractional(y, pos) * 12.0, 0.0, 0.0, 0.0);
        }
        long months = DurationValue.optLong(y) * 12L;
        pos = DurationValue.fractionPoint(m);
        if (pos >= 0) {
            if (w != null || d != null || t != null) {
                return null;
            }
            return DurationValue.approximate((double)months + DurationValue.parseFractional(m, pos), 0.0, 0.0, 0.0);
        }
        months += DurationValue.optLong(m);
        pos = DurationValue.fractionPoint(w);
        if (pos >= 0) {
            if (d != null || t != null) {
                return null;
            }
            return DurationValue.approximate(months, DurationValue.parseFractional(w, pos) * 7.0, 0.0, 0.0);
        }
        long days = DurationValue.optLong(w) * 7L;
        pos = DurationValue.fractionPoint(d);
        if (pos >= 0) {
            if (t != null) {
                return null;
            }
            return DurationValue.approximate(months, (double)days + DurationValue.parseFractional(d, pos), 0.0, 0.0);
        }
        return DurationValue.parseDuration(sign, months, days += DurationValue.optLong(d), matcher, false, "hours", "minutes", "seconds", "subseconds");
    }

    private static DurationValue parseDateDuration(String year, Matcher matcher, boolean time) {
        int sign = "-".equals(matcher.group("sign")) ? -1 : 1;
        long months = 0L;
        long days = 0L;
        if (year != null) {
            String day;
            String month = matcher.group("longMonth");
            if (month == null) {
                month = matcher.group("shortMonth");
                day = matcher.group("shortDay");
            } else {
                day = matcher.group("longDay");
            }
            months = Long.parseLong(month);
            if (months > 12L) {
                throw new InvalidValuesArgumentException("months is out of range: " + month);
            }
            months += Long.parseLong(year) * 12L;
            days = Long.parseLong(day);
            if (days > 31L) {
                throw new InvalidValuesArgumentException("days is out of range: " + day);
            }
        }
        if (time) {
            if (matcher.group("longHour") != null) {
                return DurationValue.parseDuration(sign, months, days, matcher, true, "longHour", "longMinute", "longSecond", "longSub");
            }
            return DurationValue.parseDuration(sign, months, days, matcher, true, "shortHour", "shortMinute", "shortSecond", "shortSub");
        }
        return DurationValue.duration((long)sign * months, (long)sign * days, 0L, 0L);
    }

    private static DurationValue parseDuration(int sign, long months, long days, Matcher matcher, boolean strict, String hour, String min, String sec, String sub) {
        String h = matcher.group(hour);
        String m = matcher.group(min);
        String s = matcher.group(sec);
        String n = matcher.group(sub);
        if (!strict) {
            int pos = DurationValue.fractionPoint(h);
            if (pos >= 0) {
                if (m != null || s != null) {
                    return null;
                }
                return DurationValue.approximate(months, days, DurationValue.parseFractional(h, pos) * 3600.0, 0.0);
            }
            pos = DurationValue.fractionPoint(m);
            if (pos >= 0) {
                if (s != null) {
                    return null;
                }
                return DurationValue.approximate(months, days, DurationValue.parseFractional(m, pos) * 60.0, 0.0);
            }
        }
        long hours = DurationValue.optLong(h);
        long minutes = DurationValue.optLong(m);
        long seconds = DurationValue.optLong(s);
        if (strict) {
            if (hours > 24L) {
                throw new InvalidValuesArgumentException("hours out of range: " + hours);
            }
            if (minutes > 60L) {
                throw new InvalidValuesArgumentException("minutes out of range: " + minutes);
            }
            if (seconds > 60L) {
                throw new InvalidValuesArgumentException("seconds out of range: " + seconds);
            }
        }
        seconds += hours * 3600L + minutes * 60L;
        long nanos = DurationValue.optLong(n);
        if (nanos != 0L) {
            for (int i = n.length(); i < 9; ++i) {
                nanos *= 10L;
            }
            if (s.startsWith("-")) {
                nanos = -nanos;
            }
        }
        return DurationValue.duration((long)sign * months, (long)sign * days, (long)sign * seconds, (long)sign * nanos);
    }

    private static double parseFractional(String input, int pos) {
        return Double.parseDouble(input.charAt(pos) == '.' ? input : input.substring(0, pos) + "." + input.substring(pos + 1));
    }

    private static int fractionPoint(String field) {
        if (field == null) {
            return -1;
        }
        int fractionPoint = field.indexOf(46);
        if (fractionPoint < 0) {
            fractionPoint = field.indexOf(44);
        }
        return fractionPoint;
    }

    private static long optLong(String value) {
        return value == null ? 0L : Long.parseLong(value);
    }

    static DurationValue durationBetween(Temporal from, Temporal to) {
        long months = 0L;
        long days = 0L;
        if (from.isSupported(ChronoField.EPOCH_DAY) && to.isSupported(ChronoField.EPOCH_DAY)) {
            months = DurationValue.assertValidUntil(from, to, ChronoUnit.MONTHS);
            try {
                from = from.plus(months, ChronoUnit.MONTHS);
            }
            catch (ArithmeticException | DateTimeException e) {
                throw new TemporalArithmeticException(e.getMessage(), e);
            }
            days = DurationValue.assertValidUntil(from, to, ChronoUnit.DAYS);
            try {
                from = from.plus(days, ChronoUnit.DAYS);
            }
            catch (ArithmeticException | DateTimeException e) {
                throw new TemporalArithmeticException(e.getMessage(), e);
            }
        }
        long nanos = DurationValue.assertValidUntil(from, to, ChronoUnit.NANOS);
        return DurationValue.newDuration(months, days, nanos / 1000000000L, nanos % 1000000000L);
    }

    private static DurationValue durationInSecondsAndNanos(Temporal from, Temporal to) {
        boolean differenceIsLessThanOneSecond;
        boolean negate = false;
        if (from.isSupported(ChronoField.OFFSET_SECONDS) && !to.isSupported(ChronoField.OFFSET_SECONDS)) {
            negate = true;
            Temporal tmp = from;
            from = to;
            to = tmp;
        }
        long seconds = DurationValue.assertValidUntil(from, to, ChronoUnit.SECONDS);
        int fromNanos = from.isSupported(ChronoField.NANO_OF_SECOND) ? from.get(ChronoField.NANO_OF_SECOND) : 0;
        int toNanos = to.isSupported(ChronoField.NANO_OF_SECOND) ? to.get(ChronoField.NANO_OF_SECOND) : 0;
        long nanos = toNanos - fromNanos;
        boolean bl = differenceIsLessThanOneSecond = seconds == 0L && from.isSupported(ChronoField.SECOND_OF_MINUTE) && to.isSupported(ChronoField.SECOND_OF_MINUTE) && from.get(ChronoField.SECOND_OF_MINUTE) != to.get(ChronoField.SECOND_OF_MINUTE);
        if (nanos < 0L && (seconds > 0L || differenceIsLessThanOneSecond)) {
            nanos = 1000000000L + nanos;
        } else if (nanos > 0L && (seconds < 0L || differenceIsLessThanOneSecond)) {
            nanos -= 1000000000L;
        }
        if (negate) {
            seconds = -seconds;
            nanos = -nanos;
        }
        return DurationValue.duration(0L, 0L, seconds, nanos);
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof DurationValue) {
            DurationValue that = (DurationValue)other;
            return that.months == this.months && that.days == this.days && that.seconds == this.seconds && that.nanos == this.nanos;
        }
        return false;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeDuration(this.months, this.days, this.seconds, this.nanos);
    }

    @Override
    public TemporalAmount asObjectCopy() {
        return this;
    }

    public String toString() {
        return this.prettyPrint();
    }

    @Override
    public String getTypeName() {
        return "Duration";
    }

    @Override
    public String prettyPrint() {
        if (this == ZERO) {
            return "PT0S";
        }
        StringBuilder str = new StringBuilder().append("P");
        DurationValue.append(str, this.months / 12L, 'Y');
        DurationValue.append(str, this.months % 12L, 'M');
        DurationValue.append(str, this.days, 'D');
        if (this.seconds != 0L || this.nanos != 0) {
            boolean negative = this.seconds < 0L;
            long s = this.seconds;
            int n = this.nanos;
            if (negative && this.nanos != 0) {
                ++s;
                n = (int)((long)n - 1000000000L);
            }
            str.append('T');
            DurationValue.append(str, s / 3600L, 'H');
            DurationValue.append(str, (s %= 3600L) / 60L, 'M');
            if ((s %= 60L) != 0L) {
                if (negative && s >= 0L && n != 0) {
                    str.append('-');
                }
                str.append(s);
                if (n != 0) {
                    this.nanos(str, n);
                }
                str.append('S');
            } else if (n != 0) {
                if (negative) {
                    str.append('-');
                }
                str.append('0');
                this.nanos(str, n);
                str.append('S');
            }
        }
        if (str.length() == 1) {
            str.append("T0S");
        }
        return str.toString();
    }

    private void nanos(StringBuilder str, int nanos) {
        str.append('.');
        int mod = 1000000000;
        for (int n = nanos < 0 ? -nanos : nanos; mod > 1 && n > 0; n %= mod) {
            str.append(n / (mod /= 10));
        }
    }

    private static void append(StringBuilder str, long quantity, char unit) {
        if (quantity != 0L) {
            str.append(quantity).append(unit);
        }
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.DURATION;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    protected int computeHash() {
        int result = (int)(this.months ^ this.months >>> 32);
        result = 31 * result + (int)(this.days ^ this.days >>> 32);
        result = 31 * result + (int)(this.seconds ^ this.seconds >>> 32);
        result = 31 * result + this.nanos;
        return result;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, this.months);
        hash = hashFunction.update(hash, this.days);
        hash = hashFunction.update(hash, this.seconds);
        hash = hashFunction.update(hash, (long)this.nanos);
        return hash;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDuration(this);
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case MONTHS: {
                    return this.months;
                }
                case DAYS: {
                    return this.days;
                }
                case SECONDS: {
                    return this.seconds;
                }
                case NANOS: {
                    return this.nanos;
                }
            }
        }
        throw new UnsupportedTemporalUnitException("Unsupported unit: " + unit);
    }

    public LongValue get(String fieldName) {
        long val = DurationFields.fromName(fieldName).asTimeStamp(this.months, this.days, this.seconds, this.nanos);
        return Values.longValue(val);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return UNITS;
    }

    public DurationValue plus(long amount, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case NANOS: {
                    return DurationValue.duration(this.months, this.days, this.seconds, (long)this.nanos + amount);
                }
                case MICROS: {
                    return DurationValue.duration(this.months, this.days, this.seconds, (long)this.nanos + amount * 1000L);
                }
                case MILLIS: {
                    return DurationValue.duration(this.months, this.days, this.seconds, (long)this.nanos + amount * 1000000L);
                }
                case SECONDS: {
                    return DurationValue.duration(this.months, this.days, this.seconds + amount, this.nanos);
                }
                case MINUTES: {
                    return DurationValue.duration(this.months, this.days, this.seconds + amount * 60L, this.nanos);
                }
                case HOURS: {
                    return DurationValue.duration(this.months, this.days, this.seconds + amount * 3600L, this.nanos);
                }
                case HALF_DAYS: {
                    return DurationValue.duration(this.months, this.days, this.seconds + amount * 12L * 3600L, this.nanos);
                }
                case DAYS: {
                    return DurationValue.duration(this.months, this.days + amount, this.seconds, this.nanos);
                }
                case WEEKS: {
                    return DurationValue.duration(this.months, this.days + amount * 7L, this.seconds, this.nanos);
                }
                case MONTHS: {
                    return DurationValue.duration(this.months + amount, this.days, this.seconds, this.nanos);
                }
                case YEARS: {
                    return DurationValue.duration(this.months + amount * 12L, this.days, this.seconds, this.nanos);
                }
                case DECADES: {
                    return DurationValue.duration(this.months + amount * 120L, this.days, this.seconds, this.nanos);
                }
                case CENTURIES: {
                    return DurationValue.duration(this.months + amount * 1200L, this.days, this.seconds, this.nanos);
                }
                case MILLENNIA: {
                    return DurationValue.duration(this.months + amount * 12000L, this.days, this.seconds, this.nanos);
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported unit: " + unit);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.months != 0L && temporal.isSupported(ChronoUnit.MONTHS)) {
            temporal = DurationValue.assertValidPlus(temporal, this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0L && temporal.isSupported(ChronoUnit.DAYS)) {
            temporal = DurationValue.assertValidPlus(temporal, this.days, ChronoUnit.DAYS);
        }
        if (this.seconds != 0L) {
            if (temporal.isSupported(ChronoUnit.SECONDS)) {
                temporal = DurationValue.assertValidPlus(temporal, this.seconds, ChronoUnit.SECONDS);
            } else {
                long asDays = this.seconds / TemporalUtil.SECONDS_PER_DAY;
                if (asDays != 0L) {
                    temporal = DurationValue.assertValidPlus(temporal, asDays, ChronoUnit.DAYS);
                }
            }
        }
        if (this.nanos != 0 && temporal.isSupported(ChronoUnit.NANOS)) {
            temporal = DurationValue.assertValidPlus(temporal, this.nanos, ChronoUnit.NANOS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.months != 0L && temporal.isSupported(ChronoUnit.MONTHS)) {
            temporal = DurationValue.assertValidMinus(temporal, this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0L && temporal.isSupported(ChronoUnit.DAYS)) {
            temporal = DurationValue.assertValidMinus(temporal, this.days, ChronoUnit.DAYS);
        }
        if (this.seconds != 0L) {
            long asDays;
            if (temporal.isSupported(ChronoUnit.SECONDS)) {
                temporal = DurationValue.assertValidMinus(temporal, this.seconds, ChronoUnit.SECONDS);
            } else if (temporal.isSupported(ChronoUnit.DAYS) && (asDays = this.seconds / TemporalUtil.SECONDS_PER_DAY) != 0L) {
                temporal = DurationValue.assertValidMinus(temporal, asDays, ChronoUnit.DAYS);
            }
        }
        if (this.nanos != 0 && temporal.isSupported(ChronoUnit.NANOS)) {
            temporal = DurationValue.assertValidMinus(temporal, this.nanos, ChronoUnit.NANOS);
        }
        return temporal;
    }

    public DurationValue add(DurationValue that) {
        try {
            return DurationValue.duration(Math.addExact(this.months, that.months), Math.addExact(this.days, that.days), Math.addExact(this.seconds, that.seconds), Math.addExact(this.nanos, that.nanos));
        }
        catch (ArithmeticException e) {
            throw this.invalidDurationAdd(this, that, e);
        }
    }

    public DurationValue sub(DurationValue that) {
        try {
            return DurationValue.duration(Math.subtractExact(this.months, that.months), Math.subtractExact(this.days, that.days), Math.subtractExact(this.seconds, that.seconds), Math.subtractExact(this.nanos, that.nanos));
        }
        catch (ArithmeticException e) {
            throw this.invalidDurationSubtract(this, that, e);
        }
    }

    public DurationValue mul(NumberValue number) {
        try {
            if (number instanceof IntegralValue) {
                long factor = number.longValue();
                return DurationValue.duration(Math.multiplyExact(this.months, factor), Math.multiplyExact(this.days, factor), Math.multiplyExact(this.seconds, factor), Math.multiplyExact((long)this.nanos, factor));
            }
            if (number instanceof FloatingPointValue) {
                double factor = number.doubleValue();
                return DurationValue.approximate((double)this.months * factor, (double)this.days * factor, (double)this.seconds * factor, (double)this.nanos * factor);
            }
        }
        catch (ArithmeticException e) {
            throw this.invalidDurationMultiply(this, number, e);
        }
        throw new InvalidValuesArgumentException("Factor must be either integer of floating point number.");
    }

    public DurationValue div(NumberValue number) {
        double divisor = number.doubleValue();
        try {
            return DurationValue.approximate((double)this.months / divisor, (double)this.days / divisor, (double)this.seconds / divisor, (double)this.nanos / divisor);
        }
        catch (ArithmeticException e) {
            throw this.invalidDurationDivision(this, number, e);
        }
    }

    public static DurationValue approximate(double months, double days, double seconds, double nanos) {
        long m = DurationValue.safeDoubleToLong(months);
        long d = DurationValue.safeDoubleToLong(days += 30.436875 * (months - (double)m));
        long s = DurationValue.safeDoubleToLong(seconds += (double)TemporalUtil.SECONDS_PER_DAY * (days - (double)d));
        long n = DurationValue.safeDoubleToLong(nanos += 1.0E9 * (seconds - (double)s));
        return DurationValue.duration(m, d, s, n);
    }

    private static long safeDoubleToLong(double d) {
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw new ArithmeticException("long overflow");
        }
        return (long)d;
    }

    private static Temporal assertValidPlus(Temporal temporal, long amountToAdd, TemporalUnit unit) {
        try {
            return temporal.plus(amountToAdd, unit);
        }
        catch (ArithmeticException | DateTimeException e) {
            throw new TemporalArithmeticException(e.getMessage(), e);
        }
    }

    private static Temporal assertValidMinus(Temporal temporal, long amountToAdd, TemporalUnit unit) {
        try {
            return temporal.minus(amountToAdd, unit);
        }
        catch (ArithmeticException | DateTimeException e) {
            throw new TemporalArithmeticException(e.getMessage(), e);
        }
    }

    private static long assertValidUntil(Temporal from, Temporal to, TemporalUnit unit) {
        try {
            return from.until(to, unit);
        }
        catch (UnsupportedTemporalTypeException e) {
            throw new UnsupportedTemporalUnitException(e.getMessage(), e);
        }
        catch (DateTimeException e) {
            throw new InvalidValuesArgumentException(e.getMessage(), e);
        }
    }

    private InvalidValuesArgumentException invalidDuration(long months, long days, long seconds, long nanos, ArithmeticException e) {
        return new InvalidValuesArgumentException(String.format("Invalid value for duration, will cause overflow. Value was months=%d, days=%d, seconds=%d, nanos=%d", months, days, seconds, nanos), e);
    }

    private InvalidValuesArgumentException invalidDurationAdd(DurationValue o1, DurationValue o2, ArithmeticException e) {
        return new InvalidValuesArgumentException(String.format("Can not add duration %s and %s without causing overflow.", o1.toString(), o2.toString()), e);
    }

    private InvalidValuesArgumentException invalidDurationSubtract(DurationValue o1, DurationValue o2, ArithmeticException e) {
        return new InvalidValuesArgumentException(String.format("Can not subtract duration %s and %s without causing overflow.", o1.toString(), o2.toString()), e);
    }

    private InvalidValuesArgumentException invalidDurationMultiply(DurationValue o1, NumberValue numberValue, ArithmeticException e) {
        return new InvalidValuesArgumentException(String.format("Can not multiply duration %s with %s without causing overflow.", o1.toString(), numberValue.toString()), e);
    }

    private InvalidValuesArgumentException invalidDurationDivision(DurationValue o1, NumberValue numberValue, ArithmeticException e) {
        return new InvalidValuesArgumentException(String.format("Can not divide duration %s with %s without causing overflow.", o1.toString(), numberValue.toString()), e);
    }

    public static abstract class Compiler<Input>
    extends DurationBuilder<Input, MethodHandle> {
    }
}

