/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class UTF8StringValue
extends StringValue {
    private static final int HIGH_BIT_MASK = 127;
    private static final int NON_CONTINUATION_BIT_MASK = 64;
    private volatile String value;
    private final byte[] bytes;
    private final int offset;
    private final int byteLength;

    UTF8StringValue(byte[] bytes, int offset, int length) {
        assert (bytes != null);
        this.bytes = bytes;
        this.offset = offset;
        this.byteLength = length;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeUTF8(this.bytes, this.offset, this.byteLength);
    }

    @Override
    public boolean equals(Value value) {
        if (value instanceof UTF8StringValue) {
            UTF8StringValue other = (UTF8StringValue)value;
            if (this.byteLength != other.byteLength) {
                return false;
            }
            int i = this.offset;
            int j = other.offset;
            while (i < this.byteLength) {
                if (this.bytes[i] != other.bytes[j]) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        return super.equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String value() {
        String s = this.value;
        if (s == null) {
            UTF8StringValue uTF8StringValue = this;
            synchronized (uTF8StringValue) {
                s = this.value;
                if (s == null) {
                    this.value = s = new String(this.bytes, this.offset, this.byteLength, StandardCharsets.UTF_8);
                }
            }
        }
        return s;
    }

    @Override
    public int length() {
        return UTF8StringValue.numberOfCodePoints(this.bytes, this.offset, this.byteLength);
    }

    private static int numberOfCodePoints(byte[] bytes, int offset, int byteLength) {
        int count = 0;
        int i = offset;
        int len = offset + byteLength;
        while (i < len) {
            byte b = bytes[i];
            if (b >= 0) {
                ++i;
                ++count;
                continue;
            }
            while (b < 0) {
                ++i;
                b = (byte)(b << 1);
            }
            ++count;
        }
        return count;
    }

    @Override
    public int computeHash() {
        if (this.bytes.length == 0 || this.byteLength == 0) {
            return 0;
        }
        CodePointCursor cpc = new CodePointCursor(this.bytes, this.offset);
        int hash = 1;
        int len = this.offset + this.byteLength;
        while (cpc.i < len) {
            hash = 31 * hash + (int)cpc.nextCodePoint();
        }
        return hash;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        CodePointCursor cpc = new CodePointCursor(this.bytes, this.offset);
        int len = this.offset + this.byteLength;
        while (cpc.i < len) {
            long codePointA = cpc.nextCodePoint() << 32;
            long codePointB = 0L;
            if (cpc.i < len) {
                codePointB = cpc.nextCodePoint();
            }
            hash = hashFunction.update(hash, codePointA + codePointB);
        }
        return hashFunction.update(hash, (long)cpc.codePointCount);
    }

    @Override
    public TextValue substring(int start, int length) {
        if (start < 0 || length < 0) {
            throw new IndexOutOfBoundsException("Cannot handle negative start index nor negative length");
        }
        if (length == 0) {
            return StringValue.EMPTY;
        }
        int end = start + length;
        byte[] values = this.bytes;
        int count = 0;
        int byteStart = -1;
        int byteEnd = -1;
        int i = this.offset;
        int len = this.offset + this.byteLength;
        while (i < len) {
            if (count == start) {
                byteStart = i;
            }
            if (count == end) {
                byteEnd = i;
                break;
            }
            byte b = values[i];
            if (b >= 0) {
                ++i;
            }
            while (b < 0) {
                ++i;
                b = (byte)(b << 1);
            }
            ++count;
        }
        if (byteEnd < 0) {
            byteEnd = len;
        }
        if (byteStart < 0) {
            return StringValue.EMPTY;
        }
        return new UTF8StringValue(values, byteStart, byteEnd - byteStart);
    }

    @Override
    public TextValue trim() {
        int endIndex;
        byte[] values = this.bytes;
        if (values.length == 0 || this.byteLength == 0) {
            return this;
        }
        int startIndex = this.trimLeftIndex();
        if (startIndex > (endIndex = this.trimRightIndex())) {
            return StringValue.EMPTY;
        }
        return new UTF8StringValue(values, startIndex, Math.max(endIndex + 1 - startIndex, 0));
    }

    @Override
    public TextValue ltrim() {
        byte[] values = this.bytes;
        if (values.length == 0 || this.byteLength == 0) {
            return this;
        }
        int startIndex = this.trimLeftIndex();
        if (startIndex >= values.length) {
            return StringValue.EMPTY;
        }
        return new UTF8StringValue(values, startIndex, values.length - startIndex);
    }

    @Override
    public TextValue rtrim() {
        byte[] values = this.bytes;
        if (values.length == 0 || this.byteLength == 0) {
            return this;
        }
        int endIndex = this.trimRightIndex();
        if (endIndex < 0) {
            return StringValue.EMPTY;
        }
        return new UTF8StringValue(values, this.offset, endIndex + 1 - this.offset);
    }

    @Override
    public TextValue plus(TextValue other) {
        if (other instanceof UTF8StringValue) {
            UTF8StringValue rhs = (UTF8StringValue)other;
            byte[] newBytes = new byte[this.byteLength + rhs.byteLength];
            System.arraycopy(this.bytes, this.offset, newBytes, 0, this.byteLength);
            System.arraycopy(rhs.bytes, rhs.offset, newBytes, this.byteLength, rhs.byteLength);
            return Values.utf8Value(newBytes);
        }
        return Values.stringValue(this.stringValue() + other.stringValue());
    }

    @Override
    public boolean startsWith(TextValue other) {
        if (other instanceof UTF8StringValue) {
            UTF8StringValue suffix = (UTF8StringValue)other;
            return this.startsWith(suffix, 0);
        }
        return this.value().startsWith(other.stringValue());
    }

    @Override
    public boolean endsWith(TextValue other) {
        if (other instanceof UTF8StringValue) {
            UTF8StringValue suffix = (UTF8StringValue)other;
            return this.startsWith(suffix, this.byteLength - suffix.byteLength);
        }
        return this.value().endsWith(other.stringValue());
    }

    @Override
    public boolean contains(TextValue other) {
        if (other instanceof UTF8StringValue) {
            UTF8StringValue substring = (UTF8StringValue)other;
            if (this.byteLength == 0) {
                return substring.byteLength == 0;
            }
            if (substring.byteLength == 0) {
                return true;
            }
            if (substring.byteLength > this.byteLength) {
                return false;
            }
            byte first = substring.bytes[substring.offset];
            int max = this.offset + this.byteLength - substring.byteLength;
            for (int pos = this.offset; pos <= max; ++pos) {
                int i;
                if (this.bytes[pos] != first) {
                    while (++pos <= max && this.bytes[pos] != first) {
                    }
                }
                if (pos > max) continue;
                int end = pos + substring.byteLength;
                int j = substring.offset + 1;
                for (i = pos + 1; i < end && this.bytes[i] == substring.bytes[j]; ++i) {
                    ++j;
                }
                if (i != end) continue;
                return true;
            }
            return false;
        }
        return this.value().contains(other.stringValue());
    }

    private boolean startsWith(UTF8StringValue prefix, int startPos) {
        int thisOffset = this.offset + startPos;
        int prefixOffset = prefix.offset;
        int prefixCount = prefix.byteLength;
        if (startPos < 0 || prefixCount > this.byteLength) {
            return false;
        }
        while (--prefixCount >= 0) {
            if (this.bytes[thisOffset++] == prefix.bytes[prefixOffset++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public TextValue reverse() {
        byte[] values = this.bytes;
        if (values.length == 0 || this.byteLength == 0) {
            return StringValue.EMPTY;
        }
        int i = this.offset;
        int len = this.offset + this.byteLength;
        byte[] newValues = new byte[this.byteLength];
        while (i < len) {
            byte b = values[i];
            if (b >= 0) {
                newValues[len - 1 - i] = b;
                ++i;
                continue;
            }
            int bytesNeeded = 0;
            while (b < 0) {
                ++bytesNeeded;
                b = (byte)(b << 1);
            }
            System.arraycopy(values, i, newValues, len - i - bytesNeeded, bytesNeeded);
            i += bytesNeeded;
        }
        return new UTF8StringValue(newValues, 0, newValues.length);
    }

    @Override
    public int compareTo(TextValue other) {
        if (!(other instanceof UTF8StringValue)) {
            return super.compareTo(other);
        }
        UTF8StringValue otherUTF8 = (UTF8StringValue)other;
        return UTF8StringValue.byteArrayCompare(this.bytes, this.offset, this.byteLength, otherUTF8.bytes, otherUTF8.offset, otherUTF8.byteLength);
    }

    public static int byteArrayCompare(byte[] value1, byte[] value2) {
        return UTF8StringValue.byteArrayCompare(value1, 0, value1.length, value2, 0, value2.length);
    }

    public static int byteArrayCompare(byte[] value1, int value1Offset, int value1Length, byte[] value2, int value2Offset, int value2Length) {
        int lim = Math.min(value1Length, value2Length);
        for (int i = 0; i < lim; ++i) {
            byte b1 = value1[i + value1Offset];
            byte b2 = value2[i + value2Offset];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return value1Length - value2Length;
    }

    @Override
    Matcher matcher(Pattern pattern) {
        return pattern.matcher(this.value());
    }

    private int trimLeftIndex() {
        int i = this.offset;
        int len = this.offset + this.byteLength;
        while (i < len) {
            byte b = this.bytes[i];
            if (b >= 0) {
                if (!Character.isWhitespace(b)) {
                    return i;
                }
                ++i;
                continue;
            }
            int bytesNeeded = 0;
            while (b < 0) {
                ++bytesNeeded;
                b = (byte)(b << 1);
            }
            int codePoint = UTF8StringValue.codePoint(this.bytes, b, i, bytesNeeded);
            if (!Character.isWhitespace(codePoint)) {
                return i;
            }
            i += bytesNeeded;
        }
        return i;
    }

    private int trimRightIndex() {
        int index = this.offset + this.byteLength - 1;
        while (index >= 0) {
            byte b = this.bytes[index];
            if (b >= 0) {
                if (!Character.isWhitespace(b)) {
                    return index;
                }
                --index;
                continue;
            }
            int bytesNeeded = 1;
            while ((b & 0x40) == 0) {
                ++bytesNeeded;
                b = this.bytes[--index];
            }
            int codePoint = UTF8StringValue.codePoint(this.bytes, (byte)(b << bytesNeeded), index, bytesNeeded);
            if (!Character.isWhitespace(codePoint)) {
                return Math.min(index + bytesNeeded - 1, this.bytes.length - 1);
            }
            --index;
        }
        return index;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    private static int codePoint(byte[] bytes, byte currentByte, int i, int bytesNeeded) {
        int codePoint;
        switch (bytesNeeded) {
            case 2: {
                codePoint = currentByte << 4 | bytes[i + 1] & 0x7F;
                break;
            }
            case 3: {
                codePoint = currentByte << 9 | (bytes[i + 1] & 0x7F) << 6 | bytes[i + 2] & 0x7F;
                break;
            }
            case 4: {
                codePoint = currentByte << 14 | (bytes[i + 1] & 0x7F) << 12 | (bytes[i + 2] & 0x7F) << 6 | bytes[i + 3] & 0x7F;
                break;
            }
            default: {
                throw new IllegalArgumentException("Malformed UTF8 value");
            }
        }
        return codePoint;
    }

    public static class CodePointCursor {
        private byte[] values;
        private int i;
        private int codePointCount;

        public CodePointCursor(byte[] values, int offset) {
            this.values = values;
            this.i = offset;
        }

        public long nextCodePoint() {
            ++this.codePointCount;
            byte b = this.values[this.i];
            if (b >= 0) {
                ++this.i;
                return b;
            }
            int bytesNeeded = 0;
            while (b < 0) {
                ++bytesNeeded;
                b = (byte)(b << 1);
            }
            int codePoint = UTF8StringValue.codePoint(this.values, b, this.i, bytesNeeded);
            this.i += bytesNeeded;
            return codePoint;
        }
    }
}

