/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.stream.StreamSupport;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValueGroup;
import org.neo4j.values.virtual.VirtualValues;

public abstract class MapValue
extends VirtualValue {
    public static MapValue EMPTY = new MapValue(){

        @Override
        public Iterable<String> keySet() {
            return Collections.emptyList();
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) {
        }

        @Override
        public boolean containsKey(String key) {
            return false;
        }

        @Override
        public AnyValue get(String key) {
            return Values.NO_VALUE;
        }

        @Override
        public int size() {
            return 0;
        }
    };

    @Override
    public int computeHash() {
        int[] h = new int[1];
        this.foreach((key, value) -> {
            h[0] = h[0] + (key.hashCode() ^ value.hashCode());
        });
        return h[0];
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.beginMap(this.size());
        this.foreach((s, anyValue) -> {
            writer.writeString((String)s);
            anyValue.writeTo(writer);
        });
        writer.endMap();
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (!(other instanceof MapValue)) {
            return false;
        }
        MapValue that = (MapValue)other;
        int size = this.size();
        if (size != that.size()) {
            return false;
        }
        Iterable<String> keys = this.keySet();
        for (String key : keys) {
            if (this.get(key).equals(that.get(key))) continue;
            return false;
        }
        return true;
    }

    public abstract Iterable<String> keySet();

    public ListValue keys() {
        String[] keys = new String[this.size()];
        int i = 0;
        for (String key : this.keySet()) {
            keys[i++] = key;
        }
        return VirtualValues.fromArray(Values.stringArray(keys));
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.MAP;
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (!(other instanceof MapValue)) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        MapValue otherMap = (MapValue)other;
        int size = this.size();
        int compare = Integer.compare(size, otherMap.size());
        if (compare == 0) {
            int i;
            String[] thisKeys = (String[])StreamSupport.stream(this.keySet().spliterator(), false).toArray(String[]::new);
            Arrays.sort(thisKeys, String::compareTo);
            String[] thatKeys = (String[])StreamSupport.stream(otherMap.keySet().spliterator(), false).toArray(String[]::new);
            Arrays.sort(thatKeys, String::compareTo);
            for (i = 0; i < size; ++i) {
                compare = thisKeys[i].compareTo(thatKeys[i]);
                if (compare == 0) continue;
                return compare;
            }
            for (i = 0; i < size; ++i) {
                String key = thisKeys[i];
                compare = comparator.compare(this.get(key), otherMap.get(key));
                if (compare == 0) continue;
                return compare;
            }
        }
        return compare;
    }

    @Override
    public Boolean ternaryEquals(AnyValue other) {
        if (other == null || other == Values.NO_VALUE) {
            return null;
        }
        if (!(other instanceof MapValue)) {
            return Boolean.FALSE;
        }
        MapValue otherMap = (MapValue)other;
        int size = this.size();
        if (size != otherMap.size()) {
            return Boolean.FALSE;
        }
        String[] thisKeys = (String[])StreamSupport.stream(this.keySet().spliterator(), false).toArray(String[]::new);
        Arrays.sort(thisKeys, String::compareTo);
        String[] thatKeys = (String[])StreamSupport.stream(otherMap.keySet().spliterator(), false).toArray(String[]::new);
        Arrays.sort(thatKeys, String::compareTo);
        for (int i = 0; i < size; ++i) {
            if (thisKeys[i].compareTo(thatKeys[i]) == 0) continue;
            return Boolean.FALSE;
        }
        Boolean equalityResult = Boolean.TRUE;
        for (int i = 0; i < size; ++i) {
            String key = thisKeys[i];
            Boolean s = this.get(key).ternaryEquals(otherMap.get(key));
            if (s == null) {
                equalityResult = null;
                continue;
            }
            if (s.booleanValue()) continue;
            return Boolean.FALSE;
        }
        return equalityResult;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapMap(this);
    }

    public abstract <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> var1) throws E;

    public abstract boolean containsKey(String var1);

    public abstract AnyValue get(String var1);

    public MapValue filter(BiFunction<String, AnyValue, Boolean> filterFunction) {
        return new FilteringMapValue(this, filterFunction);
    }

    public MapValue updatedWith(String key, AnyValue value) {
        AnyValue current = this.get(key);
        if (current.equals(value)) {
            return this;
        }
        if (current == Values.NO_VALUE) {
            return new UpdatedMapValue(this, new String[]{key}, new AnyValue[]{value});
        }
        return new MappedMapValue(this, (k, v) -> {
            if (k.equals(key)) {
                return value;
            }
            return v;
        });
    }

    public MapValue updatedWith(MapValue other) {
        return new CombinedMapValue(this, other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Map{");
        String[] sep = new String[]{""};
        this.foreach((key, value) -> {
            sb.append(sep[0]);
            sb.append((String)key);
            sb.append(" -> ");
            sb.append(value);
            sep[0] = ", ";
        });
        sb.append('}');
        return sb.toString();
    }

    public abstract int size();

    private static final class CombinedMapValue
    extends MapValue {
        private final MapValue[] maps;

        CombinedMapValue(MapValue ... mapValues) {
            this.maps = mapValues;
        }

        @Override
        public Iterable<String> keySet() {
            return () -> new PrefetchingIterator<String>(){
                private int mapIndex;
                private Iterator internal;

                protected String fetchNextOrNull() {
                    while (this.mapIndex < maps.length) {
                        if (this.internal == null || !this.internal.hasNext()) {
                            this.internal = maps[this.mapIndex++].keySet().iterator();
                        }
                        if (!this.internal.hasNext()) continue;
                        return (String)this.internal.next();
                    }
                    return null;
                }
            };
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            HashSet seen = new HashSet();
            ThrowingBiConsumer consume = (key, value) -> {
                if (seen.add(key)) {
                    f.accept(key, value);
                }
            };
            for (int i = this.maps.length - 1; i >= 0; --i) {
                this.maps[i].foreach(consume);
            }
        }

        @Override
        public boolean containsKey(String key) {
            for (MapValue map : this.maps) {
                if (!map.containsKey(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public AnyValue get(String key) {
            for (int i = this.maps.length - 1; i >= 0; --i) {
                AnyValue value = this.maps[i].get(key);
                if (value == Values.NO_VALUE) continue;
                return value;
            }
            return Values.NO_VALUE;
        }

        @Override
        public int size() {
            int[] size = new int[]{0};
            HashSet seen = new HashSet();
            ThrowingBiConsumer consume = (key, value) -> {
                if (seen.add(key)) {
                    size[0] = size[0] + 1;
                }
            };
            for (int i = this.maps.length - 1; i >= 0; --i) {
                this.maps[i].foreach(consume);
            }
            return size[0];
        }
    }

    private static final class UpdatedMapValue
    extends MapValue {
        private final MapValue map;
        private final String[] updatedKeys;
        private final AnyValue[] updatedValues;

        UpdatedMapValue(MapValue map, String[] updatedKeys, AnyValue[] updatedValues) {
            assert (updatedKeys.length == updatedValues.length);
            assert (!UpdatedMapValue.overlaps(map, updatedKeys));
            this.map = map;
            this.updatedKeys = updatedKeys;
            this.updatedValues = updatedValues;
        }

        private static boolean overlaps(MapValue map, String[] updatedKeys) {
            for (String key : updatedKeys) {
                if (!map.containsKey(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ListValue keys() {
            return VirtualValues.concat(this.map.keys(), VirtualValues.fromArray(Values.stringArray(this.updatedKeys)));
        }

        @Override
        public Iterable<String> keySet() {
            return () -> new Iterator<String>(){
                private int index;
                private Iterator internal;
                {
                    this.internal = map.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.internal.hasNext()) {
                        return true;
                    }
                    return this.index < updatedKeys.length;
                }

                @Override
                public String next() {
                    if (this.internal.hasNext()) {
                        return (String)this.internal.next();
                    }
                    if (this.index < updatedKeys.length) {
                        return updatedKeys[this.index++];
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            this.map.foreach(f);
            for (int i = 0; i < this.updatedKeys.length; ++i) {
                f.accept((Object)this.updatedKeys[i], (Object)this.updatedValues[i]);
            }
        }

        @Override
        public boolean containsKey(String key) {
            for (String updatedKey : this.updatedKeys) {
                if (!updatedKey.equals(key)) continue;
                return true;
            }
            return this.map.containsKey(key);
        }

        @Override
        public AnyValue get(String key) {
            for (int i = 0; i < this.updatedKeys.length; ++i) {
                if (!this.updatedKeys[i].equals(key)) continue;
                return this.updatedValues[i];
            }
            return this.map.get(key);
        }

        @Override
        public int size() {
            return this.map.size() + this.updatedKeys.length;
        }
    }

    private static final class MappedMapValue
    extends MapValue {
        private final MapValue map;
        private final BiFunction<String, AnyValue, AnyValue> mapFunction;

        MappedMapValue(MapValue map, BiFunction<String, AnyValue, AnyValue> mapFunction) {
            this.map = map;
            this.mapFunction = mapFunction;
        }

        @Override
        public ListValue keys() {
            return this.map.keys();
        }

        @Override
        public Iterable<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            this.map.foreach((s, anyValue) -> f.accept(s, (Object)this.mapFunction.apply((String)s, (AnyValue)anyValue)));
        }

        @Override
        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        @Override
        public AnyValue get(String key) {
            return this.mapFunction.apply(key, this.map.get(key));
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    private static final class FilteringMapValue
    extends MapValue {
        private final MapValue map;
        private final BiFunction<String, AnyValue, Boolean> filter;
        private int size = -1;

        FilteringMapValue(MapValue map, BiFunction<String, AnyValue, Boolean> filter) {
            this.map = map;
            this.filter = filter;
        }

        @Override
        public Iterable<String> keySet() {
            ArrayList<String> keys = this.size >= 0 ? new ArrayList<String>(this.size) : new ArrayList();
            this.foreach((key, value) -> {
                if (this.filter.apply((String)key, (AnyValue)value).booleanValue()) {
                    keys.add((String)key);
                }
            });
            return keys;
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            this.map.foreach((s, anyValue) -> {
                if (this.filter.apply((String)s, (AnyValue)anyValue).booleanValue()) {
                    f.accept(s, anyValue);
                }
            });
        }

        @Override
        public boolean containsKey(String key) {
            AnyValue value = this.map.get(key);
            if (value == Values.NO_VALUE) {
                return false;
            }
            return this.filter.apply(key, value);
        }

        @Override
        public AnyValue get(String key) {
            AnyValue value = this.map.get(key);
            if (value == Values.NO_VALUE) {
                return Values.NO_VALUE;
            }
            if (this.filter.apply(key, value).booleanValue()) {
                return value;
            }
            return Values.NO_VALUE;
        }

        @Override
        public int size() {
            if (this.size < 0) {
                this.size = 0;
                this.foreach((k, v) -> {
                    if (this.filter.apply((String)k, (AnyValue)v).booleanValue()) {
                        ++this.size;
                    }
                });
            }
            return this.size;
        }
    }

    static final class MapWrappingMapValue
    extends MapValue {
        private final Map<String, AnyValue> map;

        MapWrappingMapValue(Map<String, AnyValue> map) {
            this.map = map;
        }

        @Override
        public Iterable<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            for (Map.Entry<String, AnyValue> entry : this.map.entrySet()) {
                f.accept((Object)entry.getKey(), (Object)entry.getValue());
            }
        }

        @Override
        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        @Override
        public AnyValue get(String key) {
            return this.map.getOrDefault(key, Values.NO_VALUE);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }
}

