/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class CharArray
extends TextArray {
    private final char[] value;

    CharArray(char[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(char[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public boolean equals(String[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public int computeHash() {
        return NumberValues.hash(this.value);
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, (long)this.value.length);
        for (char c : this.value) {
            hash = CharValue.updateHash(hashFunction, hash, c);
        }
        return hash;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public String stringValue(int offset) {
        return Character.toString(this.value[offset]);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public char[] asObjectCopy() {
        return (char[])this.value.clone();
    }

    @Deprecated
    public char[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int position) {
        return Values.charValue(this.value[position]);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapCharArray(this);
    }

    public String toString() {
        return String.format("CharArray%s", Arrays.toString(this.value));
    }
}

