/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InvalidValuesArgumentException;
import org.neo4j.values.utils.TemporalArithmeticException;
import org.neo4j.values.utils.TemporalParseException;
import org.neo4j.values.utils.UnsupportedTemporalUnitException;

public abstract class TemporalValue<T extends Temporal, V extends TemporalValue<T, V>>
extends ScalarValue
implements Temporal {
    TemporalValue() {
    }

    public abstract TemporalValue add(DurationValue var1);

    public abstract TemporalValue sub(DurationValue var1);

    abstract T temporal();

    abstract LocalDate getDatePart();

    abstract LocalTime getLocalTimePart();

    abstract OffsetTime getTimePart(Supplier<ZoneId> var1);

    abstract ZoneId getZoneId(Supplier<ZoneId> var1);

    abstract ZoneId getZoneId();

    abstract ZoneOffset getZoneOffset();

    abstract boolean supportsTimeZone();

    abstract boolean hasTime();

    abstract V replacement(T var1);

    public final T asObjectCopy() {
        return this.temporal();
    }

    public final V with(TemporalAdjuster adjuster) {
        return this.replacement(this.temporal().with(adjuster));
    }

    public final V plus(TemporalAmount amount) {
        return this.replacement(this.temporal().plus(amount));
    }

    public final V minus(TemporalAmount amount) {
        return this.replacement(this.temporal().minus(amount));
    }

    public final V minus(long amountToSubtract, TemporalUnit unit) {
        return this.replacement(this.temporal().minus(amountToSubtract, unit));
    }

    @Override
    public final boolean isSupported(TemporalUnit unit) {
        return this.temporal().isSupported(unit);
    }

    public final V with(TemporalField field, long newValue) {
        return this.replacement(this.temporal().with(field, newValue));
    }

    public final V plus(long amountToAdd, TemporalUnit unit) {
        return this.replacement(this.temporal().plus(amountToAdd, unit));
    }

    @Override
    public final long until(Temporal endExclusive, TemporalUnit unit) {
        long until;
        if (!(endExclusive instanceof TemporalValue)) {
            throw new InvalidValuesArgumentException("Can only compute durations between TemporalValues.");
        }
        TemporalValue from = this;
        TemporalValue to = (TemporalValue)endExclusive;
        from = this.attachTime(from);
        to = this.attachTime(to);
        if (from.isSupported(ChronoField.MONTH_OF_YEAR) && !to.isSupported(ChronoField.MONTH_OF_YEAR)) {
            to = this.attachDate(to, from.getDatePart());
        } else if (to.isSupported(ChronoField.MONTH_OF_YEAR) && !from.isSupported(ChronoField.MONTH_OF_YEAR)) {
            from = this.attachDate(from, to.getDatePart());
        }
        if (from.supportsTimeZone() && !to.supportsTimeZone()) {
            to = this.attachTimeZone(to, from.getZoneId(from::getZoneOffset));
        } else if (to.supportsTimeZone() && !from.supportsTimeZone()) {
            from = this.attachTimeZone(from, to.getZoneId(to::getZoneOffset));
        }
        try {
            until = from.temporal().until(to, unit);
        }
        catch (UnsupportedTemporalTypeException e) {
            throw new UnsupportedTemporalUnitException(e.getMessage(), e);
        }
        return until;
    }

    private TemporalValue attachTime(TemporalValue temporal) {
        boolean supportsTime = temporal.isSupported(ChronoField.SECOND_OF_DAY);
        if (supportsTime) {
            return temporal;
        }
        LocalDate datePart = temporal.getDatePart();
        LocalTime timePart = LocalTimeValue.DEFAULT_LOCAL_TIME;
        return LocalDateTimeValue.localDateTime(LocalDateTime.of(datePart, timePart));
    }

    private TemporalValue attachDate(TemporalValue temporal, LocalDate dateToAttach) {
        LocalTime timePart = temporal.getLocalTimePart();
        if (temporal.supportsTimeZone()) {
            return DateTimeValue.datetime(ZonedDateTime.of(dateToAttach, timePart, temporal.getZoneOffset()));
        }
        return LocalDateTimeValue.localDateTime(LocalDateTime.of(dateToAttach, timePart));
    }

    private TemporalValue attachTimeZone(TemporalValue temporal, ZoneId zoneIdToAttach) {
        if (temporal.isSupported(ChronoField.MONTH_OF_YEAR)) {
            return DateTimeValue.datetime(ZonedDateTime.of(temporal.getDatePart(), temporal.getLocalTimePart(), zoneIdToAttach));
        }
        if (zoneIdToAttach instanceof ZoneOffset) {
            return TimeValue.time(OffsetTime.of(temporal.getLocalTimePart(), (ZoneOffset)zoneIdToAttach));
        }
        throw new IllegalStateException("Should only attach offsets to local times, not zone ids.");
    }

    @Override
    public final ValueRange range(TemporalField field) {
        return this.temporal().range(field);
    }

    @Override
    public final int get(TemporalField field) {
        int accessor;
        try {
            accessor = this.temporal().get(field);
        }
        catch (UnsupportedTemporalTypeException e) {
            throw new UnsupportedTemporalUnitException(e.getMessage(), e);
        }
        return accessor;
    }

    public final AnyValue get(String fieldName) {
        Field field = (Field)((Object)Field.fields.get(fieldName.toLowerCase()));
        if (field == Field.epochSeconds || field == Field.epochMillis) {
            T temp = this.temporal();
            if (temp instanceof ChronoZonedDateTime) {
                ChronoZonedDateTime zdt = (ChronoZonedDateTime)temp;
                if (field == Field.epochSeconds) {
                    return Values.longValue(zdt.toInstant().toEpochMilli() / 1000L);
                }
                return Values.longValue(zdt.toInstant().toEpochMilli());
            }
            throw new UnsupportedTemporalUnitException("Epoch not supported.");
        }
        if (field == Field.timezone) {
            return Values.stringValue(this.getZoneId(this::getZoneOffset).toString());
        }
        if (field == Field.offset) {
            return Values.stringValue(this.getZoneOffset().toString());
        }
        if (field == Field.offsetMinutes) {
            return Values.intValue(this.getZoneOffset().getTotalSeconds() / 60);
        }
        if (field == Field.offsetSeconds) {
            return Values.intValue(this.getZoneOffset().getTotalSeconds());
        }
        if (field == null || field.field == null) {
            throw new UnsupportedTemporalUnitException("No such field: " + fieldName);
        }
        return Values.intValue(this.get(field.field));
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        return this.temporal().query(query);
    }

    @Override
    public final boolean isSupported(TemporalField field) {
        return this.temporal().isSupported(field);
    }

    @Override
    public final long getLong(TemporalField field) {
        return this.temporal().getLong(field);
    }

    @Override
    public final NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public final boolean equals(boolean x) {
        return false;
    }

    @Override
    public final boolean equals(long x) {
        return false;
    }

    @Override
    public final boolean equals(double x) {
        return false;
    }

    @Override
    public final boolean equals(char x) {
        return false;
    }

    @Override
    public final boolean equals(String x) {
        return false;
    }

    public String toString() {
        return this.prettyPrint();
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, Function<Matcher, VALUE> parser, CharSequence text) {
        VALUE result;
        Matcher matcher = pattern.matcher(text);
        VALUE VALUE = result = matcher.matches() ? (VALUE)parser.apply(matcher) : null;
        if (result == null) {
            throw new TemporalParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text.toString(), 0);
        }
        return result;
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, Function<Matcher, VALUE> parser, TextValue text) {
        VALUE result;
        Matcher matcher = text.matcher(pattern);
        VALUE VALUE = result = matcher != null && matcher.matches() ? (VALUE)parser.apply(matcher) : null;
        if (result == null) {
            throw new TemporalParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text.stringValue(), 0);
        }
        return result;
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, BiFunction<Matcher, Supplier<ZoneId>, VALUE> parser, CharSequence text, Supplier<ZoneId> defaultZone) {
        VALUE result;
        Matcher matcher = pattern.matcher(text);
        VALUE VALUE = result = matcher.matches() ? (VALUE)parser.apply(matcher, defaultZone) : null;
        if (result == null) {
            throw new TemporalParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text.toString(), 0);
        }
        return result;
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, BiFunction<Matcher, Supplier<ZoneId>, VALUE> parser, TextValue text, Supplier<ZoneId> defaultZone) {
        VALUE result;
        Matcher matcher = text.matcher(pattern);
        VALUE VALUE = result = matcher != null && matcher.matches() ? (VALUE)parser.apply(matcher, defaultZone) : null;
        if (result == null) {
            throw new TemporalParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text.stringValue(), 0);
        }
        return result;
    }

    private static <VALUE> String valueName(Class<VALUE> type) {
        String name = type.getSimpleName();
        return name.substring(0, name.length() - 5);
    }

    public static TimeCSVHeaderInformation parseHeaderInformation(String text) {
        TimeCSVHeaderInformation fields = new TimeCSVHeaderInformation();
        Value.parseHeaderInformation(text, "time/datetime", fields);
        return fields;
    }

    private static AnyValue assignment(Field field, AnyValue oldValue, AnyValue newValue) {
        if (oldValue != null) {
            throw new InvalidValuesArgumentException("cannot re-assign " + (Object)((Object)field));
        }
        return newValue;
    }

    @SafeVarargs
    static void assertDefinedInOrder(Pair<AnyValue, String> ... values) {
        if (values[0].first() == null) {
            throw new InvalidValuesArgumentException((String)values[0].other() + " must be specified");
        }
        String firstNotAssigned = null;
        for (Pair<AnyValue, String> value : values) {
            if (value.first() == null) {
                if (firstNotAssigned != null) continue;
                firstNotAssigned = (String)value.other();
                continue;
            }
            if (firstNotAssigned == null) continue;
            throw new InvalidValuesArgumentException((String)value.other() + " cannot be specified without " + firstNotAssigned);
        }
    }

    @SafeVarargs
    static void assertAllDefined(Pair<AnyValue, String> ... values) {
        for (Pair<AnyValue, String> value : values) {
            if (value.first() != null) continue;
            throw new InvalidValuesArgumentException((String)value.other() + " must be specified");
        }
    }

    static AnyValue oneOf(AnyValue a, AnyValue b, AnyValue c) {
        return a != null ? a : (b != null ? b : c);
    }

    static ZoneId timezoneOf(AnyValue timezone) {
        if (timezone instanceof TextValue) {
            return DateTimeValue.parseZoneName(((TextValue)timezone).stringValue());
        }
        throw new UnsupportedOperationException("Cannot convert to ZoneId: " + timezone);
    }

    static int validNano(AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
        long ms = IntegralValue.safeCastIntegral("millisecond", millisecond, Field.millisecond.defaultValue);
        long us = IntegralValue.safeCastIntegral("microsecond", microsecond, Field.microsecond.defaultValue);
        long ns = IntegralValue.safeCastIntegral("nanosecond", nanosecond, Field.nanosecond.defaultValue);
        if (ms < 0L || ms >= 1000L) {
            throw new InvalidValuesArgumentException("Invalid millisecond: " + ms);
        }
        if (us < 0L || us >= (long)(millisecond != null ? 1000 : 1000000)) {
            throw new InvalidValuesArgumentException("Invalid microsecond: " + us);
        }
        if (ns < 0L || ns >= (long)(microsecond != null ? 1000 : (millisecond != null ? 1000000 : 1000000000))) {
            throw new InvalidValuesArgumentException("Invalid nanosecond: " + ns);
        }
        return (int)(ms * 1000000L + us * 1000L + ns);
    }

    static <TEMP extends Temporal> TEMP updateFieldMapWithConflictingSubseconds(Map<String, AnyValue> fields, TemporalUnit unit, TEMP truncated) {
        boolean conflictingMilliSeconds = false;
        boolean conflictingMicroSeconds = false;
        for (Map.Entry<String, AnyValue> entry : fields.entrySet()) {
            if (unit == ChronoUnit.MILLIS && ("microsecond".equals(entry.getKey()) || "nanosecond".equals(entry.getKey()))) {
                conflictingMilliSeconds = true;
                continue;
            }
            if (unit != ChronoUnit.MICROS || !"nanosecond".equals(entry.getKey())) continue;
            conflictingMicroSeconds = true;
        }
        if (conflictingMilliSeconds) {
            IntValue millis = Values.intValue(truncated.get(ChronoField.MILLI_OF_SECOND));
            AnyValue micros = fields.remove("microsecond");
            AnyValue nanos = fields.remove("nanosecond");
            int newNanos = TemporalValue.validNano(millis, micros, nanos);
            truncated = truncated.with(ChronoField.NANO_OF_SECOND, newNanos);
        } else if (conflictingMicroSeconds) {
            IntValue micros = Values.intValue(truncated.get(ChronoField.MICRO_OF_SECOND));
            AnyValue nanos = fields.remove("nanosecond");
            int newNanos = TemporalValue.validNano(null, micros, nanos);
            truncated = truncated.with(ChronoField.NANO_OF_SECOND, newNanos);
        }
        return truncated;
    }

    static <TEMP extends Temporal> TEMP assertValidArgument(Supplier<TEMP> func) {
        try {
            return (TEMP)((Temporal)func.get());
        }
        catch (DateTimeException e) {
            throw new InvalidValuesArgumentException(e.getMessage(), e);
        }
    }

    static <TEMP extends Temporal> TEMP assertValidUnit(Supplier<TEMP> func) {
        try {
            return (TEMP)((Temporal)func.get());
        }
        catch (DateTimeException e) {
            throw new UnsupportedTemporalUnitException(e.getMessage(), e);
        }
    }

    static <OFFSET extends ZoneId> OFFSET assertValidZone(Supplier<OFFSET> func) {
        try {
            return (OFFSET)((ZoneId)func.get());
        }
        catch (DateTimeException e) {
            throw new InvalidValuesArgumentException(e.getMessage(), e);
        }
    }

    static <TEMP extends Temporal> TEMP assertParsable(Supplier<TEMP> func) {
        try {
            return (TEMP)((Temporal)func.get());
        }
        catch (DateTimeException e) {
            throw new TemporalParseException(e.getMessage(), e);
        }
    }

    static String assertPrintable(Supplier<String> func) {
        try {
            return func.get();
        }
        catch (DateTimeException e) {
            throw new TemporalParseException(e.getMessage(), e);
        }
    }

    static <TEMP extends Temporal> TEMP assertValidArithmetic(Supplier<TEMP> func) {
        try {
            return (TEMP)((Temporal)func.get());
        }
        catch (ArithmeticException | DateTimeException e) {
            throw new TemporalArithmeticException(e.getMessage(), e);
        }
    }

    static Pair<LocalDate, LocalTime> getTruncatedDateAndTime(TemporalUnit unit, TemporalValue input, String type) {
        LocalTime truncatedTime;
        LocalDate truncatedDate;
        LocalTime localTime;
        if (unit.isTimeBased() && !(input instanceof DateTimeValue) && !(input instanceof LocalDateTimeValue)) {
            throw new UnsupportedTemporalUnitException(String.format("Cannot truncate %s to %s with a time based unit.", input, type));
        }
        LocalDate localDate = input.getDatePart();
        LocalTime localTime2 = localTime = input.hasTime() ? input.getLocalTimePart() : LocalTimeValue.DEFAULT_LOCAL_TIME;
        if (unit.isDateBased()) {
            truncatedDate = DateValue.truncateTo(localDate, unit);
            truncatedTime = LocalTimeValue.DEFAULT_LOCAL_TIME;
        } else {
            truncatedDate = localDate;
            truncatedTime = localTime.truncatedTo(unit);
        }
        return Pair.of((Object)truncatedDate, (Object)truncatedTime);
    }

    static class TimeCSVHeaderInformation
    implements CSVHeaderInformation {
        String timezone;

        TimeCSVHeaderInformation() {
        }

        @Override
        public void assign(String key, Object valueObj) {
            if (!(valueObj instanceof String)) {
                throw new InvalidValuesArgumentException(String.format("Cannot assign %s to field %s", valueObj, key));
            }
            String value = (String)valueObj;
            if ("timezone".equals(key.toLowerCase())) {
                if (this.timezone != null) {
                    throw new InvalidValuesArgumentException("Cannot set timezone twice");
                }
            } else {
                throw new InvalidValuesArgumentException("Unsupported header field: " + value);
            }
            this.timezone = value;
        }

        Supplier<ZoneId> zoneSupplier(Supplier<ZoneId> defaultSupplier) {
            if (this.timezone != null) {
                ZoneId tz = DateTimeValue.parseZoneName(this.timezone);
                return () -> tz;
            }
            return defaultSupplier;
        }
    }

    private static final class OrdinalDate
    extends ConstructDate {
        private AnyValue ordinalDay;

        OrdinalDate(AnyValue year, AnyValue date) {
            this.year = year;
            this.date = date;
        }

        @Override
        ConstructDate assign(Field field, AnyValue value) {
            switch (field) {
                case year: {
                    this.year = TemporalValue.assignment(field, this.year, value);
                    return this;
                }
                case ordinalDay: {
                    this.ordinalDay = TemporalValue.assignment(field, this.ordinalDay, value);
                    return this;
                }
                case datetime: 
                case date: {
                    this.date = TemporalValue.assignment(field, this.date, value);
                    return this;
                }
            }
            throw new UnsupportedTemporalUnitException("Cannot assign " + (Object)((Object)field) + " to ordinal date.");
        }

        @Override
        void assertFullyAssigned() {
            if (this.date == null) {
                TemporalValue.assertAllDefined(Pair.of((Object)this.year, (Object)"year"), Pair.of((Object)this.ordinalDay, (Object)"ordinalDay"));
            }
        }
    }

    private static final class QuarterDate
    extends ConstructDate {
        private AnyValue quarter;
        private AnyValue dayOfQuarter;

        QuarterDate(AnyValue year, AnyValue date) {
            this.year = year;
            this.date = date;
        }

        @Override
        ConstructDate assign(Field field, AnyValue value) {
            switch (field) {
                case year: {
                    this.year = TemporalValue.assignment(field, this.year, value);
                    return this;
                }
                case quarter: {
                    this.quarter = TemporalValue.assignment(field, this.quarter, value);
                    return this;
                }
                case dayOfQuarter: {
                    this.dayOfQuarter = TemporalValue.assignment(field, this.dayOfQuarter, value);
                    return this;
                }
                case datetime: 
                case date: {
                    this.date = TemporalValue.assignment(field, this.date, value);
                    return this;
                }
            }
            throw new UnsupportedTemporalUnitException("Cannot assign " + (Object)((Object)field) + " to quarter date.");
        }

        @Override
        void checkAssignments() {
            if (this.date == null) {
                TemporalValue.assertDefinedInOrder(Pair.of((Object)this.year, (Object)"year"), Pair.of((Object)this.quarter, (Object)"quarter"), Pair.of((Object)this.dayOfQuarter, (Object)"dayOfQuarter"));
            }
        }

        @Override
        void assertFullyAssigned() {
            if (this.date == null) {
                TemporalValue.assertAllDefined(Pair.of((Object)this.year, (Object)"year"), Pair.of((Object)this.quarter, (Object)"quarter"), Pair.of((Object)this.dayOfQuarter, (Object)"dayOfQuarter"));
            }
        }
    }

    private static final class WeekDate
    extends ConstructDate {
        private AnyValue week;
        private AnyValue dayOfWeek;

        WeekDate(AnyValue year, AnyValue date) {
            this.year = year;
            this.date = date;
        }

        @Override
        ConstructDate assign(Field field, AnyValue value) {
            switch (field) {
                case year: {
                    this.year = TemporalValue.assignment(field, this.year, value);
                    return this;
                }
                case week: {
                    this.week = TemporalValue.assignment(field, this.week, value);
                    return this;
                }
                case dayOfWeek: {
                    this.dayOfWeek = TemporalValue.assignment(field, this.dayOfWeek, value);
                    return this;
                }
                case datetime: 
                case date: {
                    this.date = TemporalValue.assignment(field, this.date, value);
                    return this;
                }
            }
            throw new UnsupportedTemporalUnitException("Cannot assign " + (Object)((Object)field) + " to week date.");
        }

        @Override
        void checkAssignments() {
            if (this.date == null) {
                TemporalValue.assertDefinedInOrder(Pair.of((Object)this.year, (Object)"year"), Pair.of((Object)this.week, (Object)"week"), Pair.of((Object)this.dayOfWeek, (Object)"dayOfWeek"));
            }
        }

        @Override
        void assertFullyAssigned() {
            if (this.date == null) {
                TemporalValue.assertAllDefined(Pair.of((Object)this.year, (Object)"year"), Pair.of((Object)this.week, (Object)"week"), Pair.of((Object)this.dayOfWeek, (Object)"dayOfWeek"));
            }
        }
    }

    private static final class CalendarDate
    extends ConstructDate {
        private AnyValue month;
        private AnyValue day;

        CalendarDate(AnyValue year, AnyValue date) {
            this.year = year;
            this.date = date;
        }

        @Override
        ConstructDate assign(Field field, AnyValue value) {
            switch (field) {
                case year: {
                    this.year = TemporalValue.assignment(field, this.year, value);
                    return this;
                }
                case month: {
                    this.month = TemporalValue.assignment(field, this.month, value);
                    return this;
                }
                case day: {
                    this.day = TemporalValue.assignment(field, this.day, value);
                    return this;
                }
                case datetime: 
                case date: {
                    this.date = TemporalValue.assignment(field, this.date, value);
                    return this;
                }
            }
            throw new UnsupportedTemporalUnitException("Cannot assign " + (Object)((Object)field) + " to calendar date.");
        }

        @Override
        void checkAssignments() {
            if (this.date == null) {
                TemporalValue.assertDefinedInOrder(Pair.of((Object)this.year, (Object)"year"), Pair.of((Object)this.month, (Object)"month"), Pair.of((Object)this.day, (Object)"day"));
            }
        }

        @Override
        void assertFullyAssigned() {
            if (this.date == null) {
                TemporalValue.assertAllDefined(Pair.of((Object)this.year, (Object)"year"), Pair.of((Object)this.month, (Object)"month"), Pair.of((Object)this.day, (Object)"day"));
            }
        }
    }

    private static class ConstructDate
    extends DateBuilder {
        AnyValue year;
        AnyValue date;

        ConstructDate() {
        }

        ConstructDate(AnyValue date) {
            this.date = date;
        }

        @Override
        ConstructDate assign(Field field, AnyValue value) {
            switch (field) {
                case year: {
                    this.year = TemporalValue.assignment(field, this.year, value);
                    return this;
                }
                case quarter: 
                case dayOfQuarter: {
                    return new QuarterDate(this.year, this.date).assign(field, value);
                }
                case month: 
                case day: {
                    return new CalendarDate(this.year, this.date).assign(field, value);
                }
                case week: 
                case dayOfWeek: {
                    return new WeekDate(this.year, this.date).assign(field, value);
                }
                case ordinalDay: {
                    return new OrdinalDate(this.year, this.date).assign(field, value);
                }
                case datetime: 
                case date: {
                    this.date = TemporalValue.assignment(field, this.date, value);
                    return this;
                }
            }
            throw new IllegalStateException("Not a date field: " + (Object)((Object)field));
        }

        @Override
        void checkAssignments() {
        }

        @Override
        void assertFullyAssigned() {
            if (this.date == null) {
                throw new InvalidValuesArgumentException(Field.month.name() + " must be specified");
            }
        }
    }

    private static final class ConstructTime {
        private AnyValue hour;
        private AnyValue minute;
        private AnyValue second;
        private AnyValue millisecond;
        private AnyValue microsecond;
        private AnyValue nanosecond;
        private AnyValue time;

        ConstructTime() {
        }

        void assign(Field field, AnyValue value) {
            switch (field) {
                case hour: {
                    this.hour = TemporalValue.assignment(field, this.hour, value);
                    break;
                }
                case minute: {
                    this.minute = TemporalValue.assignment(field, this.minute, value);
                    break;
                }
                case second: {
                    this.second = TemporalValue.assignment(field, this.second, value);
                    break;
                }
                case millisecond: {
                    this.millisecond = TemporalValue.assignment(field, this.millisecond, value);
                    break;
                }
                case microsecond: {
                    this.microsecond = TemporalValue.assignment(field, this.microsecond, value);
                    break;
                }
                case nanosecond: {
                    this.nanosecond = TemporalValue.assignment(field, this.nanosecond, value);
                    break;
                }
                case time: 
                case datetime: {
                    this.time = TemporalValue.assignment(field, this.time, value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Not a time field: " + (Object)((Object)field));
                }
            }
        }

        void checkAssignments() {
            if (this.time == null) {
                TemporalValue.assertDefinedInOrder(Pair.of((Object)this.hour, (Object)"hour"), Pair.of((Object)this.minute, (Object)"minute"), Pair.of((Object)this.second, (Object)"second"), Pair.of((Object)TemporalValue.oneOf(this.millisecond, this.microsecond, this.nanosecond), (Object)"subsecond"));
            }
        }
    }

    private static abstract class DateBuilder {
        private DateBuilder() {
        }

        abstract DateBuilder assign(Field var1, AnyValue var2);

        abstract void checkAssignments();

        abstract void assertFullyAssigned();
    }

    private static class SelectDateOrTimeDTBuilder
    extends DateTimeBuilder {
        SelectDateOrTimeDTBuilder(DateBuilder date, ConstructTime time) {
            super(date, time);
        }

        @Override
        DateTimeBuilder assign(Field field, AnyValue value) {
            if (field == Field.datetime || field == Field.epochSeconds || field == Field.epochMillis) {
                throw new InvalidValuesArgumentException(field.name() + " cannot be selected together with date or time.");
            }
            return this.assignToSubBuilders(field, value);
        }
    }

    private static class SelectDateTimeDTBuilder
    extends DateTimeBuilder {
        private AnyValue datetime;
        private AnyValue epochSeconds;
        private AnyValue epochMillis;

        SelectDateTimeDTBuilder(DateBuilder date, ConstructTime time) {
            super(date, time);
        }

        @Override
        void checkAssignments(boolean requiresDate) {
        }

        @Override
        DateTimeBuilder assign(Field field, AnyValue value) {
            if (field == Field.date || field == Field.time) {
                throw new InvalidValuesArgumentException(field.name() + " cannot be selected together with datetime or epochSeconds or epochMillis.");
            }
            if (field == Field.datetime) {
                if (this.epochSeconds != null) {
                    throw new InvalidValuesArgumentException(field.name() + " cannot be selected together with epochSeconds.");
                }
                if (this.epochMillis != null) {
                    throw new InvalidValuesArgumentException(field.name() + " cannot be selected together with epochMillis.");
                }
                this.datetime = TemporalValue.assignment(Field.datetime, this.datetime, value);
            } else if (field == Field.epochSeconds) {
                if (this.epochMillis != null) {
                    throw new InvalidValuesArgumentException(field.name() + " cannot be selected together with epochMillis.");
                }
                if (this.datetime != null) {
                    throw new InvalidValuesArgumentException(field.name() + " cannot be selected together with datetime.");
                }
                this.epochSeconds = TemporalValue.assignment(Field.epochSeconds, this.epochSeconds, value);
            } else if (field == Field.epochMillis) {
                if (this.epochSeconds != null) {
                    throw new InvalidValuesArgumentException(field.name() + " cannot be selected together with epochSeconds.");
                }
                if (this.datetime != null) {
                    throw new InvalidValuesArgumentException(field.name() + " cannot be selected together with datetime.");
                }
                this.epochMillis = TemporalValue.assignment(Field.epochMillis, this.epochMillis, value);
            } else {
                return this.assignToSubBuilders(field, value);
            }
            return this;
        }
    }

    private static class DateTimeBuilder {
        protected DateBuilder date;
        protected ConstructTime time;

        DateTimeBuilder() {
        }

        DateTimeBuilder(DateBuilder date, ConstructTime time) {
            this.date = date;
            this.time = time;
        }

        void checkAssignments(boolean requiresDate) {
            if (this.date != null) {
                this.date.checkAssignments();
            }
            if (this.time != null) {
                if (requiresDate) {
                    if (this.date != null) {
                        this.date.assertFullyAssigned();
                    } else {
                        throw new InvalidValuesArgumentException(Field.year.name() + " must be specified");
                    }
                }
                this.time.checkAssignments();
            }
        }

        DateTimeBuilder assign(Field field, AnyValue value) {
            if (field == Field.datetime || field == Field.epochSeconds || field == Field.epochMillis) {
                return new SelectDateTimeDTBuilder(this.date, this.time).assign(field, value);
            }
            if (field == Field.time || field == Field.date) {
                return new SelectDateOrTimeDTBuilder(this.date, this.time).assign(field, value);
            }
            return this.assignToSubBuilders(field, value);
        }

        DateTimeBuilder assignToSubBuilders(Field field, AnyValue value) {
            if (field == Field.date || field.field != null && field.field.isDateBased()) {
                if (this.date == null) {
                    this.date = new ConstructDate();
                }
                this.date = this.date.assign(field, value);
            } else if (field == Field.time || field.field != null && field.field.isTimeBased()) {
                if (this.time == null) {
                    this.time = new ConstructTime();
                }
                this.time.assign(field, value);
            } else {
                throw new IllegalStateException("This method should not be used for any fields the DateBuilder or TimeBuilder can't handle");
            }
            return this;
        }
    }

    protected static class Field
    extends Enum<Field> {
        public static final /* enum */ Field year = new Field(ChronoField.YEAR, 0);
        public static final /* enum */ Field quarter = new Field(IsoFields.QUARTER_OF_YEAR, 1);
        public static final /* enum */ Field month = new Field(ChronoField.MONTH_OF_YEAR, 1);
        public static final /* enum */ Field week = new Field(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1);
        public static final /* enum */ Field ordinalDay = new Field(ChronoField.DAY_OF_YEAR, 1);
        public static final /* enum */ Field dayOfQuarter = new Field(IsoFields.DAY_OF_QUARTER, 1);
        public static final /* enum */ Field dayOfWeek = new Field(ChronoField.DAY_OF_WEEK, 1);
        public static final /* enum */ Field day = new Field(ChronoField.DAY_OF_MONTH, 1);
        public static final /* enum */ Field hour = new Field(ChronoField.HOUR_OF_DAY, 0);
        public static final /* enum */ Field minute = new Field(ChronoField.MINUTE_OF_HOUR, 0);
        public static final /* enum */ Field second = new Field(ChronoField.SECOND_OF_MINUTE, 0);
        public static final /* enum */ Field millisecond = new Field(ChronoField.MILLI_OF_SECOND, 0);
        public static final /* enum */ Field microsecond = new Field(ChronoField.MICRO_OF_SECOND, 0);
        public static final /* enum */ Field nanosecond = new Field(ChronoField.NANO_OF_SECOND, 0);
        public static final /* enum */ Field weekYear = new Field(IsoFields.WEEK_BASED_YEAR, 0){

            @Override
            void assign(Builder<?> builder, AnyValue value) {
                throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
            }
        };
        public static final /* enum */ Field offset = new Field(){

            @Override
            void assign(Builder<?> builder, AnyValue value) {
                throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
            }
        };
        public static final /* enum */ Field offsetMinutes = new Field(){

            @Override
            void assign(Builder<?> builder, AnyValue value) {
                throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
            }
        };
        public static final /* enum */ Field offsetSeconds = new Field(){

            @Override
            void assign(Builder<?> builder, AnyValue value) {
                throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
            }
        };
        public static final /* enum */ Field timezone = new Field(){

            @Override
            void assign(Builder<?> builder, AnyValue value) {
                if (!builder.supportsTimeZone()) {
                    throw new UnsupportedTemporalUnitException("Cannot assign time zone if also assigning other fields.");
                }
                if (builder.timezone != null) {
                    throw new InvalidValuesArgumentException("Cannot assign timezone twice.");
                }
                builder.timezone = value;
            }
        };
        public static final /* enum */ Field date = new Field(){

            @Override
            void assign(Builder<?> builder, AnyValue value) {
                if (!builder.supportsDate()) {
                    throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
                }
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.assign(this, value);
            }

            @Override
            boolean isGroupSelector() {
                return true;
            }
        };
        public static final /* enum */ Field time = new Field(){

            @Override
            void assign(Builder<?> builder, AnyValue value) {
                if (!builder.supportsTime()) {
                    throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
                }
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.assign(this, value);
            }

            @Override
            boolean isGroupSelector() {
                return true;
            }
        };
        public static final /* enum */ Field datetime = new Field(){

            @Override
            void assign(Builder<?> builder, AnyValue value) {
                if (!builder.supportsDate() || !builder.supportsTime()) {
                    throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
                }
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.assign(this, value);
            }

            @Override
            boolean isGroupSelector() {
                return true;
            }
        };
        public static final /* enum */ Field epochSeconds = new Field(){

            @Override
            void assign(Builder<?> builder, AnyValue value) {
                if (!builder.supportsEpoch()) {
                    throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
                }
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.assign(this, value);
            }

            @Override
            boolean isGroupSelector() {
                return true;
            }
        };
        public static final /* enum */ Field epochMillis = new Field(){

            @Override
            void assign(Builder<?> builder, AnyValue value) {
                if (!builder.supportsEpoch()) {
                    throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
                }
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.assign(this, value);
            }

            @Override
            boolean isGroupSelector() {
                return true;
            }
        };
        private static final Map<String, Field> fields;
        final TemporalField field;
        final int defaultValue;
        private static final /* synthetic */ Field[] $VALUES;

        public static Field[] values() {
            return (Field[])$VALUES.clone();
        }

        public static Field valueOf(String name) {
            return Enum.valueOf(Field.class, name);
        }

        private Field(TemporalField field, int defaultValue) {
            this.field = field;
            this.defaultValue = defaultValue;
        }

        private Field() {
            this.field = null;
            this.defaultValue = -1;
        }

        boolean isGroupSelector() {
            return false;
        }

        void assign(Builder<?> builder, AnyValue value) {
            assert (this.field != null) : "method should have been overridden";
            if (!((Builder)builder).supports(this.field)) {
                throw new UnsupportedTemporalUnitException("Not supported: " + this.name());
            }
            if (((Builder)builder).state == null) {
                ((Builder)builder).state = new DateTimeBuilder();
            }
            ((Builder)builder).state = ((Builder)builder).state.assign(this, value);
        }

        static {
            $VALUES = new Field[]{year, quarter, month, week, ordinalDay, dayOfQuarter, dayOfWeek, day, hour, minute, second, millisecond, microsecond, nanosecond, weekYear, offset, offsetMinutes, offsetSeconds, timezone, date, time, datetime, epochSeconds, epochMillis};
            fields = new HashMap<String, Field>();
            for (Field field : Field.values()) {
                fields.put(field.name().toLowerCase(), field);
            }
            fields.put("weekday", dayOfWeek);
            fields.put("quarterday", dayOfQuarter);
        }
    }

    static abstract class Builder<Result>
    implements StructureBuilder<AnyValue, Result> {
        private final Supplier<ZoneId> defaultZone;
        private DateTimeBuilder state;
        protected AnyValue timezone;
        protected Map<Field, AnyValue> fields = new EnumMap<Field, AnyValue>(Field.class);

        Builder(Supplier<ZoneId> defaultZone) {
            this.defaultZone = defaultZone;
        }

        @Override
        public final Result build() {
            if (this.state == null) {
                throw new InvalidValuesArgumentException("Builder state empty");
            }
            this.state.checkAssignments(this.supportsDate());
            return this.buildInternal();
        }

        <Temp extends Temporal> Temp assignAllFields(Temp temp) {
            Object result = temp;
            for (Map.Entry<Field, AnyValue> entry : this.fields.entrySet()) {
                Field f = entry.getKey();
                if (f.isGroupSelector() || f == Field.timezone || f == Field.millisecond || f == Field.microsecond || f == Field.nanosecond) continue;
                TemporalField temporalField = f.field;
                result = result.with(temporalField, IntegralValue.safeCastIntegral(f.name(), entry.getValue(), f.defaultValue));
            }
            if (this.supportsTime() && (this.fields.containsKey((Object)Field.millisecond) || this.fields.containsKey((Object)Field.microsecond) || this.fields.containsKey((Object)Field.nanosecond))) {
                result = result.with(Field.nanosecond.field, TemporalValue.validNano(this.fields.get((Object)Field.millisecond), this.fields.get((Object)Field.microsecond), this.fields.get((Object)Field.nanosecond)));
            }
            return result;
        }

        @Override
        public final StructureBuilder<AnyValue, Result> add(String fieldName, AnyValue value) {
            Field field = (Field)((Object)Field.fields.get(fieldName.toLowerCase()));
            if (field == null) {
                throw new InvalidValuesArgumentException("No such field: " + fieldName);
            }
            field.assign(this, value);
            this.fields.put(field, value);
            return this;
        }

        private boolean supports(TemporalField field) {
            if (field.isDateBased()) {
                return this.supportsDate();
            }
            if (field.isTimeBased()) {
                return this.supportsTime();
            }
            throw new IllegalStateException("Fields should be either date based or time based");
        }

        protected abstract boolean supportsDate();

        protected abstract boolean supportsTime();

        protected abstract boolean supportsTimeZone();

        protected abstract boolean supportsEpoch();

        protected ZoneId timezone(AnyValue timezone) {
            return timezone == null ? this.defaultZone.get() : TemporalValue.timezoneOf(timezone);
        }

        protected abstract Result buildInternal();

        protected final ZoneId optionalTimezone() {
            return this.timezone == null ? null : this.timezone();
        }

        protected final ZoneId timezone() {
            return this.timezone(this.timezone);
        }
    }
}

