/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InvalidValuesArgumentException;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;

public class PointValue
extends ScalarValue
implements Point,
Comparable<PointValue> {
    private CoordinateReferenceSystem crs;
    private double[] coordinate;

    PointValue(CoordinateReferenceSystem crs, double ... coordinate) {
        this.crs = crs;
        this.coordinate = coordinate;
        for (double c : coordinate) {
            if (Double.isFinite(c)) continue;
            throw new InvalidValuesArgumentException("Cannot create a point with non-finite coordinate values: " + Arrays.toString(coordinate));
        }
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writePoint(this.getCoordinateReferenceSystem(), this.coordinate);
    }

    @Override
    public String prettyPrint() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        ((Value)this).writeTo(prettyPrinter);
        return prettyPrinter.value();
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.GEOMETRY;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof PointValue) {
            PointValue pv = (PointValue)other;
            return Arrays.equals(this.coordinate, pv.coordinate) && this.getCoordinateReferenceSystem().equals(pv.getCoordinateReferenceSystem());
        }
        return false;
    }

    public boolean equals(Point other) {
        if (!other.getCRS().getHref().equals(this.getCRS().getHref())) {
            return false;
        }
        List otherCoordinate = other.getCoordinate().getCoordinate();
        if (otherCoordinate.size() != this.coordinate.length) {
            return false;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            if ((Double)otherCoordinate.get(i) == this.coordinate[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean eq(Object other) {
        return other != null && (other instanceof Value && this.equals((Value)other) || other instanceof Point && this.equals((Point)other));
    }

    @Override
    public int compareTo(PointValue other) {
        int cmpCRS = this.crs.getCode() - other.crs.getCode();
        if (cmpCRS != 0) {
            return cmpCRS;
        }
        if (this.coordinate.length > other.coordinate.length) {
            return 1;
        }
        if (this.coordinate.length < other.coordinate.length) {
            return -1;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            int cmpVal = Double.compare(this.coordinate[i], other.coordinate[i]);
            if (cmpVal == 0) continue;
            return cmpVal;
        }
        return 0;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareTo((PointValue)otherValue);
    }

    @Override
    Integer unsafeTernaryCompareTo(Value otherValue) {
        PointValue other = (PointValue)otherValue;
        if (this.crs.getCode() != other.crs.getCode() || this.coordinate.length != other.coordinate.length) {
            return null;
        }
        int result = 0;
        for (int i = 0; i < this.coordinate.length; ++i) {
            int cmpVal = Double.compare(this.coordinate[i], other.coordinate[i]);
            if (cmpVal == 0 || cmpVal == result) continue;
            if (cmpVal < 0 && result > 0 || cmpVal > 0 && result < 0) {
                return null;
            }
            result = cmpVal;
        }
        return result;
    }

    public Point asObjectCopy() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public double[] coordinate() {
        return this.coordinate;
    }

    @Override
    public int computeHash() {
        int result = 1;
        result = 31 * result + NumberValues.hash(this.crs.getCode());
        result = 31 * result + NumberValues.hash(this.coordinate);
        return result;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPoint(this);
    }

    public String toString() {
        return String.format("Point{%s, %s}", this.getCoordinateReferenceSystem().getName(), Arrays.toString(this.coordinate));
    }

    public String toIndexableString() {
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        return String.format("P:%d-%d%s", crs.getTable().getTableId(), crs.getCode(), Arrays.toString(this.coordinate));
    }

    public List<Coordinate> getCoordinates() {
        return Collections.singletonList(new Coordinate(this.coordinate));
    }

    public CRS getCRS() {
        return this.crs;
    }

    public boolean withinRange(PointValue lower, boolean includeLower, PointValue upper, boolean includeUpper) {
        Integer compareUpper;
        Integer compareLower;
        if (lower != null && ((compareLower = this.unsafeTernaryCompareTo(lower)) == null || compareLower < 0 || compareLower == 0 && !includeLower)) {
            return false;
        }
        return upper == null || (compareUpper = this.unsafeTernaryCompareTo(upper)) != null && compareUpper <= 0 && (compareUpper != 0 || includeUpper);
    }

    public static PointValue fromMap(MapValue map) {
        PointCSVHeaderInformation fields = new PointCSVHeaderInformation();
        for (Map.Entry<String, AnyValue> entry : map.entrySet()) {
            fields.assign(entry.getKey().toLowerCase(), entry.getValue());
        }
        return PointValue.fromInputFields(fields);
    }

    public static PointValue parse(CharSequence text) {
        return PointValue.parse(text, null);
    }

    public static PointValue parse(CharSequence text, CSVHeaderInformation fieldsFromHeader) {
        PointCSVHeaderInformation fieldsFromData = PointValue.parseHeaderInformation(text);
        if (fieldsFromHeader != null) {
            if (!(fieldsFromHeader instanceof PointCSVHeaderInformation)) {
                throw new IllegalStateException("Wrong header information type: " + fieldsFromHeader);
            }
            fieldsFromData.mergeWithHeader((PointCSVHeaderInformation)fieldsFromHeader);
        }
        return PointValue.fromInputFields(fieldsFromData);
    }

    public static PointCSVHeaderInformation parseHeaderInformation(CharSequence text) {
        PointCSVHeaderInformation fields = new PointCSVHeaderInformation();
        Value.parseHeaderInformation(text, "point", fields);
        return fields;
    }

    private static CoordinateReferenceSystem findSpecifiedCRS(PointCSVHeaderInformation fields) {
        String crsValue = fields.crs;
        int sridValue = fields.srid;
        if (crsValue != null && sridValue != -1) {
            throw new InvalidValuesArgumentException("Cannot specify both CRS and SRID");
        }
        if (crsValue != null) {
            return CoordinateReferenceSystem.byName(crsValue);
        }
        if (sridValue != -1) {
            return CoordinateReferenceSystem.get(sridValue);
        }
        return null;
    }

    private static PointValue fromInputFields(PointCSVHeaderInformation fields) {
        double[] coordinates;
        CoordinateReferenceSystem crs = PointValue.findSpecifiedCRS(fields);
        if (fields.x != null && fields.y != null) {
            double[] dArray;
            if (fields.z != null) {
                double[] dArray2 = new double[3];
                dArray2[0] = fields.x;
                dArray2[1] = fields.y;
                dArray = dArray2;
                dArray2[2] = fields.z;
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = fields.x;
                dArray = dArray3;
                dArray3[1] = fields.y;
            }
            coordinates = dArray;
            if (crs == null) {
                crs = coordinates.length == 3 ? CoordinateReferenceSystem.Cartesian_3D : CoordinateReferenceSystem.Cartesian;
            }
        } else if (fields.latitude != null && fields.longitude != null) {
            coordinates = fields.z != null ? new double[]{fields.longitude, fields.latitude, fields.z} : (fields.height != null ? new double[]{fields.longitude, fields.latitude, fields.height} : new double[]{fields.longitude, fields.latitude});
            if (crs == null) {
                CoordinateReferenceSystem coordinateReferenceSystem = crs = coordinates.length == 3 ? CoordinateReferenceSystem.WGS84_3D : CoordinateReferenceSystem.WGS84;
            }
            if (!crs.isGeographic()) {
                throw new InvalidValuesArgumentException("Geographic points does not support coordinate reference system: " + crs + ". This is set either in the csv header or the actual data column");
            }
        } else {
            if (crs == CoordinateReferenceSystem.Cartesian) {
                throw new InvalidValuesArgumentException("A " + CoordinateReferenceSystem.Cartesian.getName() + " point must contain 'x' and 'y'");
            }
            if (crs == CoordinateReferenceSystem.Cartesian_3D) {
                throw new InvalidValuesArgumentException("A " + CoordinateReferenceSystem.Cartesian_3D.getName() + " point must contain 'x', 'y' and 'z'");
            }
            if (crs == CoordinateReferenceSystem.WGS84) {
                throw new InvalidValuesArgumentException("A " + CoordinateReferenceSystem.WGS84.getName() + " point must contain 'latitude' and 'longitude'");
            }
            if (crs == CoordinateReferenceSystem.WGS84_3D) {
                throw new InvalidValuesArgumentException("A " + CoordinateReferenceSystem.WGS84_3D.getName() + " point must contain 'latitude', 'longitude' and 'height'");
            }
            throw new InvalidValuesArgumentException("A point must contain either 'x' and 'y' or 'latitude' and 'longitude'");
        }
        if (crs.getDimension() != coordinates.length) {
            throw new InvalidValuesArgumentException("Cannot create point with " + crs.getDimension() + "D coordinate reference system and " + coordinates.length + " coordinates. Please consider using equivalent " + coordinates.length + "D coordinate reference system");
        }
        return Values.pointValue(crs, coordinates);
    }

    public AnyValue get(String fieldName) {
        switch (fieldName.toLowerCase()) {
            case "x": {
                return this.getNthCoordinate(0, fieldName, false);
            }
            case "y": {
                return this.getNthCoordinate(1, fieldName, false);
            }
            case "z": {
                return this.getNthCoordinate(2, fieldName, false);
            }
            case "longitude": {
                return this.getNthCoordinate(0, fieldName, true);
            }
            case "latitude": {
                return this.getNthCoordinate(1, fieldName, true);
            }
            case "height": {
                return this.getNthCoordinate(2, fieldName, true);
            }
            case "crs": {
                return Values.stringValue(this.crs.toString());
            }
            case "srid": {
                return Values.intValue(this.crs.getCode());
            }
        }
        throw new InvalidValuesArgumentException("No such field: " + fieldName);
    }

    private DoubleValue getNthCoordinate(int n, String fieldName, boolean onlyGeographic) {
        if (onlyGeographic && !this.getCoordinateReferenceSystem().isGeographic()) {
            throw new InvalidValuesArgumentException("Field: " + fieldName + " is not available on cartesian point: " + this);
        }
        if (n >= this.coordinate().length) {
            throw new InvalidValuesArgumentException("Field: " + fieldName + " is not available on point: " + this);
        }
        return Values.doubleValue(this.coordinate[n]);
    }

    private static <T extends Number> T assertConvertible(Supplier<T> func) {
        try {
            return (T)((Number)func.get());
        }
        catch (NumberFormatException e) {
            throw new InvalidValuesArgumentException(e.getMessage(), e);
        }
    }

    private static class PointCSVHeaderInformation
    implements CSVHeaderInformation {
        private String crs;
        private Double x;
        private Double y;
        private Double z;
        private Double longitude;
        private Double latitude;
        private Double height;
        private int srid = -1;

        private PointCSVHeaderInformation() {
        }

        private void checkUnassigned(Object key, String fieldName) {
            if (key != null) {
                throw new InvalidValuesArgumentException(String.format("Duplicate field '%s' is not allowed.", fieldName));
            }
        }

        public void assign(String key, AnyValue value) {
            if (value instanceof IntegralValue) {
                this.assignIntegral(key, ((IntegralValue)value).longValue());
            } else if (value instanceof FloatingPointValue) {
                this.assignFloatingPoint(key, ((FloatingPointValue)value).doubleValue());
            } else if (value instanceof TextValue) {
                this.assignTextValue(key, ((TextValue)value).stringValue());
            } else {
                throw new InvalidValuesArgumentException(String.format("Cannot assign %s to field %s", value, key));
            }
        }

        private void assignTextValue(String key, String value) {
            String lowercaseKey;
            switch (lowercaseKey = key.toLowerCase()) {
                case "crs": {
                    this.checkUnassigned(this.crs, lowercaseKey);
                    this.crs = Value.quotesPattern.matcher(value).replaceAll("");
                    break;
                }
                default: {
                    this.throwOnUnrecognizedKey(key);
                }
            }
        }

        private void assignFloatingPoint(String key, double value) {
            String lowercaseKey;
            switch (lowercaseKey = key.toLowerCase()) {
                case "x": {
                    this.checkUnassigned(this.x, lowercaseKey);
                    this.x = value;
                    break;
                }
                case "y": {
                    this.checkUnassigned(this.y, lowercaseKey);
                    this.y = value;
                    break;
                }
                case "z": {
                    this.checkUnassigned(this.z, lowercaseKey);
                    this.z = value;
                    break;
                }
                case "longitude": {
                    this.checkUnassigned(this.longitude, lowercaseKey);
                    this.longitude = value;
                    break;
                }
                case "latitude": {
                    this.checkUnassigned(this.latitude, lowercaseKey);
                    this.latitude = value;
                    break;
                }
                case "height": {
                    this.checkUnassigned(this.height, lowercaseKey);
                    this.height = value;
                    break;
                }
                default: {
                    this.throwOnUnrecognizedKey(key);
                }
            }
        }

        private void assignIntegral(String key, long value) {
            switch (key.toLowerCase()) {
                case "x": 
                case "y": 
                case "z": 
                case "longitude": 
                case "latitude": 
                case "height": {
                    this.assignFloatingPoint(key, value);
                    break;
                }
                case "srid": {
                    if (this.srid != -1) {
                        throw new InvalidValuesArgumentException("Duplicate field 'srid' is not allowed.");
                    }
                    this.srid = (int)value;
                    break;
                }
                default: {
                    this.throwOnUnrecognizedKey(key);
                }
            }
        }

        @Override
        public void assign(String key, String value) {
            switch (key.toLowerCase()) {
                case "crs": {
                    this.assignTextValue(key, value);
                    break;
                }
                case "x": 
                case "y": 
                case "z": 
                case "longitude": 
                case "latitude": 
                case "height": {
                    this.assignFloatingPoint(key, (Double)PointValue.assertConvertible(() -> Double.parseDouble(value)));
                    break;
                }
                case "srid": {
                    this.assignIntegral(key, ((Integer)PointValue.assertConvertible(() -> Integer.parseInt(value))).intValue());
                    break;
                }
                default: {
                    this.throwOnUnrecognizedKey(key);
                }
            }
        }

        private void throwOnUnrecognizedKey(String key) {
            throw new InvalidValuesArgumentException(String.format("Unknown key '%s' for creating new point", key));
        }

        void mergeWithHeader(PointCSVHeaderInformation header) {
            this.crs = this.crs == null ? header.crs : this.crs;
            this.x = this.x == null ? header.x : this.x;
            this.y = this.y == null ? header.y : this.y;
            this.z = this.z == null ? header.z : this.z;
            this.longitude = this.longitude == null ? header.longitude : this.longitude;
            this.latitude = this.latitude == null ? header.latitude : this.latitude;
            this.height = this.height == null ? header.height : this.height;
            this.srid = this.srid == -1 ? header.srid : this.srid;
        }
    }
}

