/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class StringArray
extends TextArray {
    private final String[] value;

    StringArray(String[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public String stringValue(int offset) {
        return this.value[offset];
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(char[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(String[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public int computeHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public String[] asObjectCopy() {
        return (String[])this.value.clone();
    }

    @Deprecated
    public String[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int offset) {
        return Values.stringValue(this.stringValue(offset));
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapStringArray(this);
    }

    public String toString() {
        return String.format("StringArray%s", Arrays.toString(this.value));
    }
}

