/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public final class DateTimeValue
extends TemporalValue<ZonedDateTime, DateTimeValue> {
    public static final DateTimeValue MIN_VALUE = new DateTimeValue(ZonedDateTime.of(LocalDateTime.MIN, ZoneOffset.MIN));
    public static final DateTimeValue MAX_VALUE = new DateTimeValue(ZonedDateTime.of(LocalDateTime.MAX, ZoneOffset.MAX));
    private final ZonedDateTime value;
    private final long epochSeconds;
    private static final String ZONE_NAME = "(?<zoneName>[a-zA-Z0-9~._ /+-]+)";
    private static final Pattern PATTERN = Pattern.compile(DateValue.DATE_PATTERN + "(?<time>T" + "(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:\\.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:\\.(?<shortFraction>[0-9]{1,9}))?)?)?))(?:(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?))?" + "(?:\\[" + "(?<zoneName>[a-zA-Z0-9~._ /+-]+)" + "\\])?)?", 2);
    private static final DateTimeFormatter ZONE_NAME_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendZoneRegionId().toFormatter();

    public static DateTimeValue datetime(DateValue date, LocalTimeValue time, ZoneId zone) {
        return new DateTimeValue(ZonedDateTime.of(date.temporal(), time.temporal(), zone));
    }

    public static DateTimeValue datetime(DateValue date, TimeValue time) {
        OffsetTime t = time.temporal();
        return new DateTimeValue(ZonedDateTime.of(date.temporal(), t.toLocalTime(), t.getOffset()));
    }

    public static DateTimeValue datetime(int year, int month, int day, int hour, int minute, int second, int nanoOfSecond, String zone) {
        return DateTimeValue.datetime(year, month, day, hour, minute, second, nanoOfSecond, DateTimeValue.parseZoneName(zone));
    }

    public static DateTimeValue datetime(int year, int month, int day, int hour, int minute, int second, int nanoOfSecond, ZoneId zone) {
        return new DateTimeValue(ZonedDateTime.of(year, month, day, hour, minute, second, nanoOfSecond, zone));
    }

    public static DateTimeValue datetime(long epochSecond, long nano, ZoneOffset zoneOffset) {
        return new DateTimeValue(ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nano), zoneOffset));
    }

    public static DateTimeValue datetime(ZonedDateTime datetime) {
        return new DateTimeValue(Objects.requireNonNull(datetime, "ZonedDateTime"));
    }

    public static DateTimeValue datetime(OffsetDateTime datetime) {
        return new DateTimeValue(Objects.requireNonNull(datetime, "OffsetDateTime").toZonedDateTime());
    }

    public static DateTimeValue datetime(long epochSecondUTC, long nano, ZoneId zone) {
        return new DateTimeValue(ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecondUTC, nano), zone));
    }

    public static DateTimeValue ofEpoch(IntegralValue epochSecondUTC, IntegralValue nano) {
        long ns = IntegralValue.safeCastIntegral("nanosecond", nano, 0L);
        if (ns < 0L || ns >= 1000000000L) {
            throw new IllegalArgumentException("Invalid nanosecond: " + ns);
        }
        return new DateTimeValue(ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecondUTC.longValue(), ns), ZoneOffset.UTC));
    }

    public static DateTimeValue ofEpochMillis(IntegralValue millisUTC) {
        return new DateTimeValue(ZonedDateTime.ofInstant(Instant.ofEpochMilli(millisUTC.longValue()), ZoneOffset.UTC));
    }

    public static DateTimeValue parse(CharSequence text, Supplier<ZoneId> defaultZone, CSVHeaderInformation fieldsFromHeader) {
        if (fieldsFromHeader != null) {
            if (!(fieldsFromHeader instanceof TemporalValue.TimeCSVHeaderInformation)) {
                throw new IllegalStateException("Wrong header information type: " + fieldsFromHeader);
            }
            defaultZone = ((TemporalValue.TimeCSVHeaderInformation)fieldsFromHeader).zoneSupplier(defaultZone);
        }
        return DateTimeValue.parse(DateTimeValue.class, PATTERN, DateTimeValue::parse, text, defaultZone);
    }

    public static DateTimeValue parse(CharSequence text, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse(DateTimeValue.class, PATTERN, DateTimeValue::parse, text, defaultZone);
    }

    public static DateTimeValue parse(TextValue text, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse(DateTimeValue.class, PATTERN, DateTimeValue::parse, text, defaultZone);
    }

    public static DateTimeValue now(Clock clock) {
        return new DateTimeValue(ZonedDateTime.now(clock));
    }

    public static DateTimeValue now(Clock clock, String timezone) {
        return DateTimeValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static DateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return (DateTimeValue)StructureBuilder.build(DateTimeValue.builder(defaultZone), map);
    }

    public static DateTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.builder(defaultZone).selectDateTime(from);
    }

    public static DateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        Pair<LocalDate, LocalTime> pair = DateTimeValue.getTruncatedDateAndTime(unit, input, "date time");
        LocalDate truncatedDate = (LocalDate)pair.first();
        LocalTime truncatedTime = (LocalTime)pair.other();
        ZoneId zoneId = input.supportsTimeZone() ? input.getZoneId(defaultZone) : defaultZone.get();
        ZonedDateTime truncatedZDT = ZonedDateTime.of(truncatedDate, truncatedTime, zoneId);
        if (fields.size() == 0) {
            return DateTimeValue.datetime(truncatedZDT);
        }
        HashMap<String, AnyValue> updatedFields = new HashMap<String, AnyValue>(fields.size() + 1);
        for (Map.Entry<String, AnyValue> entry : fields.entrySet()) {
            if ("timezone".equals(entry.getKey())) {
                truncatedZDT = truncatedZDT.withZoneSameLocal(DateTimeValue.timezoneOf(entry.getValue()));
                continue;
            }
            updatedFields.put(entry.getKey(), entry.getValue());
        }
        truncatedZDT = DateTimeValue.updateFieldMapWithConflictingSubseconds(updatedFields, unit, truncatedZDT);
        if (updatedFields.size() == 0) {
            return DateTimeValue.datetime(truncatedZDT);
        }
        updatedFields.put("datetime", DateTimeValue.datetime(truncatedZDT));
        return DateTimeValue.build(VirtualValues.map(updatedFields), defaultZone);
    }

    static DateTimeBuilder<DateTimeValue> builder(final Supplier<ZoneId> defaultZone) {
        return new DateTimeBuilder<DateTimeValue>(defaultZone){
            private final ZonedDateTime defaulZonedDateTime;
            {
                super(defaultZone2);
                this.defaulZonedDateTime = ZonedDateTime.of(TemporalValue.Field.year.defaultValue, TemporalValue.Field.month.defaultValue, TemporalValue.Field.day.defaultValue, TemporalValue.Field.hour.defaultValue, TemporalValue.Field.minute.defaultValue, TemporalValue.Field.second.defaultValue, TemporalValue.Field.nanosecond.defaultValue, this.timezone());
            }

            @Override
            protected boolean supportsTimeZone() {
                return true;
            }

            @Override
            protected boolean supportsEpoch() {
                return true;
            }

            @Override
            public DateTimeValue buildInternal() {
                boolean selectingTimeZone;
                ZonedDateTime result;
                boolean selectingEpoch;
                boolean selectingDate = this.fields.containsKey((Object)TemporalValue.Field.date);
                boolean selectingTime = this.fields.containsKey((Object)TemporalValue.Field.time);
                boolean selectingDateTime = this.fields.containsKey((Object)TemporalValue.Field.datetime);
                boolean bl = selectingEpoch = this.fields.containsKey((Object)TemporalValue.Field.epochSeconds) || this.fields.containsKey((Object)TemporalValue.Field.epochMillis);
                if (selectingDateTime) {
                    AnyValue dtField = (AnyValue)this.fields.get((Object)TemporalValue.Field.datetime);
                    if (!(dtField instanceof TemporalValue)) {
                        throw new IllegalArgumentException(String.format("Cannot construct date time from: %s", dtField));
                    }
                    TemporalValue dt = (TemporalValue)dtField;
                    LocalTime timePart = dt.getTimePart(defaultZone).toLocalTime();
                    ZoneId zoneId = dt.getZoneId(defaultZone);
                    result = ZonedDateTime.of(dt.getDatePart(), timePart, zoneId);
                    selectingTimeZone = dt.supportsTimeZone();
                } else if (selectingEpoch) {
                    if (this.fields.containsKey((Object)TemporalValue.Field.epochSeconds)) {
                        AnyValue epochField = (AnyValue)this.fields.get((Object)TemporalValue.Field.epochSeconds);
                        if (!(epochField instanceof IntegralValue)) {
                            throw new IllegalArgumentException(String.format("Cannot construct date time from: %s", epochField));
                        }
                        IntegralValue epochSeconds = (IntegralValue)epochField;
                        result = ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochSeconds.longValue() * 1000L), this.timezone());
                    } else {
                        AnyValue epochField = (AnyValue)this.fields.get((Object)TemporalValue.Field.epochMillis);
                        if (!(epochField instanceof IntegralValue)) {
                            throw new IllegalArgumentException(String.format("Cannot construct date time from: %s", epochField));
                        }
                        IntegralValue epochMillis = (IntegralValue)epochField;
                        result = ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMillis.longValue()), this.timezone());
                    }
                    selectingTimeZone = false;
                } else if (selectingTime || selectingDate) {
                    LocalDate date;
                    ZoneId zoneId;
                    LocalTime time;
                    if (selectingTime) {
                        AnyValue timeField = (AnyValue)this.fields.get((Object)TemporalValue.Field.time);
                        if (!(timeField instanceof TemporalValue)) {
                            throw new IllegalArgumentException(String.format("Cannot construct time from: %s", timeField));
                        }
                        TemporalValue t = (TemporalValue)timeField;
                        time = t.getTimePart(defaultZone).toLocalTime();
                        zoneId = t.getZoneId(defaultZone);
                        selectingTimeZone = t.supportsTimeZone();
                    } else {
                        time = LocalTimeValue.DEFAULT_LOCAL_TIME;
                        zoneId = this.timezone();
                        selectingTimeZone = false;
                    }
                    if (selectingDate) {
                        AnyValue dateField = (AnyValue)this.fields.get((Object)TemporalValue.Field.date);
                        if (!(dateField instanceof TemporalValue)) {
                            throw new IllegalArgumentException(String.format("Cannot construct date from: %s", dateField));
                        }
                        TemporalValue t = (TemporalValue)dateField;
                        date = t.getDatePart();
                    } else {
                        date = DateValue.DEFAULT_CALENDER_DATE;
                    }
                    result = ZonedDateTime.of(date, time, zoneId);
                } else {
                    result = this.defaulZonedDateTime;
                    selectingTimeZone = false;
                }
                if (this.fields.containsKey((Object)TemporalValue.Field.week) && !selectingDate && !selectingDateTime && !selectingEpoch) {
                    result = result.with(IsoFields.WEEK_BASED_YEAR, IntegralValue.safeCastIntegral(TemporalValue.Field.year.name(), (AnyValue)this.fields.get((Object)TemporalValue.Field.year), TemporalValue.Field.year.defaultValue)).with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1L).with(ChronoField.DAY_OF_WEEK, 1L);
                }
                result = this.assignAllFields(result);
                if (this.timezone != null) {
                    result = (selectingTime || selectingDateTime) && selectingTimeZone || selectingEpoch ? result.withZoneSameInstant(this.timezone()) : result.withZoneSameLocal(this.timezone());
                }
                return DateTimeValue.datetime(result);
            }

            @Override
            protected DateTimeValue selectDateTime(AnyValue datetime) {
                if (datetime instanceof DateTimeValue) {
                    DateTimeValue value = (DateTimeValue)datetime;
                    ZoneId zone = this.optionalTimezone();
                    return zone == null ? value : new DateTimeValue(ZonedDateTime.of(value.temporal().toLocalDateTime(), zone));
                }
                if (datetime instanceof LocalDateTimeValue) {
                    return new DateTimeValue(ZonedDateTime.of(((LocalDateTimeValue)datetime).temporal(), this.timezone()));
                }
                throw new IllegalArgumentException("Cannot select datetime from: " + datetime);
            }
        };
    }

    private DateTimeValue(ZonedDateTime value) {
        if (value.getZone() instanceof ZoneOffset) {
            int offsetMinutes = value.getOffset().getTotalSeconds() / 60;
            ZoneOffset truncatedOffset = ZoneOffset.ofTotalSeconds(offsetMinutes * 60);
            this.value = value.withZoneSameInstant(truncatedOffset);
        } else {
            this.value = value;
        }
        this.epochSeconds = this.value.toEpochSecond();
    }

    @Override
    ZonedDateTime temporal() {
        return this.value;
    }

    @Override
    LocalDate getDatePart() {
        return this.value.toLocalDate();
    }

    @Override
    LocalTime getLocalTimePart() {
        return this.value.toLocalTime();
    }

    @Override
    OffsetTime getTimePart(Supplier<ZoneId> defaultZone) {
        ZoneOffset offset = this.value.getOffset();
        LocalTime localTime = this.value.toLocalTime();
        return OffsetTime.of(localTime, offset);
    }

    @Override
    ZoneId getZoneId(Supplier<ZoneId> defaultZone) {
        return this.value.getZone();
    }

    @Override
    ZoneId getZoneId() {
        return this.value.getZone();
    }

    @Override
    ZoneOffset getZoneOffset() {
        return this.value.getOffset();
    }

    @Override
    public boolean supportsTimeZone() {
        return true;
    }

    @Override
    boolean hasTime() {
        return true;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof DateTimeValue) {
            ZonedDateTime that = ((DateTimeValue)other).value;
            return this.value.toLocalDateTime().equals(that.toLocalDateTime()) && this.areSameZone(this.value.getZone(), that.getZone());
        }
        return false;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeDateTime(this.value);
    }

    @Override
    int unsafeCompareTo(Value other) {
        DateTimeValue that = (DateTimeValue)other;
        int cmp = Long.compare(this.epochSeconds, that.epochSeconds);
        if (cmp == 0 && (cmp = this.value.toLocalTime().getNano() - that.value.toLocalTime().getNano()) == 0 && (cmp = this.value.toLocalDateTime().compareTo(that.value.toLocalDateTime())) == 0) {
            boolean thisIsOffset;
            ZoneId thisZone = this.value.getZone();
            ZoneId thatZone = that.value.getZone();
            boolean thatIsOffset = thatZone instanceof ZoneOffset;
            cmp = Boolean.compare(thatIsOffset, thisIsOffset = thisZone instanceof ZoneOffset);
            if (cmp == 0 && (thisIsOffset || !this.areSameZone(thisZone, thatZone, thisIsOffset, thatIsOffset))) {
                cmp = thisZone.getId().compareTo(thatZone.getId());
            }
            if (cmp == 0) {
                cmp = this.value.getChronology().compareTo(that.value.getChronology());
            }
        }
        return cmp;
    }

    private boolean areSameZone(ZoneId thisZone, ZoneId thatZone, boolean thisIsOffset, boolean thatIsOffset) {
        if (thisIsOffset && thatIsOffset) {
            return thisZone.equals(thatZone);
        }
        if (!thisIsOffset && !thatIsOffset) {
            return TimeZones.map(thisZone.getId()) == TimeZones.map(thatZone.getId());
        }
        return false;
    }

    private boolean areSameZone(ZoneId thisZone, ZoneId thatZone) {
        boolean thisIsOffset = thisZone instanceof ZoneOffset;
        boolean thatIsOffset = thatZone instanceof ZoneOffset;
        return this.areSameZone(thisZone, thatZone, thisIsOffset, thatIsOffset);
    }

    @Override
    public String prettyPrint() {
        return this.value.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.ZONED_DATE_TIME;
    }

    @Override
    protected int computeHash() {
        return this.value.toInstant().hashCode();
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDateTime(this);
    }

    @Override
    public DateTimeValue add(DurationValue duration) {
        return this.replacement(this.value.plus(duration));
    }

    @Override
    public DateTimeValue sub(DurationValue duration) {
        return this.replacement(this.value.minus(duration));
    }

    @Override
    DateTimeValue replacement(ZonedDateTime datetime) {
        return this.value == datetime ? this : new DateTimeValue(datetime);
    }

    private static DateTimeValue parse(Matcher matcher, Supplier<ZoneId> defaultZone) {
        ZoneId zone;
        LocalDateTime local = LocalDateTime.of(DateValue.parseDate(matcher), LocalDateTimeValue.optTime(matcher));
        String zoneName = matcher.group("zoneName");
        ZoneOffset offset = TimeValue.parseOffset(matcher);
        if (zoneName != null) {
            ZoneOffset expected;
            zone = DateTimeValue.parseZoneName(zoneName);
            if (offset != null && !(expected = zone.getRules().getOffset(local)).equals(offset)) {
                throw new IllegalArgumentException("Timezone and offset do not match: " + matcher.group());
            }
        } else {
            zone = offset != null ? offset : defaultZone.get();
        }
        return new DateTimeValue(ZonedDateTime.of(local, zone));
    }

    static ZoneId parseZoneName(String zoneName) {
        return ZONE_NAME_PARSER.parse(zoneName.replace(' ', '_')).query(TemporalQueries.zoneId());
    }

    static abstract class DateTimeBuilder<Result>
    extends TemporalValue.Builder<Result> {
        DateTimeBuilder(Supplier<ZoneId> defaultZone) {
            super(defaultZone);
        }

        @Override
        protected final boolean supportsDate() {
            return true;
        }

        @Override
        protected final boolean supportsTime() {
            return true;
        }

        protected abstract Result selectDateTime(AnyValue var1);
    }
}

