/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Comparator;
import java.util.function.BiFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValueGroup;

class AnyValueComparator
implements Comparator<AnyValue>,
TernaryComparator<AnyValue> {
    private final Comparator<Value> valueComparator;
    private final TernaryComparator<Value> ternaryValueComparator;
    private final Comparator<VirtualValueGroup> virtualValueGroupComparator;

    AnyValueComparator(Comparator<Value> valueComparator, TernaryComparator<Value> ternaryValueComparator, Comparator<VirtualValueGroup> virtualValueGroupComparator) {
        this.valueComparator = valueComparator;
        this.ternaryValueComparator = ternaryValueComparator;
        this.virtualValueGroupComparator = virtualValueGroupComparator;
    }

    private Integer cmp(AnyValue v1, AnyValue v2, BiFunction<Value, Value, Integer> compareValues) {
        assert (v1 != null && v2 != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        if (v1 == v2) {
            return 0;
        }
        if (v1 == Values.NO_VALUE) {
            return 1;
        }
        if (v2 == Values.NO_VALUE) {
            return -1;
        }
        boolean isSequence1 = v1.isSequenceValue();
        boolean isSequence2 = v2.isSequenceValue();
        if (isSequence1 && isSequence2) {
            return this.compareSequences((SequenceValue)((Object)v1), (SequenceValue)((Object)v2));
        }
        if (isSequence1) {
            return this.compareSequenceAndNonSequence((SequenceValue)((Object)v1), v2);
        }
        if (isSequence2) {
            return -this.compareSequenceAndNonSequence((SequenceValue)((Object)v2), v1);
        }
        boolean isValue1 = v1 instanceof Value;
        boolean isValue2 = v2 instanceof Value;
        int x = Boolean.compare(isValue1, isValue2);
        if (x == 0) {
            return isValue1 ? compareValues.apply((Value)v1, (Value)v2) : Integer.valueOf(this.compareVirtualValues((VirtualValue)v1, (VirtualValue)v2));
        }
        return x;
    }

    @Override
    public int compare(AnyValue v1, AnyValue v2) {
        return this.cmp(v1, v2, this.valueComparator::compare);
    }

    @Override
    public Integer ternaryCompare(AnyValue v1, AnyValue v2) {
        return this.cmp(v1, v2, this.ternaryValueComparator::ternaryCompare);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AnyValueComparator;
    }

    public int hashCode() {
        return 1;
    }

    private int compareVirtualValues(VirtualValue v1, VirtualValue v2) {
        VirtualValueGroup id2;
        VirtualValueGroup id1 = v1.valueGroup();
        int x = this.virtualValueGroupComparator.compare(id1, id2 = v2.valueGroup());
        if (x == 0) {
            return v1.compareTo(v2, this);
        }
        return x;
    }

    private int compareSequenceAndNonSequence(SequenceValue v1, AnyValue v2) {
        boolean isValue2 = v2 instanceof Value;
        if (isValue2) {
            return -1;
        }
        return this.virtualValueGroupComparator.compare(VirtualValueGroup.LIST, ((VirtualValue)v2).valueGroup());
    }

    private int compareSequences(SequenceValue v1, SequenceValue v2) {
        return v1.compareToSequence(v2, this);
    }
}

