/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.utils.PrettyPrinter;

public class PointValue
extends ScalarValue
implements Point,
Comparable<PointValue> {
    private CoordinateReferenceSystem crs;
    private double[] coordinate;

    PointValue(CoordinateReferenceSystem crs, double ... coordinate) {
        this.crs = crs;
        this.coordinate = coordinate;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writePoint(this.getCoordinateReferenceSystem(), this.coordinate);
    }

    @Override
    public String prettyPrint() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        ((Value)this).writeTo(prettyPrinter);
        return prettyPrinter.value();
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.GEOMETRY;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof PointValue) {
            PointValue pv = (PointValue)other;
            return Arrays.equals(this.coordinate, pv.coordinate) && this.getCoordinateReferenceSystem().equals(pv.getCoordinateReferenceSystem());
        }
        return false;
    }

    public boolean equals(Point other) {
        if (!other.getCRS().getHref().equals(this.getCRS().getHref())) {
            return false;
        }
        List otherCoordinate = other.getCoordinate().getCoordinate();
        if (otherCoordinate.size() != this.coordinate.length) {
            return false;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            if ((Double)otherCoordinate.get(i) == this.coordinate[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean eq(Object other) {
        return other != null && (other instanceof Value && this.equals((Value)other) || other instanceof Point && this.equals((Point)other));
    }

    @Override
    public int compareTo(PointValue other) {
        int cmpCRS = this.crs.getCode() - other.crs.getCode();
        if (cmpCRS != 0) {
            return cmpCRS;
        }
        if (this.coordinate.length > other.coordinate.length) {
            return 1;
        }
        if (this.coordinate.length < other.coordinate.length) {
            return -1;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            int cmpVal = Double.compare(this.coordinate[i], other.coordinate[i]);
            if (cmpVal == 0) continue;
            return cmpVal;
        }
        return 0;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareTo((PointValue)otherValue);
    }

    @Override
    Integer unsafeTernaryCompareTo(Value otherValue) {
        PointValue other = (PointValue)otherValue;
        if (this.crs.getCode() != other.crs.getCode() || this.coordinate.length != other.coordinate.length) {
            return null;
        }
        int result = 0;
        for (int i = 0; i < this.coordinate.length; ++i) {
            int cmpVal = Double.compare(this.coordinate[i], other.coordinate[i]);
            if (cmpVal == 0 || cmpVal == result) continue;
            if (cmpVal < 0 && result > 0 || cmpVal > 0 && result < 0) {
                return null;
            }
            result = cmpVal;
        }
        return result;
    }

    public Point asObjectCopy() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public double[] coordinate() {
        return this.coordinate;
    }

    @Override
    public int computeHash() {
        int result = 1;
        result = 31 * result + NumberValues.hash(this.crs.getCode());
        result = 31 * result + NumberValues.hash(this.coordinate);
        return result;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPoint(this);
    }

    public String toString() {
        return String.format("Point{ %s, %s}", this.getCoordinateReferenceSystem().getName(), Arrays.toString(this.coordinate));
    }

    public List<Coordinate> getCoordinates() {
        return Collections.singletonList(new Coordinate(this.coordinate));
    }

    public CRS getCRS() {
        return this.crs;
    }

    public boolean withinRange(PointValue lower, boolean includeLower, PointValue upper, boolean includeUpper) {
        boolean checkUpper;
        boolean checkLower = lower != null;
        boolean bl = checkUpper = upper != null;
        if (checkLower && this.crs.getCode() != lower.crs.getCode()) {
            return false;
        }
        if (checkUpper && this.crs.getCode() != upper.crs.getCode()) {
            return false;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            int compareUpper;
            int compareLower;
            if (checkLower && ((compareLower = Double.compare(this.coordinate[i], lower.coordinate[i])) < 0 || compareLower == 0 && !includeLower)) {
                return false;
            }
            if (!checkUpper || (compareUpper = Double.compare(this.coordinate[i], upper.coordinate[i])) <= 0 && (compareUpper != 0 || includeUpper)) continue;
            return false;
        }
        return true;
    }
}

