/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.helpers.collection.Pair;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public abstract class CRSCalculator {
    public abstract double distance(PointValue var1, PointValue var2);

    public abstract Pair<PointValue, PointValue> boundingBox(PointValue var1, double var2);

    protected static double pythagoras(double[] a, double[] b) {
        double sqrSum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double diff = a[i] - b[i];
            sqrSum += diff * diff;
        }
        return Math.sqrt(sqrSum);
    }

    public static class GeographicCalculator
    extends CRSCalculator {
        public static final double EARTH_RADIUS_METERS = 6378140.0;
        private static final double EXTENSION_FACTOR = 1.0001;
        int dimension;

        GeographicCalculator(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public double distance(PointValue p1, PointValue p2) {
            assert (p1.getCoordinateReferenceSystem().getDimension() == this.dimension);
            assert (p2.getCoordinateReferenceSystem().getDimension() == this.dimension);
            double[] c1Coord = p1.coordinate();
            double[] c2Coord = p2.coordinate();
            double[] c1 = new double[]{Math.toRadians(c1Coord[0]), Math.toRadians(c1Coord[1])};
            double[] c2 = new double[]{Math.toRadians(c2Coord[0]), Math.toRadians(c2Coord[1])};
            double dx = c2[0] - c1[0];
            double dy = c2[1] - c1[1];
            double alpha = Math.pow(Math.sin(dy / 2.0), 2.0) + Math.cos(c1[1]) * Math.cos(c2[1]) * Math.pow(Math.sin(dx / 2.0), 2.0);
            double greatCircleDistance = 2.0 * Math.atan2(Math.sqrt(alpha), Math.sqrt(1.0 - alpha));
            double distance2D = 6378140.0 * greatCircleDistance;
            if (this.dimension > 2) {
                double[] a = new double[this.dimension - 1];
                double[] b = new double[this.dimension - 1];
                a[0] = distance2D;
                b[0] = 0.0;
                for (int i = 1; i < this.dimension - 1; ++i) {
                    a[i] = 0.0;
                    b[i] = c1Coord[i + 1] - c2Coord[i + 1];
                }
                return GeographicCalculator.pythagoras(a, b);
            }
            return distance2D;
        }

        @Override
        public Pair<PointValue, PointValue> boundingBox(PointValue center, double distance) {
            if (distance == 0.0) {
                return Pair.of((Object)center, (Object)center);
            }
            double extended_distance = distance * 1.0001;
            CoordinateReferenceSystem crs = center.getCoordinateReferenceSystem();
            double lat = center.coordinate()[1];
            double lon = center.coordinate()[0];
            double r = extended_distance / 6378140.0;
            double lat_min = lat - Math.toDegrees(r);
            double lat_max = lat + Math.toDegrees(r);
            if (lat_max >= 90.0) {
                return this.boundingBoxOf(-180.0, 180.0, lat_min, 90.0, center, distance);
            }
            if (lat_min <= -90.0) {
                return this.boundingBoxOf(-180.0, 180.0, -90.0, lat_max, center, distance);
            }
            double delta_lon = Math.toDegrees(Math.asin(Math.sin(r) / Math.cos(Math.toRadians(lat))));
            double lon_min = lon - delta_lon;
            double lon_max = lon + delta_lon;
            if (lon_min < -180.0 || lon_max > 180.0) {
                return this.boundingBoxOf(-180.0, 180.0, lat_min, lat_max, center, distance);
            }
            return this.boundingBoxOf(lon_min, lon_max, lat_min, lat_max, center, distance);
        }

        private Pair<PointValue, PointValue> boundingBoxOf(double minLon, double maxLon, double minLat, double maxLat, PointValue center, double distance) {
            CoordinateReferenceSystem crs = center.getCoordinateReferenceSystem();
            int dimension = center.getCoordinateReferenceSystem().getDimension();
            double[] min = new double[dimension];
            double[] max = new double[dimension];
            min[0] = minLon;
            min[1] = minLat;
            max[0] = maxLon;
            max[1] = maxLat;
            if (dimension > 2) {
                double[] coordinates = center.coordinate();
                for (int i = 2; i < dimension; ++i) {
                    min[i] = coordinates[i] - distance;
                    max[i] = coordinates[i] + distance;
                }
            }
            return Pair.of((Object)Values.pointValue(crs, min), (Object)Values.pointValue(crs, max));
        }
    }

    public static class CartesianCalculator
    extends CRSCalculator {
        int dimension;

        CartesianCalculator(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public double distance(PointValue p1, PointValue p2) {
            assert (p1.getCoordinateReferenceSystem().getDimension() == this.dimension);
            assert (p2.getCoordinateReferenceSystem().getDimension() == this.dimension);
            return CartesianCalculator.pythagoras(p1.coordinate(), p2.coordinate());
        }

        @Override
        public Pair<PointValue, PointValue> boundingBox(PointValue center, double distance) {
            assert (center.getCoordinateReferenceSystem().getDimension() == this.dimension);
            double[] coordinates = center.coordinate();
            double[] min = new double[this.dimension];
            double[] max = new double[this.dimension];
            for (int i = 0; i < this.dimension; ++i) {
                min[i] = coordinates[i] - distance;
                max[i] = coordinates[i] + distance;
            }
            CoordinateReferenceSystem crs = center.getCoordinateReferenceSystem();
            return Pair.of((Object)Values.pointValue(crs, min), (Object)Values.pointValue(crs, max));
        }
    }
}

