/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualValueGroup;
import org.neo4j.values.virtual.VirtualValues;

public final class PathValue
extends VirtualValue {
    private final NodeValue[] nodes;
    private final RelationshipValue[] relationships;

    PathValue(NodeValue[] nodes, RelationshipValue[] relationships) {
        assert (nodes != null);
        assert (relationships != null);
        assert (nodes.length == relationships.length + 1);
        this.nodes = nodes;
        this.relationships = relationships;
    }

    public NodeValue startNode() {
        return this.nodes[0];
    }

    public NodeValue endNode() {
        return this.nodes[this.nodes.length - 1];
    }

    public RelationshipValue lastRelationship() {
        assert (this.relationships.length > 0);
        return this.relationships[this.relationships.length - 1];
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (other == null || other.getClass() != PathValue.class) {
            return false;
        }
        PathValue that = (PathValue)other;
        return this.size() == that.size() && Arrays.equals(this.nodes, that.nodes) && Arrays.equals(this.relationships, that.relationships);
    }

    @Override
    public int computeHash() {
        int result = this.nodes[0].hashCode();
        for (int i = 1; i < this.nodes.length; ++i) {
            result += 31 * (result + this.relationships[i - 1].hashCode());
            result += 31 * (result + this.nodes[i].hashCode());
        }
        return result;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.writePath(this.nodes, this.relationships);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPath(this);
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.PATH;
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (other == null || other.getClass() != PathValue.class) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        PathValue otherPath = (PathValue)other;
        int x = this.nodes[0].compareTo(otherPath.nodes[0], comparator);
        if (x == 0) {
            int length = Math.min(this.relationships.length, otherPath.relationships.length);
            for (int i = 0; x == 0 && i < length; ++i) {
                x = this.relationships[i].compareTo(otherPath.relationships[i], comparator);
            }
            if (x == 0) {
                x = Integer.compare(this.relationships.length, otherPath.relationships.length);
            }
        }
        return x;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("Path{");
        for (i = 0; i < this.relationships.length; ++i) {
            sb.append(this.nodes[i]);
            sb.append(this.relationships[i]);
        }
        sb.append(this.nodes[i]);
        sb.append('}');
        return sb.toString();
    }

    public ListValue asList() {
        int size = this.nodes.length + this.relationships.length;
        AnyValue[] anyValues = new AnyValue[size];
        for (int i = 0; i < size; ++i) {
            anyValues[i] = i % 2 == 0 ? this.nodes[i / 2] : this.relationships[i / 2];
        }
        return VirtualValues.list(anyValues);
    }

    public int size() {
        return this.relationships.length;
    }

    public NodeValue[] nodes() {
        return this.nodes;
    }

    public RelationshipValue[] relationships() {
        return this.relationships;
    }
}

