/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.nio.charset.StandardCharsets;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public interface ValueWriter<E extends Exception> {
    public void writeNull() throws E;

    public void writeBoolean(boolean var1) throws E;

    public void writeInteger(byte var1) throws E;

    public void writeInteger(short var1) throws E;

    public void writeInteger(int var1) throws E;

    public void writeInteger(long var1) throws E;

    public void writeFloatingPoint(float var1) throws E;

    public void writeFloatingPoint(double var1) throws E;

    public void writeString(String var1) throws E;

    public void writeString(char var1) throws E;

    default public void writeUTF8(byte[] bytes, int offset, int length) throws E {
        this.writeString(new String(bytes, offset, length, StandardCharsets.UTF_8));
    }

    public void beginArray(int var1, ArrayType var2) throws E;

    public void endArray() throws E;

    public void writeByteArray(byte[] var1) throws E;

    public void writePoint(CoordinateReferenceSystem var1, double[] var2) throws E;

    public void writeDuration(long var1, long var3, long var5, int var7) throws E;

    public void writeDate(long var1) throws E;

    public void writeLocalTime(long var1) throws E;

    public void writeTime(long var1, int var3) throws E;

    public void writeLocalDateTime(long var1, int var3) throws E;

    public void writeDateTime(long var1, int var3, int var4) throws E;

    public void writeDateTime(long var1, int var3, String var4) throws E;

    public static class Adapter<E extends Exception>
    implements ValueWriter<E> {
        @Override
        public void writeNull() throws E {
        }

        @Override
        public void writeBoolean(boolean value) throws E {
        }

        @Override
        public void writeInteger(byte value) throws E {
        }

        @Override
        public void writeInteger(short value) throws E {
        }

        @Override
        public void writeInteger(int value) throws E {
        }

        @Override
        public void writeInteger(long value) throws E {
        }

        @Override
        public void writeFloatingPoint(float value) throws E {
        }

        @Override
        public void writeFloatingPoint(double value) throws E {
        }

        @Override
        public void writeString(String value) throws E {
        }

        @Override
        public void writeString(char value) throws E {
        }

        @Override
        public void beginArray(int size, ArrayType arrayType) throws E {
        }

        @Override
        public void endArray() throws E {
        }

        @Override
        public void writeByteArray(byte[] value) throws E {
        }

        @Override
        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws E {
        }

        @Override
        public void writeDuration(long months, long days, long seconds, int nanos) {
        }

        @Override
        public void writeDate(long epochDay) throws E {
        }

        @Override
        public void writeLocalTime(long nanoOfDay) throws E {
        }

        @Override
        public void writeTime(long nanosOfDayUTC, int offsetSeconds) throws E {
        }

        @Override
        public void writeLocalDateTime(long epochSecond, int nano) throws E {
        }

        @Override
        public void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) throws E {
        }

        @Override
        public void writeDateTime(long epochSecondUTC, int nano, String zoneId) throws E {
        }
    }

    public static enum ArrayType {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        STRING,
        CHAR,
        POINT,
        ZONED_DATE_TIME,
        LOCAL_DATE_TIME,
        DATE,
        ZONED_TIME,
        LOCAL_TIME,
        DURATION;

    }
}

