/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.invoke.MethodHandle;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;

public final class TimeValue
extends TemporalValue<OffsetTime, TimeValue> {
    private final OffsetTime value;
    private static final String OFFSET_PATTERN = "(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?)";
    static final String TIME_PATTERN = "(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:.(?<shortFraction>[0-9]{1,9}))?)?)?))(?:(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?))?";
    private static final Pattern PATTERN = Pattern.compile("(?:T)?(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:.(?<shortFraction>[0-9]{1,9}))?)?)?))(?:(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?))?");
    private static final Pattern OFFSET = Pattern.compile("(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?)");

    public static TimeValue time(OffsetTime time) {
        return new TimeValue(Objects.requireNonNull(time, "OffsetTime"));
    }

    public static TimeValue time(int hour, int minute, int second, int nanosOfSecond, String offset) {
        return TimeValue.time(hour, minute, second, nanosOfSecond, TimeValue.parseOffset(offset));
    }

    public static TimeValue time(int hour, int minute, int second, int nanosOfSecond, ZoneOffset offset) {
        return new TimeValue(OffsetTime.of(hour, minute, second, nanosOfSecond, offset));
    }

    public static TimeValue time(long nanosOfDayUTC, ZoneOffset offset) {
        return new TimeValue(OffsetTime.ofInstant(Instant.ofEpochSecond(0L, nanosOfDayUTC), offset));
    }

    public static TimeValue parse(CharSequence text, Supplier<ZoneId> defaultZone) {
        return TimeValue.parse(TimeValue.class, PATTERN, TimeValue::parse, text, defaultZone);
    }

    public static TimeValue parse(TextValue text, Supplier<ZoneId> defaultZone) {
        return TimeValue.parse(TimeValue.class, PATTERN, TimeValue::parse, text, defaultZone);
    }

    public static TimeValue now(Clock clock) {
        return new TimeValue(OffsetTime.now(clock));
    }

    public static TimeValue now(Clock clock, String timezone) {
        return TimeValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static TimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return StructureBuilder.build(TimeValue.builder(defaultZone), map);
    }

    public static TimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        throw new UnsupportedOperationException("not implemented");
    }

    static int validNano(AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
        long ms = IntegralValue.safeCastIntegral("millisecond", millisecond, 0L);
        long us = IntegralValue.safeCastIntegral("microsecond", microsecond, 0L);
        long ns = IntegralValue.safeCastIntegral("nanosecond", nanosecond, 0L);
        if (ms < 0L || ms >= 1000L) {
            throw new IllegalArgumentException("Invalid millisecond: " + ms);
        }
        if (us < 0L || us >= (long)(millisecond != null || nanosecond != null ? 1000 : 1000000)) {
            throw new IllegalArgumentException("Invalid microsecond: " + us);
        }
        if (ns < 0L || ns >= (long)(millisecond != null || microsecond != null ? 1000 : 1000000000)) {
            throw new IllegalArgumentException("Invalid nanosecond: " + ns);
        }
        return (int)(ms * 1000000L + us * 1000L + ns);
    }

    static StructureBuilder<AnyValue, TimeValue> builder(final Supplier<ZoneId> defaultZone) {
        return new TimeBuilder<AnyValue, TimeValue>(){

            @Override
            protected ZoneId timezone(AnyValue timezone) {
                return timezone == null ? (ZoneId)defaultZone.get() : this.timezoneOf(timezone);
            }

            @Override
            protected TimeValue selectTime(AnyValue temporal) {
                OffsetTime time = this.offsetTime(temporal);
                return time != null ? TimeValue.time(time) : null;
            }

            @Override
            protected TimeValue constructTime(AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }

            private OffsetTime offsetTime(AnyValue value) {
                if (value instanceof TemporalValue) {
                    try {
                        return OffsetTime.from(((TemporalValue)value).temporal());
                    }
                    catch (DateTimeException e) {
                        return null;
                    }
                }
                return null;
            }
        };
    }

    private TimeValue(OffsetTime value) {
        this.value = value;
    }

    @Override
    public int compareTo(TimeValue other) {
        return this.value.compareTo(other.value);
    }

    @Override
    OffsetTime temporal() {
        return this.value;
    }

    @Override
    public boolean equals(Value other) {
        return other instanceof TimeValue && this.value.isEqual(((TimeValue)other).value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        int offset = this.value.getOffset().getTotalSeconds();
        long seconds = this.value.getLong(ChronoField.SECOND_OF_DAY);
        seconds = ((long)(-offset) % DurationValue.SECONDS_PER_DAY + seconds + DurationValue.SECONDS_PER_DAY) % DurationValue.SECONDS_PER_DAY;
        long nano = seconds * 1000000000L + (long)this.value.getNano();
        writer.writeTime(nano, offset);
    }

    @Override
    public String prettyPrint() {
        return this.value.format(DateTimeFormatter.ISO_TIME);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.ZONED_TIME;
    }

    @Override
    protected int computeHash() {
        return Long.hashCode(this.value.toLocalTime().toNanoOfDay() - (long)this.value.getOffset().getTotalSeconds() * 1000000000L);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapTime(this);
    }

    @Override
    public TimeValue add(DurationValue duration) {
        return this.replacement(this.value.plusNanos(duration.nanosOfDay()));
    }

    @Override
    public TimeValue sub(DurationValue duration) {
        return this.replacement(this.value.minusNanos(duration.nanosOfDay()));
    }

    @Override
    TimeValue replacement(OffsetTime time) {
        return time == this.value ? this : new TimeValue(time);
    }

    static ZoneOffset parseOffset(String offset) {
        Matcher matcher = OFFSET.matcher(offset);
        if (matcher.matches()) {
            return TimeValue.parseOffset(matcher);
        }
        throw new IllegalArgumentException("Not a valid offset: " + offset);
    }

    static ZoneOffset parseOffset(Matcher matcher) {
        String zone = matcher.group("zone");
        if (null == zone) {
            return null;
        }
        if ("Z".equalsIgnoreCase(zone)) {
            return ZoneOffset.UTC;
        }
        int factor = zone.charAt(0) == '+' ? 1 : -1;
        int hours = Integer.parseInt(matcher.group("zoneHour"));
        int minutes = LocalTimeValue.optInt(matcher.group("zoneMinute"));
        return ZoneOffset.ofHoursMinutes(factor * hours, factor * minutes);
    }

    private static TimeValue parse(Matcher matcher, Supplier<ZoneId> defaultZone) {
        return new TimeValue(OffsetTime.of(LocalTimeValue.parseTime(matcher), TimeValue.zoneOffset(TimeValue.parseOffset(matcher, defaultZone))));
    }

    private static ZoneId parseOffset(Matcher matcher, Supplier<ZoneId> defaultZone) {
        ZoneOffset offset = TimeValue.parseOffset(matcher);
        return offset != null ? offset : defaultZone.get();
    }

    private static ZoneOffset zoneOffset(ZoneId zoneId) {
        return zoneId instanceof ZoneOffset ? (ZoneOffset)zoneId : zoneId.getRules().getOffset(Instant.now());
    }

    static abstract class TimeBuilder<Input, Result>
    extends TemporalValue.Builder<Input, Result> {
        TimeBuilder() {
        }

        @Override
        protected final boolean supportsDate() {
            return false;
        }

        @Override
        protected final boolean supportsTime() {
            return true;
        }

        @Override
        protected Result selectDateTime(Input temporal) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result selectDateAndTime(Input date, Input time) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result selectDateWithConstructedTime(Input date, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result selectDate(Input temporal) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructYear(Input year) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructCalendarDate(Input year, Input month, Input day) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructCalendarDateWithSelectedTime(Input year, Input month, Input day, Input time) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructCalendarDateWithConstructedTime(Input year, Input month, Input day, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructWeekDate(Input year, Input week, Input dayOfWeek) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructWeekDateWithSelectedTime(Input year, Input week, Input dayOfWeek, Input time) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructWeekDateWithConstructedTime(Input year, Input week, Input dayOfWeek, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructQuarterDate(Input year, Input quarter, Input dayOfQuarter) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructQuarterDateWithSelectedTime(Input year, Input quarter, Input dayOfQuarter, Input time) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructQuarterDateWithConstructedTime(Input year, Input quarter, Input dayOfQuarter, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructOrdinalDate(Input year, Input ordinalDay) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructOrdinalDateWithSelectedTime(Input year, Input ordinalDay, Input time) {
            throw new IllegalStateException("date not supported");
        }

        @Override
        protected Result constructOrdinalDateWithConstructedTime(Input year, Input ordinalDay, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("date not supported");
        }
    }

    public static abstract class Compiler<Input>
    extends TimeBuilder<Input, MethodHandle> {
    }
}

