/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.TextValue;

public abstract class TemporalValue<T extends Temporal, V extends TemporalValue<T, V>>
extends ScalarValue
implements Temporal,
Comparable<V> {
    private static final String DEFAULT_WHEN = "statement";

    TemporalValue() {
    }

    public abstract TemporalValue add(DurationValue var1);

    public abstract TemporalValue sub(DurationValue var1);

    abstract T temporal();

    abstract V replacement(T var1);

    public final T asObjectCopy() {
        return this.temporal();
    }

    public final V with(TemporalAdjuster adjuster) {
        return this.replacement(this.temporal().with(adjuster));
    }

    public final V plus(TemporalAmount amount) {
        return this.replacement(this.temporal().plus(amount));
    }

    public final V minus(TemporalAmount amount) {
        return this.replacement(this.temporal().minus(amount));
    }

    public final V minus(long amountToSubtract, TemporalUnit unit) {
        return this.replacement(this.temporal().minus(amountToSubtract, unit));
    }

    @Override
    public final boolean isSupported(TemporalUnit unit) {
        return this.temporal().isSupported(unit);
    }

    public final V with(TemporalField field, long newValue) {
        return this.replacement(this.temporal().with(field, newValue));
    }

    public final V plus(long amountToAdd, TemporalUnit unit) {
        return this.replacement(this.temporal().plus(amountToAdd, unit));
    }

    @Override
    public final long until(Temporal endExclusive, TemporalUnit unit) {
        return this.temporal().until(endExclusive, unit);
    }

    @Override
    public final ValueRange range(TemporalField field) {
        return this.temporal().range(field);
    }

    @Override
    public final int get(TemporalField field) {
        return this.temporal().get(field);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        return this.temporal().query(query);
    }

    @Override
    public final boolean isSupported(TemporalField field) {
        return this.temporal().isSupported(field);
    }

    @Override
    public final long getLong(TemporalField field) {
        return this.temporal().getLong(field);
    }

    @Override
    public final NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "<" + this.prettyPrint() + ">";
    }

    @Override
    public final boolean equals(boolean x) {
        return false;
    }

    @Override
    public final boolean equals(long x) {
        return false;
    }

    @Override
    public final boolean equals(double x) {
        return false;
    }

    @Override
    public final boolean equals(char x) {
        return false;
    }

    @Override
    public final boolean equals(String x) {
        return false;
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, Function<Matcher, VALUE> parser, CharSequence text) {
        VALUE result;
        Matcher matcher = pattern.matcher(text);
        VALUE VALUE = result = matcher.matches() ? (VALUE)parser.apply(matcher) : null;
        if (result == null) {
            throw new DateTimeParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text, 0);
        }
        return result;
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, Function<Matcher, VALUE> parser, TextValue text) {
        VALUE result;
        Matcher matcher = text.matcher(pattern);
        VALUE VALUE = result = matcher != null && matcher.matches() ? (VALUE)parser.apply(matcher) : null;
        if (result == null) {
            throw new DateTimeParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text.stringValue(), 0);
        }
        return result;
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, BiFunction<Matcher, Supplier<ZoneId>, VALUE> parser, CharSequence text, Supplier<ZoneId> defaultZone) {
        VALUE result;
        Matcher matcher = pattern.matcher(text);
        VALUE VALUE = result = matcher.matches() ? (VALUE)parser.apply(matcher, defaultZone) : null;
        if (result == null) {
            throw new DateTimeParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text, 0);
        }
        return result;
    }

    static <VALUE> VALUE parse(Class<VALUE> type, Pattern pattern, BiFunction<Matcher, Supplier<ZoneId>, VALUE> parser, TextValue text, Supplier<ZoneId> defaultZone) {
        VALUE result;
        Matcher matcher = text.matcher(pattern);
        VALUE VALUE = result = matcher != null && matcher.matches() ? (VALUE)parser.apply(matcher, defaultZone) : null;
        if (result == null) {
            throw new DateTimeParseException("Text cannot be parsed to a " + TemporalValue.valueName(type), text.stringValue(), 0);
        }
        return result;
    }

    private static <VALUE> String valueName(Class<VALUE> type) {
        String name = type.getSimpleName();
        return name.substring(0, name.length() - 5);
    }

    private static <Input> Input assignment(Field field, Input oldValue, Input newValue) {
        if (oldValue != null) {
            throw new IllegalArgumentException("cannot re-assign " + (Object)((Object)field));
        }
        return newValue;
    }

    private static final class OrdinalDate<Input>
    extends ConstructDate<Input> {
        private Input ordinalDay;

        OrdinalDate(Input year) {
            this.year = year;
        }

        @Override
        ConstructDate<Input> assign(Field field, Input value) {
            switch (field) {
                case year: {
                    this.year = TemporalValue.assignment(field, this.year, value);
                    return this;
                }
                case ordinalDay: {
                    this.ordinalDay = TemporalValue.assignment(field, this.ordinalDay, value);
                    return this;
                }
            }
            throw new IllegalArgumentException("Cannot assign " + (Object)((Object)field) + " to ordinal date.");
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder) {
            return builder.constructOrdinalDate(this.year, this.ordinalDay);
        }

        @Override
        <Result> Result selectTime(Input time, Builder<Input, Result> builder) {
            return builder.constructOrdinalDateWithSelectedTime(this.year, this.ordinalDay, time);
        }

        @Override
        <Result> Result constructTime(Builder<Input, Result> builder, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            return builder.constructOrdinalDateWithConstructedTime(this.year, this.ordinalDay, hour, minute, second, millisecond, microsecond, nanosecond);
        }
    }

    private static final class QuarterDate<Input>
    extends ConstructDate<Input> {
        private Input quarter;
        private Input dayOfQuarter;

        QuarterDate(Input year) {
            this.year = year;
        }

        @Override
        ConstructDate<Input> assign(Field field, Input value) {
            switch (field) {
                case year: {
                    this.year = TemporalValue.assignment(field, this.year, value);
                    return this;
                }
                case quarter: {
                    this.quarter = TemporalValue.assignment(field, this.quarter, value);
                    return this;
                }
                case dayOfQuarter: {
                    this.dayOfQuarter = TemporalValue.assignment(field, this.dayOfQuarter, value);
                    return this;
                }
            }
            throw new IllegalArgumentException("Cannot assign " + (Object)((Object)field) + " to quarter date.");
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder) {
            return builder.constructQuarterDate(this.year, this.quarter, this.dayOfQuarter);
        }

        @Override
        <Result> Result selectTime(Input time, Builder<Input, Result> builder) {
            return builder.constructQuarterDateWithSelectedTime(this.year, this.quarter, this.dayOfQuarter, time);
        }

        @Override
        <Result> Result constructTime(Builder<Input, Result> builder, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            return builder.constructQuarterDateWithConstructedTime(this.year, this.quarter, this.dayOfQuarter, hour, minute, second, millisecond, microsecond, nanosecond);
        }
    }

    private static final class WeekDate<Input>
    extends ConstructDate<Input> {
        private Input week;
        private Input dayOfWeek;

        WeekDate(Input year) {
            this.year = year;
        }

        @Override
        ConstructDate<Input> assign(Field field, Input value) {
            switch (field) {
                case year: {
                    this.year = TemporalValue.assignment(field, this.year, value);
                    return this;
                }
                case week: {
                    this.week = TemporalValue.assignment(field, this.week, value);
                    return this;
                }
                case dayOfWeek: {
                    this.dayOfWeek = TemporalValue.assignment(field, this.dayOfWeek, value);
                    return this;
                }
            }
            throw new IllegalArgumentException("Cannot assign " + (Object)((Object)field) + " to week date.");
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder) {
            return builder.constructWeekDate(this.year, this.week, this.dayOfWeek);
        }

        @Override
        <Result> Result selectTime(Input time, Builder<Input, Result> builder) {
            return builder.constructWeekDateWithSelectedTime(this.year, this.week, this.dayOfWeek, time);
        }

        @Override
        <Result> Result constructTime(Builder<Input, Result> builder, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            return builder.constructWeekDateWithConstructedTime(this.year, this.week, this.dayOfWeek, hour, minute, second, millisecond, microsecond, nanosecond);
        }
    }

    private static final class CalendarDate<Input>
    extends ConstructDate<Input> {
        private Input month;
        private Input day;

        CalendarDate(Input year) {
            this.year = year;
        }

        @Override
        ConstructDate<Input> assign(Field field, Input value) {
            switch (field) {
                case year: {
                    this.year = TemporalValue.assignment(field, this.year, value);
                    return this;
                }
                case month: {
                    this.month = TemporalValue.assignment(field, this.month, value);
                    return this;
                }
                case day: {
                    this.day = TemporalValue.assignment(field, this.day, value);
                    return this;
                }
            }
            throw new IllegalArgumentException("Cannot assign " + (Object)((Object)field) + " to calendar date.");
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder) {
            return builder.constructCalendarDate(this.year, this.month, this.day);
        }

        @Override
        <Result> Result selectTime(Input time, Builder<Input, Result> builder) {
            return builder.constructCalendarDateWithSelectedTime(this.year, this.month, this.day, time);
        }

        @Override
        <Result> Result constructTime(Builder<Input, Result> builder, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            return builder.constructCalendarDateWithConstructedTime(this.year, this.month, this.day, hour, minute, second, millisecond, microsecond, nanosecond);
        }
    }

    private static class ConstructDate<Input>
    extends DateBuilder<Input> {
        Input year;

        private ConstructDate() {
        }

        @Override
        ConstructDate<Input> assign(Field field, Input value) {
            switch (field) {
                case year: {
                    this.year = TemporalValue.assignment(field, this.year, value);
                    return this;
                }
                case quarter: 
                case dayOfQuarter: {
                    return new QuarterDate<Input>(this.year).assign(field, (Object)value);
                }
                case month: 
                case day: {
                    return new CalendarDate<Input>(this.year).assign(field, (Object)value);
                }
                case week: 
                case dayOfWeek: {
                    return new WeekDate<Input>(this.year).assign(field, (Object)value);
                }
                case ordinalDay: {
                    return new OrdinalDate<Input>(this.year).assign(field, (Object)value);
                }
            }
            throw new IllegalStateException("Not a date field: " + (Object)((Object)field));
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder) {
            return builder.constructYear(this.year);
        }

        @Override
        <Result> Result selectTime(Input time, Builder<Input, Result> builder) {
            throw new IllegalStateException("Cannot specify time for a year.");
        }

        @Override
        <Result> Result constructTime(Builder<Input, Result> builder, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("Cannot specify time for a year.");
        }
    }

    private static final class ConstructTime<Input>
    extends TimeBuilder<Input> {
        private Input hour;
        private Input minute;
        private Input second;
        private Input millisecond;
        private Input microsecond;
        private Input nanosecond;

        private ConstructTime() {
        }

        @Override
        void assign(Field field, Input value) {
            switch (field) {
                case hour: {
                    this.hour = TemporalValue.assignment(field, this.hour, value);
                    break;
                }
                case minute: {
                    this.minute = TemporalValue.assignment(field, this.minute, value);
                    break;
                }
                case second: {
                    this.second = TemporalValue.assignment(field, this.second, value);
                    break;
                }
                case millisecond: {
                    this.millisecond = TemporalValue.assignment(field, this.millisecond, value);
                    break;
                }
                case microsecond: {
                    this.microsecond = TemporalValue.assignment(field, this.microsecond, value);
                    break;
                }
                case nanosecond: {
                    this.nanosecond = TemporalValue.assignment(field, this.nanosecond, value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Not a time field: " + (Object)((Object)field));
                }
            }
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder) {
            return builder.constructTime(this.hour, this.minute, this.second, this.millisecond, this.microsecond, this.nanosecond);
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder, DateBuilder<Input> date) {
            return date.constructTime(builder, this.hour, this.minute, this.second, this.millisecond, this.microsecond, this.nanosecond);
        }
    }

    private static final class SelectTime<Input>
    extends TimeBuilder<Input> {
        private final Input temporal;

        SelectTime(Input temporal) {
            this.temporal = temporal;
        }

        @Override
        void assign(Field field, Input value) {
            throw new IllegalArgumentException("cannot assign " + (Object)((Object)field) + " when selecting time");
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder) {
            return builder.selectTime(this.temporal);
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder, DateBuilder<Input> date) {
            return date.selectTime(this.temporal, builder);
        }
    }

    private static final class SelectDate<Input>
    extends DateBuilder<Input> {
        private final Input temporal;

        SelectDate(Input temporal) {
            this.temporal = temporal;
        }

        @Override
        SelectDate<Input> assign(Field field, Input value) {
            throw new IllegalArgumentException("cannot assign " + (Object)((Object)field) + " when selecting date");
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder) {
            return builder.selectDate(this.temporal);
        }

        @Override
        <Result> Result selectTime(Input time, Builder<Input, Result> builder) {
            return builder.selectDateAndTime(this.temporal, time);
        }

        @Override
        <Result> Result constructTime(Builder<Input, Result> builder, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            return builder.selectDateWithConstructedTime(this.temporal, hour, minute, second, millisecond, microsecond, nanosecond);
        }
    }

    private static abstract class TimeBuilder<Input> {
        private TimeBuilder() {
        }

        abstract void assign(Field var1, Input var2);

        abstract <Result> Result build(Builder<Input, Result> var1);

        abstract <Result> Result build(Builder<Input, Result> var1, DateBuilder<Input> var2);
    }

    private static abstract class DateBuilder<Input> {
        private DateBuilder() {
        }

        abstract DateBuilder<Input> assign(Field var1, Input var2);

        abstract <Result> Result build(Builder<Input, Result> var1);

        abstract <Result> Result selectTime(Input var1, Builder<Input, Result> var2);

        abstract <Result> Result constructTime(Builder<Input, Result> var1, Input var2, Input var3, Input var4, Input var5, Input var6, Input var7);
    }

    private static final class DateTimeBuilder<Input>
    extends BuilderState<Input> {
        private DateBuilder<Input> date;
        private TimeBuilder<Input> time;

        private DateTimeBuilder() {
        }

        @Override
        BuilderState<Input> assign(Field field, Input value) {
            if (field.field.isDateBased()) {
                if (this.date == null) {
                    this.date = new ConstructDate();
                }
                this.date = this.date.assign(field, value);
            } else {
                if (this.time == null) {
                    this.time = new ConstructTime();
                }
                this.time.assign(field, value);
            }
            return this;
        }

        @Override
        BuilderState<Input> date(Input date) {
            if (this.date != null) {
                throw new IllegalArgumentException("cannot select date when also assigning date");
            }
            this.date = new SelectDate<Input>(date);
            return this;
        }

        @Override
        BuilderState<Input> time(Input time) {
            if (this.time != null) {
                throw new IllegalArgumentException("cannot select time when also assigning time");
            }
            this.time = new SelectTime<Input>(time);
            return this;
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder) {
            if (this.time == null) {
                return this.date.build(builder);
            }
            if (this.date == null) {
                return this.time.build(builder);
            }
            return this.time.build(builder, this.date);
        }
    }

    private static final class SelectDateTime<Input>
    extends BuilderState<Input> {
        private final Input datetime;

        SelectDateTime(Input temporal) {
            this.datetime = temporal;
        }

        @Override
        BuilderState<Input> assign(Field field, Input value) {
            throw new IllegalArgumentException("Cannot assign " + (Object)((Object)field) + " when selecting datetime.");
        }

        @Override
        BuilderState<Input> date(Input date) {
            throw new IllegalArgumentException("Cannot select date when selecting datetime.");
        }

        @Override
        BuilderState<Input> time(Input time) {
            throw new IllegalArgumentException("Cannot select time when selecting datetime.");
        }

        @Override
        <Result> Result build(Builder<Input, Result> builder) {
            return builder.selectDateTime(this.datetime);
        }
    }

    private static abstract class BuilderState<Input> {
        private BuilderState() {
        }

        abstract BuilderState<Input> assign(Field var1, Input var2);

        abstract BuilderState<Input> date(Input var1);

        abstract BuilderState<Input> time(Input var1);

        abstract <Result> Result build(Builder<Input, Result> var1);
    }

    private static class Field
    extends Enum<Field> {
        public static final /* enum */ Field year = new Field(ChronoField.YEAR);
        public static final /* enum */ Field quarter = new Field(IsoFields.QUARTER_OF_YEAR);
        public static final /* enum */ Field month = new Field(ChronoField.MONTH_OF_YEAR);
        public static final /* enum */ Field week = new Field(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
        public static final /* enum */ Field ordinalDay = new Field(ChronoField.DAY_OF_YEAR);
        public static final /* enum */ Field dayOfQuarter = new Field(IsoFields.DAY_OF_QUARTER);
        public static final /* enum */ Field dayOfWeek = new Field(ChronoField.DAY_OF_WEEK);
        public static final /* enum */ Field day = new Field(ChronoField.DAY_OF_MONTH);
        public static final /* enum */ Field hour = new Field(ChronoField.HOUR_OF_DAY);
        public static final /* enum */ Field minute = new Field(ChronoField.MINUTE_OF_HOUR);
        public static final /* enum */ Field second = new Field(ChronoField.SECOND_OF_MINUTE);
        public static final /* enum */ Field millisecond = new Field(ChronoField.MILLI_OF_SECOND);
        public static final /* enum */ Field microsecond = new Field(ChronoField.MICRO_OF_SECOND);
        public static final /* enum */ Field nanosecond = new Field(ChronoField.NANO_OF_SECOND);
        public static final /* enum */ Field timezone = new Field(){

            @Override
            <Input> void assign(Builder<Input, ?> builder, Input value) {
                if (((Builder)builder).timezone != null) {
                    throw new IllegalArgumentException("Cannot assign timezone twice.");
                }
                ((Builder)builder).timezone = value;
            }
        };
        public static final /* enum */ Field date = new Field(){

            @Override
            <Input> void assign(Builder<Input, ?> builder, Input value) {
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.date(value);
            }
        };
        public static final /* enum */ Field time = new Field(){

            @Override
            <Input> void assign(Builder<Input, ?> builder, Input value) {
                if (((Builder)builder).state == null) {
                    ((Builder)builder).state = new DateTimeBuilder();
                }
                ((Builder)builder).state = ((Builder)builder).state.time(value);
            }
        };
        public static final /* enum */ Field datetime = new Field(){

            @Override
            <Input> void assign(Builder<Input, ?> builder, Input value) {
                if (((Builder)builder).state != null) {
                    throw new IllegalArgumentException("Cannot select datetime when assigning other fields.");
                }
                ((Builder)builder).state = new SelectDateTime<Input>(value);
            }
        };
        private static final Map<String, Field> fields;
        private final TemporalField field;
        private static final /* synthetic */ Field[] $VALUES;

        public static Field[] values() {
            return (Field[])$VALUES.clone();
        }

        public static Field valueOf(String name) {
            return Enum.valueOf(Field.class, name);
        }

        private Field(TemporalField field) {
            this.field = field;
        }

        private Field() {
            this.field = null;
        }

        <Input> void assign(Builder<Input, ?> builder, Input value) {
            assert (this.field != null) : "method should have been overridden";
            if (!((Builder)builder).supports(this.field)) {
                throw new IllegalArgumentException("Not supported: " + this.name());
            }
            if (((Builder)builder).state == null) {
                ((Builder)builder).state = new DateTimeBuilder();
            }
            ((Builder)builder).state = ((Builder)builder).state.assign(this, value);
        }

        static {
            $VALUES = new Field[]{year, quarter, month, week, ordinalDay, dayOfQuarter, dayOfWeek, day, hour, minute, second, millisecond, microsecond, nanosecond, timezone, date, time, datetime};
            fields = new HashMap<String, Field>();
            for (Field field : Field.values()) {
                fields.put(field.name().toLowerCase(), field);
            }
            fields.put("weekday", dayOfWeek);
            fields.put("quarterday", dayOfQuarter);
        }
    }

    static abstract class Builder<Input, Result>
    implements StructureBuilder<Input, Result> {
        private BuilderState<Input> state;
        private Input timezone;

        Builder() {
        }

        @Override
        public final Result build() {
            if (this.state == null) {
                throw new IllegalArgumentException("Builder state empty");
            }
            return this.state.build(this);
        }

        @Override
        public final StructureBuilder<Input, Result> add(String fieldName, Input value) {
            Field field = (Field)((Object)Field.fields.get(fieldName.toLowerCase()));
            if (field == null) {
                throw new IllegalArgumentException("No such field: " + fieldName);
            }
            field.assign(this, value);
            return this;
        }

        private boolean supports(TemporalField field) {
            if (field.isDateBased()) {
                return this.supportsDate();
            }
            if (field.isTimeBased()) {
                return this.supportsTime();
            }
            throw new IllegalStateException("Fields should be either date based or time based");
        }

        protected abstract boolean supportsDate();

        protected abstract boolean supportsTime();

        protected abstract ZoneId timezone(Input var1);

        protected abstract Result selectDateTime(Input var1);

        protected abstract Result selectDateAndTime(Input var1, Input var2);

        protected abstract Result selectDateWithConstructedTime(Input var1, Input var2, Input var3, Input var4, Input var5, Input var6, Input var7);

        protected abstract Result selectDate(Input var1);

        protected abstract Result selectTime(Input var1);

        protected abstract Result constructYear(Input var1);

        protected abstract Result constructTime(Input var1, Input var2, Input var3, Input var4, Input var5, Input var6);

        protected abstract Result constructCalendarDate(Input var1, Input var2, Input var3);

        protected abstract Result constructCalendarDateWithSelectedTime(Input var1, Input var2, Input var3, Input var4);

        protected abstract Result constructCalendarDateWithConstructedTime(Input var1, Input var2, Input var3, Input var4, Input var5, Input var6, Input var7, Input var8, Input var9);

        protected abstract Result constructWeekDate(Input var1, Input var2, Input var3);

        protected abstract Result constructWeekDateWithSelectedTime(Input var1, Input var2, Input var3, Input var4);

        protected abstract Result constructWeekDateWithConstructedTime(Input var1, Input var2, Input var3, Input var4, Input var5, Input var6, Input var7, Input var8, Input var9);

        protected abstract Result constructQuarterDate(Input var1, Input var2, Input var3);

        protected abstract Result constructQuarterDateWithSelectedTime(Input var1, Input var2, Input var3, Input var4);

        protected abstract Result constructQuarterDateWithConstructedTime(Input var1, Input var2, Input var3, Input var4, Input var5, Input var6, Input var7, Input var8, Input var9);

        protected abstract Result constructOrdinalDate(Input var1, Input var2);

        protected abstract Result constructOrdinalDateWithSelectedTime(Input var1, Input var2, Input var3);

        protected abstract Result constructOrdinalDateWithConstructedTime(Input var1, Input var2, Input var3, Input var4, Input var5, Input var6, Input var7, Input var8);

        protected final ZoneId optionalTimezone() {
            return this.timezone == null ? null : this.timezone();
        }

        protected final ZoneId timezone() {
            return this.timezone(this.timezone);
        }

        protected final ZoneId timezoneOf(AnyValue timezone) {
            if (timezone instanceof TextValue) {
                return DateTimeValue.parseZoneName(((TextValue)timezone).stringValue());
            }
            throw new UnsupportedOperationException("Cannot convert to ZoneId: " + timezone);
        }
    }
}

