/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.StringWrappingStringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public abstract class StringValue
extends TextValue {
    static TextValue EMTPY = new StringValue(){

        @Override
        protected int computeHash() {
            return 0;
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public TextValue substring(int start, int end) {
            return this;
        }

        @Override
        public TextValue trim() {
            return this;
        }

        @Override
        public TextValue ltrim() {
            return this;
        }

        @Override
        public TextValue rtrim() {
            return this;
        }

        @Override
        public TextValue reverse() {
            return this;
        }

        @Override
        public TextValue toLower() {
            return this;
        }

        @Override
        public TextValue toUpper() {
            return this;
        }

        @Override
        public TextValue replace(String find, String replace) {
            if (find.isEmpty()) {
                return Values.stringValue(replace);
            }
            return this;
        }

        @Override
        public int compareTo(TextValue other) {
            return -other.length();
        }

        @Override
        Matcher matcher(Pattern pattern) {
            return pattern.matcher("");
        }

        @Override
        String value() {
            return "";
        }
    };

    abstract String value();

    @Override
    public boolean equals(Value value) {
        return value.equals(this.value());
    }

    @Override
    public boolean equals(char x) {
        return this.value().length() == 1 && this.value().charAt(0) == x;
    }

    @Override
    public boolean equals(String x) {
        return this.value().equals(x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeString(this.value());
    }

    @Override
    public TextValue toLower() {
        return new StringWrappingStringValue(this.value().toLowerCase());
    }

    @Override
    public TextValue toUpper() {
        return new StringWrappingStringValue(this.value().toUpperCase());
    }

    @Override
    public ListValue split(String separator) {
        assert (separator != null);
        String asString = this.value();
        if (separator.equals(asString)) {
            return EMPTY_SPLIT;
        }
        String[] split = asString.split(separator);
        return VirtualValues.fromArray(Values.stringArray(split));
    }

    @Override
    public TextValue replace(String find, String replace) {
        assert (find != null);
        assert (replace != null);
        return Values.stringValue(this.value().replace(find, replace));
    }

    @Override
    public Object asObjectCopy() {
        return this.value();
    }

    public String toString() {
        return String.format("String(\"%s\")", this.value());
    }

    @Override
    public String stringValue() {
        return this.value();
    }

    @Override
    public String prettyPrint() {
        return String.format("'%s'", this.value());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapString(this);
    }

    @Override
    public int compareTo(TextValue other) {
        int c1;
        String thisString = this.value();
        String thatString = other.stringValue();
        int len1 = thisString.length();
        int len2 = thatString.length();
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; k += Character.charCount(c1)) {
            int c2;
            c1 = thisString.codePointAt(k);
            if (c1 == (c2 = thatString.codePointAt(k))) continue;
            return c1 - c2;
        }
        return this.length() - other.length();
    }
}

