/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

final class NoValue
extends Value {
    static final NoValue NO_VALUE = new NoValue();

    private NoValue() {
    }

    @Override
    public boolean eq(Object other) {
        return this == other;
    }

    @Override
    public Boolean ternaryEquals(AnyValue other) {
        return null;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapNoValue();
    }

    @Override
    public int computeHash() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Value other) {
        return this == other;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeNull();
    }

    @Override
    public Object asObjectCopy() {
        return null;
    }

    public String toString() {
        return this.prettyPrint();
    }

    @Override
    public String prettyPrint() {
        return "NO_VALUE";
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.NO_VALUE;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }
}

