/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.invoke.MethodHandle;
import java.time.Clock;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;

public final class LocalTimeValue
extends TemporalValue<LocalTime, LocalTimeValue> {
    private final LocalTime value;
    static final String TIME_PATTERN = "(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:.(?<shortFraction>[0-9]{1,9}))?)?)?))";
    private static final Pattern PATTERN = Pattern.compile("(?:T)?(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:.(?<shortFraction>[0-9]{1,9}))?)?)?))");

    public static LocalTimeValue localTime(LocalTime value) {
        return new LocalTimeValue(Objects.requireNonNull(value, "LocalTime"));
    }

    public static LocalTimeValue localTime(int hour, int minute, int second, int nanosOfSecond) {
        return new LocalTimeValue(LocalTime.of(hour, minute, second, nanosOfSecond));
    }

    public static LocalTimeValue localTime(long nanoOfDay) {
        return new LocalTimeValue(LocalTime.ofNanoOfDay(nanoOfDay));
    }

    public static LocalTimeValue inUTC(TimeValue time) {
        return new LocalTimeValue(time.temporal().withOffsetSameInstant(ZoneOffset.UTC).toLocalTime());
    }

    public static LocalTimeValue parse(CharSequence text) {
        return LocalTimeValue.parse(LocalTimeValue.class, PATTERN, LocalTimeValue::parse, text);
    }

    public static LocalTimeValue parse(TextValue text) {
        return LocalTimeValue.parse(LocalTimeValue.class, PATTERN, LocalTimeValue::parse, text);
    }

    public static LocalTimeValue now(Clock clock) {
        return new LocalTimeValue(LocalTime.now(clock));
    }

    public static LocalTimeValue now(Clock clock, String timezone) {
        return LocalTimeValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static LocalTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return StructureBuilder.build(LocalTimeValue.builder(defaultZone), map);
    }

    public static LocalTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        throw new UnsupportedOperationException("not implemented");
    }

    static StructureBuilder<AnyValue, LocalTimeValue> builder(final Supplier<ZoneId> defaultZone) {
        return new TimeValue.TimeBuilder<AnyValue, LocalTimeValue>(){

            @Override
            protected ZoneId timezone(AnyValue timezone) {
                return timezone == null ? (ZoneId)defaultZone.get() : this.timezoneOf(timezone);
            }

            @Override
            protected LocalTimeValue selectTime(AnyValue temporal) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalTimeValue constructTime(AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }
        };
    }

    private LocalTimeValue(LocalTime value) {
        this.value = value;
    }

    @Override
    public int compareTo(LocalTimeValue other) {
        return this.value.compareTo(other.value);
    }

    @Override
    LocalTime temporal() {
        return this.value;
    }

    @Override
    public boolean equals(Value other) {
        return other instanceof LocalTimeValue && this.value.equals(((LocalTimeValue)other).value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeLocalTime(this.value.getLong(ChronoField.NANO_OF_DAY));
    }

    @Override
    public String prettyPrint() {
        return this.value.format(DateTimeFormatter.ISO_LOCAL_TIME);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.LOCAL_TIME;
    }

    @Override
    protected int computeHash() {
        return this.value.hashCode();
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLocalTime(this);
    }

    @Override
    public LocalTimeValue add(DurationValue duration) {
        return this.replacement(this.value.plusNanos(duration.nanosOfDay()));
    }

    @Override
    public LocalTimeValue sub(DurationValue duration) {
        return this.replacement(this.value.minusNanos(duration.nanosOfDay()));
    }

    @Override
    LocalTimeValue replacement(LocalTime time) {
        return time == this.value ? this : new LocalTimeValue(time);
    }

    private static LocalTimeValue parse(Matcher matcher) {
        return new LocalTimeValue(LocalTimeValue.parseTime(matcher));
    }

    static LocalTime parseTime(Matcher matcher) {
        int fraction;
        int second;
        int minute;
        int hour;
        String longHour = matcher.group("longHour");
        if (longHour != null) {
            hour = Integer.parseInt(longHour);
            minute = LocalTimeValue.optInt(matcher.group("longMinute"));
            second = LocalTimeValue.optInt(matcher.group("longSecond"));
            fraction = LocalTimeValue.parseNanos(matcher.group("longFraction"));
        } else {
            String shortHour = matcher.group("shortHour");
            hour = Integer.parseInt(shortHour);
            minute = LocalTimeValue.optInt(matcher.group("shortMinute"));
            second = LocalTimeValue.optInt(matcher.group("shortSecond"));
            fraction = LocalTimeValue.parseNanos(matcher.group("shortFraction"));
        }
        return LocalTime.of(hour, minute, second, fraction);
    }

    private static int parseNanos(String value) {
        if (value == null) {
            return 0;
        }
        int nanos = Integer.parseInt(value);
        if (nanos != 0) {
            for (int i = value.length(); i < 9; ++i) {
                nanos *= 10;
            }
        }
        return nanos;
    }

    static int optInt(String value) {
        return value == null ? 0 : Integer.parseInt(value);
    }

    public static abstract class Compiler<Input>
    extends TimeValue.TimeBuilder<Input, MethodHandle> {
    }
}

