/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.invoke.MethodHandle;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;

public final class LocalDateTimeValue
extends TemporalValue<LocalDateTime, LocalDateTimeValue> {
    private final LocalDateTime value;
    private static final Pattern PATTERN = Pattern.compile(DateValue.DATE_PATTERN + "(?<time>T" + "(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:.(?<shortFraction>[0-9]{1,9}))?)?)?))" + ")?", 2);

    public static LocalDateTimeValue localDateTime(DateValue date, LocalTimeValue time) {
        return new LocalDateTimeValue(LocalDateTime.of(date.temporal(), time.temporal()));
    }

    public static LocalDateTimeValue localDateTime(int year, int month, int day, int hour, int minute, int second, int nanoOfSecond) {
        return new LocalDateTimeValue(LocalDateTime.of(year, month, day, hour, minute, second, nanoOfSecond));
    }

    public static LocalDateTimeValue localDateTime(LocalDateTime value) {
        return new LocalDateTimeValue(Objects.requireNonNull(value, "LocalDateTime"));
    }

    public static LocalDateTimeValue localDateTime(long epochSecond, long nano) {
        return new LocalDateTimeValue(LocalDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nano), ZoneOffset.UTC));
    }

    public static LocalDateTimeValue inUTC(DateTimeValue datetime) {
        return new LocalDateTimeValue(datetime.temporal().withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime());
    }

    public static LocalDateTimeValue parse(CharSequence text) {
        return LocalDateTimeValue.parse(LocalDateTimeValue.class, PATTERN, LocalDateTimeValue::parse, text);
    }

    public static LocalDateTimeValue parse(TextValue text) {
        return LocalDateTimeValue.parse(LocalDateTimeValue.class, PATTERN, LocalDateTimeValue::parse, text);
    }

    public static LocalDateTimeValue now(Clock clock) {
        return new LocalDateTimeValue(LocalDateTime.now(clock));
    }

    public static LocalDateTimeValue now(Clock clock, String timezone) {
        return LocalDateTimeValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static LocalDateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return StructureBuilder.build(LocalDateTimeValue.builder(defaultZone), map);
    }

    public static LocalDateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        throw new UnsupportedOperationException("not implemented");
    }

    static StructureBuilder<AnyValue, LocalDateTimeValue> builder(final Supplier<ZoneId> defaultZone) {
        return new DateTimeValue.DateTimeBuilder<AnyValue, LocalDateTimeValue>(){

            @Override
            protected ZoneId timezone(AnyValue timezone) {
                return timezone == null ? (ZoneId)defaultZone.get() : this.timezoneOf(timezone);
            }

            @Override
            protected LocalDateTimeValue selectDateTime(AnyValue temporal) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue selectDateAndTime(AnyValue date, AnyValue time) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue selectDateWithConstructedTime(AnyValue date, AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue selectDate(AnyValue temporal) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructYear(AnyValue year) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructCalendarDate(AnyValue year, AnyValue month, AnyValue day) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructCalendarDateWithSelectedTime(AnyValue year, AnyValue month, AnyValue day, AnyValue time) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructCalendarDateWithConstructedTime(AnyValue year, AnyValue month, AnyValue day, AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructWeekDate(AnyValue year, AnyValue week, AnyValue dayOfWeek) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructWeekDateWithSelectedTime(AnyValue year, AnyValue week, AnyValue dayOfWeek, AnyValue time) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructWeekDateWithConstructedTime(AnyValue year, AnyValue week, AnyValue dayOfWeek, AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructQuarterDate(AnyValue year, AnyValue quarter, AnyValue dayOfQuarter) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructQuarterDateWithSelectedTime(AnyValue year, AnyValue quarter, AnyValue dayOfQuarter, AnyValue time) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructQuarterDateWithConstructedTime(AnyValue year, AnyValue quarter, AnyValue dayOfQuarter, AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructOrdinalDate(AnyValue year, AnyValue ordinalDay) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructOrdinalDateWithSelectedTime(AnyValue year, AnyValue ordinalDay, AnyValue time) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected LocalDateTimeValue constructOrdinalDateWithConstructedTime(AnyValue year, AnyValue ordinalDay, AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }
        };
    }

    private LocalDateTimeValue(LocalDateTime value) {
        this.value = value;
    }

    @Override
    public int compareTo(LocalDateTimeValue other) {
        return this.value.compareTo(other.value);
    }

    @Override
    LocalDateTime temporal() {
        return this.value;
    }

    @Override
    public boolean equals(Value other) {
        return other instanceof LocalDateTimeValue && this.value.equals(((LocalDateTimeValue)other).value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeLocalDateTime(this.value.toEpochSecond(ZoneOffset.UTC), this.value.getNano());
    }

    @Override
    public String prettyPrint() {
        return this.value.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.LOCAL_DATE_TIME;
    }

    @Override
    protected int computeHash() {
        return this.value.toInstant(ZoneOffset.UTC).hashCode();
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLocalDateTime(this);
    }

    @Override
    public LocalDateTimeValue add(DurationValue duration) {
        return this.replacement(this.value.plus(duration));
    }

    @Override
    public LocalDateTimeValue sub(DurationValue duration) {
        return this.replacement(this.value.minus(duration));
    }

    @Override
    LocalDateTimeValue replacement(LocalDateTime dateTime) {
        return dateTime == this.value ? this : new LocalDateTimeValue(dateTime);
    }

    private static LocalDateTimeValue parse(Matcher matcher) {
        return LocalDateTimeValue.localDateTime(LocalDateTime.of(DateValue.parseDate(matcher), LocalDateTimeValue.optTime(matcher)));
    }

    static LocalTime optTime(Matcher matcher) {
        return matcher.group("time") != null ? LocalTimeValue.parseTime(matcher) : LocalTime.MIN;
    }

    public static abstract class Compiler<Input>
    extends DateTimeValue.DateTimeBuilder<Input, MethodHandle> {
    }
}

