/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NonPrimitiveArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class DurationArray
extends NonPrimitiveArray<DurationValue> {
    private final DurationValue[] value;

    DurationArray(DurationValue[] value) {
        assert (value != null);
        this.value = value;
    }

    protected DurationValue[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDurationArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(DurationValue[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.beginArray(this.value.length, ValueWriter.ArrayType.DURATION);
        for (DurationValue x : this.value) {
            x.writeTo(writer);
        }
        writer.endArray();
    }

    @Override
    public AnyValue value(int offset) {
        return Values.durationValue(this.value[offset]);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.DURATION_ARRAY;
    }
}

