/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.invoke.MethodHandle;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;

public final class DateValue
extends TemporalValue<LocalDate, DateValue> {
    private final LocalDate value;
    static final boolean QUARTER_DATES = FeatureToggles.flag(DateValue.class, (String)"QUARTER_DATES", (boolean)true);
    static final String DATE_PATTERN = "(?:(?<shortYear>[0-9]{4})(?:(?<shortMonth>[0-9]{2})(?<shortDay>[0-9]{2})?|W(?<shortWeek>[0-9]{2})(?<shortDOW>[0-9])?|" + (QUARTER_DATES ? "Q(?<shortQuarter>[0-9])(?<shortDOQ>[0-9]{2})?|" : "") + "(?<shortDOY>[0-9]{3}))|(?<longYear>(?:[0-9]{4}|[+-][0-9]{1,9}))(?:-(?<longMonth>[0-9]{1,2})(?:-(?<longDay>[0-9]{1,2}))?|-W(?<longWeek>[0-9]{1,2})(?:-(?<longDOW>[0-9]))?|" + (QUARTER_DATES ? "-Q(?<longQuarter>[0-9])(?:-(?<longDOQ>[0-9]{1,2}))?|" : "") + "-(?<longDOY>[0-9]{3}))?)";
    private static final Pattern PATTERN = Pattern.compile(DATE_PATTERN);

    public static DateValue date(LocalDate value) {
        return new DateValue(Objects.requireNonNull(value, "LocalDate"));
    }

    public static DateValue date(int year, int month, int day) {
        return new DateValue(LocalDate.of(year, month, day));
    }

    public static DateValue weekDate(int year, int week, int dayOfWeek) {
        return new DateValue(DateValue.localWeekDate(year, week, dayOfWeek));
    }

    public static DateValue quarterDate(int year, int quarter, int dayOfQuarter) {
        return new DateValue(DateValue.localQuarterDate(year, quarter, dayOfQuarter));
    }

    public static DateValue ordinalDate(int year, int dayOfYear) {
        return new DateValue(LocalDate.ofYearDay(year, dayOfYear));
    }

    public static DateValue epochDate(long epochDay) {
        return new DateValue(LocalDate.ofEpochDay(epochDay));
    }

    public static DateValue parse(CharSequence text) {
        return DateValue.parse(DateValue.class, PATTERN, DateValue::parse, text);
    }

    public static DateValue parse(TextValue text) {
        return DateValue.parse(DateValue.class, PATTERN, DateValue::parse, text);
    }

    public static DateValue now(Clock clock) {
        return new DateValue(LocalDate.now(clock));
    }

    public static DateValue now(Clock clock, String timezone) {
        return DateValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static DateValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return StructureBuilder.build(DateValue.builder(defaultZone), map);
    }

    public static DateValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        throw new UnsupportedOperationException("not implemented");
    }

    static StructureBuilder<AnyValue, DateValue> builder(final Supplier<ZoneId> defaultZone) {
        return new DateBuilder<AnyValue, DateValue>(){

            @Override
            protected ZoneId timezone(AnyValue timezone) {
                return timezone == null ? (ZoneId)defaultZone.get() : this.timezoneOf(timezone);
            }

            @Override
            protected DateValue selectDate(AnyValue temporal) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateValue constructYear(AnyValue year) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateValue constructCalendarDate(AnyValue year, AnyValue month, AnyValue day) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateValue constructWeekDate(AnyValue year, AnyValue week, AnyValue dayOfWeek) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateValue constructQuarterDate(AnyValue year, AnyValue quarter, AnyValue dayOfQuarter) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateValue constructOrdinalDate(AnyValue year, AnyValue ordinalDay) {
                throw new UnsupportedOperationException("not implemented");
            }
        };
    }

    private DateValue(LocalDate value) {
        this.value = value;
    }

    @Override
    public int compareTo(DateValue other) {
        return this.value.compareTo(other.value);
    }

    @Override
    LocalDate temporal() {
        return this.value;
    }

    @Override
    public boolean equals(Value other) {
        return other instanceof DateValue && this.value.equals(((DateValue)other).value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeDate(this.value.toEpochDay());
    }

    @Override
    public String prettyPrint() {
        return this.value.format(DateTimeFormatter.ISO_DATE);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.DATE;
    }

    @Override
    protected int computeHash() {
        return Long.hashCode(this.value.toEpochDay());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDate(this);
    }

    @Override
    public DateValue add(DurationValue duration) {
        return this.replacement(this.value.plusMonths(duration.totalMonths()).plusDays(duration.totalDays()));
    }

    @Override
    public DateValue sub(DurationValue duration) {
        return this.replacement(this.value.minusMonths(duration.totalMonths()).minusDays(duration.totalDays()));
    }

    @Override
    DateValue replacement(LocalDate date) {
        return date == this.value ? this : new DateValue(date);
    }

    static LocalDate parseDate(Matcher matcher) {
        String longYear = matcher.group("longYear");
        if (longYear != null) {
            return DateValue.parse(matcher, Integer.parseInt(longYear), "longMonth", "longDay", "longWeek", "longDOW", "longQuarter", "longDOQ", "longDOY");
        }
        return DateValue.parse(matcher, Integer.parseInt(matcher.group("shortYear")), "shortMonth", "shortDay", "shortWeek", "shortDOW", "shortQuarter", "shortDOQ", "shortDOY");
    }

    private static LocalDate parse(Matcher matcher, int year, String MONTH, String DAY, String WEEK, String DOW, String QUARTER, String DOQ, String DOY) {
        String month = matcher.group(MONTH);
        if (month != null) {
            return LocalDate.of(year, Integer.parseInt(month), DateValue.optInt(matcher.group(DAY)));
        }
        String week = matcher.group(WEEK);
        if (week != null) {
            return DateValue.localWeekDate(year, Integer.parseInt(week), DateValue.optInt(matcher.group(DOW)));
        }
        String quarter = matcher.group(QUARTER);
        if (quarter != null) {
            return DateValue.localQuarterDate(year, Integer.parseInt(quarter), DateValue.optInt(matcher.group(DOQ)));
        }
        String doy = matcher.group(DOY);
        if (doy != null) {
            return LocalDate.ofYearDay(year, Integer.parseInt(doy));
        }
        return LocalDate.of(year, 1, 1);
    }

    private static DateValue parse(Matcher matcher) {
        return new DateValue(DateValue.parseDate(matcher));
    }

    private static int optInt(String value) {
        return value == null ? 1 : Integer.parseInt(value);
    }

    private static LocalDate localWeekDate(int year, int week, int dayOfWeek) {
        LocalDate weekOne = LocalDate.of(year, 1, 4);
        LocalDate withWeek = weekOne.with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, week);
        if (week == 53 && withWeek.get(IsoFields.WEEK_BASED_YEAR) != year) {
            throw new DateTimeException(String.format("Year %d does not contain %d weeks.", year, week));
        }
        return withWeek.with(ChronoField.DAY_OF_WEEK, dayOfWeek);
    }

    private static LocalDate localQuarterDate(int year, int quarter, int dayOfQuarter) {
        if (quarter == 2 && dayOfQuarter == 92) {
            throw new DateTimeException("Quarter 2 only has 91 days.");
        }
        LocalDate yearDate = LocalDate.ofYearDay(year, dayOfQuarter);
        if (!(quarter != 1 || dayOfQuarter <= 90 || yearDate.isLeapYear() && dayOfQuarter != 92)) {
            throw new DateTimeException(String.format("Quarter 1 of %d only has %d days.", year, yearDate.isLeapYear() ? 91 : 90));
        }
        return yearDate.with(IsoFields.QUARTER_OF_YEAR, quarter).with(IsoFields.DAY_OF_QUARTER, dayOfQuarter);
    }

    private static abstract class DateBuilder<Input, Result>
    extends TemporalValue.Builder<Input, Result> {
        private DateBuilder() {
        }

        @Override
        protected final boolean supportsDate() {
            return true;
        }

        @Override
        protected final boolean supportsTime() {
            return false;
        }

        @Override
        protected final Result selectDateTime(Input temporal) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result selectDateAndTime(Input date, Input time) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result selectDateWithConstructedTime(Input date, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result selectTime(Input temporal) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result constructCalendarDateWithSelectedTime(Input year, Input month, Input day, Input time) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result constructCalendarDateWithConstructedTime(Input year, Input month, Input day, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result constructWeekDateWithSelectedTime(Input year, Input week, Input dayOfWeek, Input time) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result constructWeekDateWithConstructedTime(Input year, Input week, Input dayOfWeek, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result constructQuarterDateWithSelectedTime(Input year, Input quarter, Input dayOfQuarter, Input time) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result constructQuarterDateWithConstructedTime(Input year, Input quarter, Input dayOfQuarter, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result constructOrdinalDateWithSelectedTime(Input year, Input ordinalDay, Input time) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result constructOrdinalDateWithConstructedTime(Input year, Input ordinalDay, Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("time not supported");
        }

        @Override
        protected final Result constructTime(Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("time not supported");
        }
    }

    public static abstract class Compiler<Input>
    extends DateBuilder<Input, MethodHandle> {
    }
}

