/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.invoke.MethodHandle;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;

public final class DateTimeValue
extends TemporalValue<ZonedDateTime, DateTimeValue> {
    private final ZonedDateTime value;
    private static final String ZONE_NAME = "(?<zoneName>[a-zA-Z0-9_ /+-]+)";
    private static final Pattern PATTERN = Pattern.compile(DateValue.DATE_PATTERN + "(?<time>T" + "(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:.(?<shortFraction>[0-9]{1,9}))?)?)?))(?:(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?))?" + "(?:\\[" + "(?<zoneName>[a-zA-Z0-9_ /+-]+)" + "\\])?)?", 2);
    private static final DateTimeFormatter ZONE_NAME_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendZoneRegionId().toFormatter();

    public static DateTimeValue datetime(DateValue date, LocalTimeValue time, ZoneId zone) {
        return new DateTimeValue(ZonedDateTime.of(date.temporal(), time.temporal(), zone));
    }

    public static DateTimeValue datetime(DateValue date, TimeValue time) {
        OffsetTime t = time.temporal();
        return new DateTimeValue(ZonedDateTime.of(date.temporal(), t.toLocalTime(), t.getOffset()));
    }

    public static DateTimeValue datetime(int year, int month, int day, int hour, int minute, int second, int nanoOfSecond, String zone) {
        return DateTimeValue.datetime(year, month, day, hour, minute, second, nanoOfSecond, DateTimeValue.parseZoneName(zone));
    }

    public static DateTimeValue datetime(int year, int month, int day, int hour, int minute, int second, int nanoOfSecond, ZoneId zone) {
        return new DateTimeValue(ZonedDateTime.of(year, month, day, hour, minute, second, nanoOfSecond, zone));
    }

    public static DateTimeValue datetime(long epochSecond, long nano, ZoneOffset zoneOffset) {
        return new DateTimeValue(ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nano), zoneOffset));
    }

    public static DateTimeValue datetime(ZonedDateTime datetime) {
        return new DateTimeValue(Objects.requireNonNull(datetime, "ZonedDateTime"));
    }

    public static DateTimeValue datetime(OffsetDateTime datetime) {
        return new DateTimeValue(Objects.requireNonNull(datetime, "OffsetDateTime").toZonedDateTime());
    }

    public static DateTimeValue datetime(long epochSecondUTC, long nano, ZoneId zone) {
        return new DateTimeValue(ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecondUTC, nano), zone));
    }

    public static DateTimeValue parse(CharSequence text, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse(DateTimeValue.class, PATTERN, DateTimeValue::parse, text, defaultZone);
    }

    public static DateTimeValue parse(TextValue text, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse(DateTimeValue.class, PATTERN, DateTimeValue::parse, text, defaultZone);
    }

    public static DateTimeValue now(Clock clock) {
        return new DateTimeValue(ZonedDateTime.now(clock));
    }

    public static DateTimeValue now(Clock clock, String timezone) {
        return DateTimeValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static DateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return StructureBuilder.build(DateTimeValue.builder(defaultZone), map);
    }

    public static DateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        throw new UnsupportedOperationException("not implemented");
    }

    static StructureBuilder<AnyValue, DateTimeValue> builder(final Supplier<ZoneId> defaultZone) {
        return new DateTimeBuilder<AnyValue, DateTimeValue>(){

            @Override
            protected ZoneId timezone(AnyValue timezone) {
                return timezone == null ? (ZoneId)defaultZone.get() : this.timezoneOf(timezone);
            }

            @Override
            protected DateTimeValue selectDateTime(AnyValue temporal) {
                if (temporal instanceof DateTimeValue) {
                    DateTimeValue value = (DateTimeValue)temporal;
                    ZoneId zone = this.optionalTimezone();
                    return zone == null ? value : new DateTimeValue(ZonedDateTime.of(value.temporal().toLocalDateTime(), zone));
                }
                if (temporal instanceof LocalDateTimeValue) {
                    return new DateTimeValue(ZonedDateTime.of(((LocalDateTimeValue)temporal).temporal(), this.timezone()));
                }
                throw new IllegalArgumentException("Cannot select datetime from: " + temporal);
            }

            @Override
            protected DateTimeValue selectDateAndTime(AnyValue date, AnyValue time) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue selectDateWithConstructedTime(AnyValue date, AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue selectDate(AnyValue temporal) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructYear(AnyValue year) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructCalendarDate(AnyValue year, AnyValue month, AnyValue day) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructCalendarDateWithSelectedTime(AnyValue year, AnyValue month, AnyValue day, AnyValue time) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructCalendarDateWithConstructedTime(AnyValue year, AnyValue month, AnyValue day, AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                return DateTimeValue.datetime((int)IntegralValue.safeCastIntegral("year", year, 0L), (int)IntegralValue.safeCastIntegral("month", month, 1L), (int)IntegralValue.safeCastIntegral("day", day, 1L), (int)IntegralValue.safeCastIntegral("hour", hour, 0L), (int)IntegralValue.safeCastIntegral("minute", minute, 0L), (int)IntegralValue.safeCastIntegral("second", second, 0L), TimeValue.validNano(millisecond, microsecond, nanosecond), this.timezone());
            }

            @Override
            protected DateTimeValue constructWeekDate(AnyValue year, AnyValue week, AnyValue dayOfWeek) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructWeekDateWithSelectedTime(AnyValue year, AnyValue week, AnyValue dayOfWeek, AnyValue time) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructWeekDateWithConstructedTime(AnyValue year, AnyValue week, AnyValue dayOfWeek, AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructQuarterDate(AnyValue year, AnyValue quarter, AnyValue dayOfQuarter) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructQuarterDateWithSelectedTime(AnyValue year, AnyValue quarter, AnyValue dayOfQuarter, AnyValue time) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructQuarterDateWithConstructedTime(AnyValue year, AnyValue quarter, AnyValue dayOfQuarter, AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructOrdinalDate(AnyValue year, AnyValue ordinalDay) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructOrdinalDateWithSelectedTime(AnyValue year, AnyValue ordinalDay, AnyValue time) {
                throw new UnsupportedOperationException("not implemented");
            }

            @Override
            protected DateTimeValue constructOrdinalDateWithConstructedTime(AnyValue year, AnyValue ordinalDay, AnyValue hour, AnyValue minute, AnyValue second, AnyValue millisecond, AnyValue microsecond, AnyValue nanosecond) {
                throw new UnsupportedOperationException("not implemented");
            }
        };
    }

    private DateTimeValue(ZonedDateTime value) {
        this.value = value;
    }

    @Override
    ZonedDateTime temporal() {
        return this.value;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof DateTimeValue) {
            DateTimeValue that = (DateTimeValue)other;
            return this.value.toInstant().equals(that.value.toInstant());
        }
        return false;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        Instant instant = this.value.toInstant();
        ZoneId zone = this.value.getZone();
        if (zone instanceof ZoneOffset) {
            ZoneOffset offset = (ZoneOffset)zone;
            writer.writeDateTime(instant.getEpochSecond(), instant.getNano(), offset.getTotalSeconds());
        } else {
            writer.writeDateTime(instant.getEpochSecond(), instant.getNano(), zone.getId());
        }
    }

    @Override
    public int compareTo(DateTimeValue other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public String prettyPrint() {
        return this.value.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.ZONED_DATE_TIME;
    }

    @Override
    protected int computeHash() {
        return this.value.toInstant().hashCode();
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDateTime(this);
    }

    @Override
    public DateTimeValue add(DurationValue duration) {
        return this.replacement(this.value.plus(duration));
    }

    @Override
    public DateTimeValue sub(DurationValue duration) {
        return this.replacement(this.value.minus(duration));
    }

    @Override
    DateTimeValue replacement(ZonedDateTime datetime) {
        return this.value == datetime ? this : new DateTimeValue(datetime);
    }

    private static DateTimeValue parse(Matcher matcher, Supplier<ZoneId> defaultZone) {
        ZoneId zone;
        LocalDateTime local = LocalDateTime.of(DateValue.parseDate(matcher), LocalDateTimeValue.optTime(matcher));
        String zoneName = matcher.group("zoneName");
        ZoneOffset offset = TimeValue.parseOffset(matcher);
        if (zoneName != null) {
            ZoneOffset expected;
            zone = DateTimeValue.parseZoneName(zoneName);
            if (offset != null && !(expected = zone.getRules().getOffset(local)).equals(offset)) {
                throw new IllegalArgumentException("Timezone and offset do not match: " + matcher.group());
            }
        } else {
            zone = offset != null ? offset : defaultZone.get();
        }
        return new DateTimeValue(ZonedDateTime.of(local, zone));
    }

    static ZoneId parseZoneName(String zoneName) {
        return ZONE_NAME_PARSER.parse(zoneName.replace(' ', '_')).query(TemporalQueries.zoneId());
    }

    static abstract class DateTimeBuilder<Input, Result>
    extends TemporalValue.Builder<Input, Result> {
        DateTimeBuilder() {
        }

        @Override
        protected final boolean supportsDate() {
            return true;
        }

        @Override
        protected final boolean supportsTime() {
            return true;
        }

        @Override
        protected final Result selectTime(Input temporal) {
            throw new IllegalStateException("Cannot select time without date for datetime.");
        }

        @Override
        protected final Result constructTime(Input hour, Input minute, Input second, Input millisecond, Input microsecond, Input nanosecond) {
            throw new IllegalStateException("Cannot construct time without date for datetime.");
        }
    }

    public static abstract class Compiler<Input>
    extends DateTimeBuilder<Input, MethodHandle> {
    }
}

