/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public abstract class BooleanValue
extends ScalarValue {
    public static final BooleanValue TRUE = new BooleanValue(){

        @Override
        public boolean equals(Value other) {
            return this == other;
        }

        @Override
        public boolean equals(boolean x) {
            return x;
        }

        @Override
        public int computeHash() {
            return 1231;
        }

        @Override
        public boolean booleanValue() {
            return true;
        }

        @Override
        public int compareTo(BooleanValue other) {
            return other.booleanValue() ? 0 : 1;
        }

        @Override
        public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
            writer.writeBoolean(true);
        }

        @Override
        public Object asObjectCopy() {
            return Boolean.TRUE;
        }

        @Override
        public String prettyPrint() {
            return Boolean.toString(true);
        }

        public String toString() {
            return String.format("Boolean('%s')", Boolean.toString(true));
        }
    };
    public static final BooleanValue FALSE = new BooleanValue(){

        @Override
        public boolean equals(Value other) {
            return this == other;
        }

        @Override
        public boolean equals(boolean x) {
            return !x;
        }

        @Override
        public int computeHash() {
            return 1237;
        }

        @Override
        public boolean booleanValue() {
            return false;
        }

        @Override
        public int compareTo(BooleanValue other) {
            return !other.booleanValue() ? 0 : -1;
        }

        @Override
        public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
            writer.writeBoolean(false);
        }

        @Override
        public Object asObjectCopy() {
            return Boolean.FALSE;
        }

        @Override
        public String prettyPrint() {
            return Boolean.toString(false);
        }

        public String toString() {
            return String.format("Boolean('%s')", Boolean.toString(false));
        }
    };

    private BooleanValue() {
    }

    @Override
    public boolean eq(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapBoolean(this);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.BOOLEAN;
    }

    public abstract boolean booleanValue();

    public abstract int compareTo(BooleanValue var1);

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }
}

