/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

final class StringWrappingStringValue
extends StringValue {
    final String value;

    StringWrappingStringValue(String value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    String value() {
        return this.value;
    }

    @Override
    public int length() {
        return this.value.codePointCount(0, this.value.length());
    }

    @Override
    public int computeHash() {
        int codePoint;
        if (this.value.isEmpty()) {
            return 0;
        }
        int h = 1;
        int length = this.value.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = this.value.codePointAt(offset);
            h = 31 * h + codePoint;
        }
        return h;
    }

    @Override
    public TextValue substring(int start, int length) {
        int s = Math.min(start, this.length());
        int e = Math.min(s + length, this.length());
        int codePointStart = this.value.offsetByCodePoints(0, s);
        int codePointEnd = this.value.offsetByCodePoints(0, e);
        return Values.stringValue(this.value.substring(codePointStart, codePointEnd));
    }

    @Override
    public TextValue trim() {
        int start = this.ltrimIndex(this.value);
        int end = this.rtrimIndex(this.value);
        return Values.stringValue(this.value.substring(start, Math.max(end, start)));
    }

    @Override
    public TextValue ltrim() {
        int start = this.ltrimIndex(this.value);
        return Values.stringValue(this.value.substring(start, this.value.length()));
    }

    @Override
    public TextValue rtrim() {
        int end = this.rtrimIndex(this.value);
        return Values.stringValue(this.value.substring(0, end));
    }

    @Override
    public TextValue reverse() {
        StringBuilder stringBuilder = new StringBuilder(this.value());
        return Values.stringValue(stringBuilder.reverse().toString());
    }

    private int ltrimIndex(String value) {
        int start;
        int codePoint;
        int length = value.length();
        for (start = 0; start < length && Character.isWhitespace(codePoint = value.codePointAt(start)); start += Character.charCount(codePoint)) {
        }
        return start;
    }

    private int rtrimIndex(String value) {
        int codePoint;
        int end;
        for (end = value.length(); end > 0 && Character.isWhitespace(codePoint = value.codePointBefore(end)); --end) {
        }
        return end;
    }
}

