/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public abstract class PointArray
extends ArrayValue {
    abstract PointValue[] value();

    @Override
    public int length() {
        return this.value().length;
    }

    public PointValue pointValue(int offset) {
        return this.value()[offset];
    }

    @Override
    public boolean equals(Geometry[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof PointArray) {
            return Arrays.equals(this.value(), ((PointArray)other).value());
        }
        return false;
    }

    @Override
    public boolean equals(byte[] x) {
        return false;
    }

    @Override
    public boolean equals(short[] x) {
        return false;
    }

    @Override
    public boolean equals(int[] x) {
        return false;
    }

    @Override
    public boolean equals(long[] x) {
        return false;
    }

    @Override
    public boolean equals(float[] x) {
        return false;
    }

    @Override
    public boolean equals(double[] x) {
        return false;
    }

    @Override
    public boolean equals(boolean[] x) {
        return false;
    }

    @Override
    public boolean equals(char[] x) {
        return false;
    }

    @Override
    public boolean equals(String[] x) {
        return false;
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.GEOMETRY_ARRAY;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public final boolean eq(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof SequenceValue) {
            return this.equals((SequenceValue)other);
        }
        return other instanceof Value && this.equals((Value)other);
    }

    @Override
    public int computeHash() {
        return Arrays.hashCode(this.value());
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public Object asObjectCopy() {
        return this.value().clone();
    }

    @Override
    @Deprecated
    public Object asObject() {
        return this.value();
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value());
    }

    public int compareTo(PointArray other) {
        int x = 0;
        int length = Math.min(this.length(), other.length());
        for (int i = 0; x == 0 && i < length; ++i) {
            x = this.pointValue(i).compareTo(other.pointValue(i));
        }
        if (x == 0) {
            x = this.length() - other.length();
        }
        return x;
    }

    static final class Direct
    extends PointArray {
        final PointValue[] value;

        Direct(PointValue[] value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        PointValue[] value() {
            return this.value;
        }

        public String toString() {
            return String.format("PointArray%s", Arrays.toString(this.value()));
        }

        @Override
        public AnyValue value(int offset) {
            return Values.point(this.value[offset]);
        }
    }
}

