/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Objects;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.values.storable.CRSTable;

public class CoordinateReferenceSystem
implements CRS {
    public static final CoordinateReferenceSystem Cartesian = new CoordinateReferenceSystem("cartesian", CRSTable.SR_ORG, 7203);
    public static final CoordinateReferenceSystem WGS84 = new CoordinateReferenceSystem("WGS-84", CRSTable.EPSG, 4326);
    private final String name;
    private final CRSTable table;
    private final int code;
    private final String href;

    public static CoordinateReferenceSystem get(int tableId, int code) {
        CRSTable table = CRSTable.find(tableId);
        if (tableId == CRSTable.SR_ORG.getTableId() && code == CoordinateReferenceSystem.Cartesian.code) {
            return Cartesian;
        }
        if (tableId == CRSTable.EPSG.getTableId() && code == CoordinateReferenceSystem.WGS84.code) {
            return WGS84;
        }
        return new CoordinateReferenceSystem(table.getName() + "-" + code, table, code);
    }

    public static CoordinateReferenceSystem get(CRS crs) {
        Objects.requireNonNull(crs);
        return CoordinateReferenceSystem.get(crs.getHref());
    }

    public static CoordinateReferenceSystem get(String href) {
        if (CoordinateReferenceSystem.WGS84.href.equals(href)) {
            return WGS84;
        }
        if (CoordinateReferenceSystem.Cartesian.href.equals(href)) {
            return Cartesian;
        }
        throw new IllegalArgumentException("Unknown CRS: " + href);
    }

    CoordinateReferenceSystem(String name, CRSTable table, int code) {
        this.name = name;
        this.table = table;
        this.code = code;
        this.href = table.href(code);
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.name;
    }

    public String getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public CRSTable getTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateReferenceSystem that = (CoordinateReferenceSystem)o;
        return this.href.equals(that.href);
    }

    public int hashCode() {
        return this.href.hashCode();
    }
}

