/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.HashMap;
import java.util.Map;

public enum CRSTable {
    CUSTOM("custom", 0),
    EPSG("epsg", 1),
    SR_ORG("sr-org", 2);

    private static final CRSTable[] TYPES;
    private static final Map<String, CRSTable> all;
    private final String name;
    private final int tableId;

    public static CRSTable find(int tableId) {
        if (tableId < TYPES.length) {
            return TYPES[tableId];
        }
        throw new IllegalArgumentException("No known Coordinate Reference System table: " + tableId);
    }

    public static CRSTable find(String name) {
        CRSTable table = all.get(name);
        if (table != null) {
            return table;
        }
        throw new IllegalArgumentException("No known Coordinate Reference System table: " + name);
    }

    private CRSTable(String name, int tableId) {
        this.name = name;
        this.tableId = tableId;
    }

    public String href(int code) {
        if (this.tableId == CRSTable.CUSTOM.tableId) {
            return "crs://" + this.name + "/" + code + "/";
        }
        return "http://spatialreference.org/ref/" + this.name + "/" + code + "/";
    }

    public String getName() {
        return this.name;
    }

    public int getTableId() {
        return this.tableId;
    }

    static {
        TYPES = CRSTable.values();
        all = new HashMap<String, CRSTable>(TYPES.length);
        for (CRSTable table : TYPES) {
            all.put(table.name, table);
        }
    }
}

