/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;

public class PrettyPrinter
implements AnyValueWriter<RuntimeException> {
    private final Deque<Writer> stack = new ArrayDeque<Writer>();
    private final String quoteMark;

    public PrettyPrinter() {
        this("\"");
    }

    public PrettyPrinter(String quoteMark) {
        this.quoteMark = quoteMark;
        this.stack.push(new ValueWriter());
    }

    @Override
    public void writeNodeReference(long nodeId) {
        this.append(String.format("(id=%d)", nodeId));
    }

    @Override
    public void writeNode(long nodeId, TextArray labels, MapValue properties) {
        this.append(String.format("(id=%d", nodeId));
        String sep = " ";
        for (int i = 0; i < labels.length(); ++i) {
            this.append(sep);
            this.append(":" + labels.stringValue(i));
            sep = "";
        }
        if (properties.size() > 0) {
            this.append(" ");
            properties.writeTo(this);
        }
        this.append(")");
    }

    @Override
    public void writeEdgeReference(long edgeId) {
        this.append(String.format("-[id=%d]-", edgeId));
    }

    @Override
    public void writeEdge(long edgeId, long startNodeId, long endNodeId, TextValue type, MapValue properties) {
        this.append(String.format("-[id=%d :%s", edgeId, type.stringValue()));
        if (properties.size() > 0) {
            this.append(" ");
            properties.writeTo(this);
        }
        this.append("]-");
    }

    @Override
    public void beginMap(int size) {
        this.stack.push(new MapWriter());
    }

    @Override
    public void endMap() {
        assert (!this.stack.isEmpty());
        this.append(this.stack.pop().done());
    }

    @Override
    public void beginList(int size) {
        this.stack.push(new ListWriter());
    }

    @Override
    public void endList() {
        assert (!this.stack.isEmpty());
        this.append(this.stack.pop().done());
    }

    @Override
    public void writePath(NodeValue[] nodes, EdgeValue[] edges) {
        if (nodes.length == 0) {
            return;
        }
        nodes[0].writeTo(this);
        for (int i = 0; i < edges.length; ++i) {
            edges[i].writeTo(this);
            this.append(">");
            nodes[i + 1].writeTo(this);
        }
    }

    @Override
    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws RuntimeException {
        this.append("{geometry: {type: \"Point\", coordinates: ");
        this.append(Arrays.toString(coordinate));
        this.append(", crs: {type: link, properties: {href: \"");
        this.append(crs.getHref());
        this.append("\", code: ");
        this.append(Integer.toString(crs.getCode()));
        this.append("}}}}");
    }

    @Override
    public void writeNull() {
        this.append("<null>");
    }

    @Override
    public void writeBoolean(boolean value) {
        this.append(Boolean.toString(value));
    }

    @Override
    public void writeInteger(byte value) {
        this.append(Byte.toString(value));
    }

    @Override
    public void writeInteger(short value) {
        this.append(Short.toString(value));
    }

    @Override
    public void writeInteger(int value) {
        this.append(Integer.toString(value));
    }

    @Override
    public void writeInteger(long value) {
        this.append(Long.toString(value));
    }

    @Override
    public void writeFloatingPoint(float value) {
        this.append(Float.toString(value));
    }

    @Override
    public void writeFloatingPoint(double value) {
        this.append(Double.toString(value));
    }

    @Override
    public void writeString(String value) {
        this.append(this.quote(value));
    }

    @Override
    public void writeString(char value) {
        this.writeString(Character.toString(value));
    }

    @Override
    public void beginArray(int size, ValueWriter.ArrayType arrayType) {
        this.stack.push(new ListWriter());
    }

    @Override
    public void endArray() {
        assert (!this.stack.isEmpty());
        this.append(this.stack.pop().done());
    }

    @Override
    public void writeByteArray(byte[] value) {
        String sep = "";
        this.append("[");
        for (byte b : value) {
            this.append(sep);
            this.append(Byte.toString(b));
            sep = ", ";
        }
        this.append("]");
    }

    public String value() {
        assert (this.stack.size() == 1);
        return this.stack.getLast().done();
    }

    private void append(String value) {
        assert (!this.stack.isEmpty());
        Writer head = this.stack.peek();
        head.append(value);
    }

    private String quote(String value) {
        assert (!this.stack.isEmpty());
        Writer head = this.stack.peek();
        return head.quote(value);
    }

    private class ListWriter
    extends BaseWriter {
        private String sep;

        ListWriter() {
            this.sep = "";
            this.builder.append("[");
        }

        @Override
        public void append(String value) {
            this.builder.append(this.sep).append(value);
            this.sep = ", ";
        }

        @Override
        public String done() {
            return this.builder.append("]").toString();
        }
    }

    private class MapWriter
    extends BaseWriter {
        private boolean writeKey;
        private String sep;

        MapWriter() {
            this.writeKey = true;
            this.sep = "";
            this.builder.append("{");
        }

        @Override
        public void append(String value) {
            if (this.writeKey) {
                this.builder.append(this.sep).append(value).append(": ");
            } else {
                this.builder.append(value);
            }
            this.writeKey = !this.writeKey;
            this.sep = ", ";
        }

        @Override
        public String done() {
            return this.builder.append("}").toString();
        }

        @Override
        public String quote(String in) {
            return this.writeKey ? in : super.quote(in);
        }
    }

    private class ValueWriter
    extends BaseWriter {
        private ValueWriter() {
        }

        @Override
        public void append(String value) {
            this.builder.append(value);
        }
    }

    private abstract class BaseWriter
    implements Writer {
        protected final StringBuilder builder = new StringBuilder();

        private BaseWriter() {
        }

        @Override
        public String done() {
            return this.builder.toString();
        }

        @Override
        public String quote(String in) {
            return PrettyPrinter.this.quoteMark + in + PrettyPrinter.this.quoteMark;
        }
    }

    private static interface Writer {
        public void append(String var1);

        public String done();

        public String quote(String var1);
    }
}

