/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TextValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class CharValue
extends TextValue {
    final char value;

    CharValue(char value) {
        this.value = value;
    }

    @Override
    public boolean eq(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(boolean x) {
        return false;
    }

    @Override
    public boolean equals(char x) {
        return this.value == x;
    }

    @Override
    public boolean equals(String x) {
        return x.length() == 1 && x.charAt(0) == this.value;
    }

    @Override
    public int computeHash() {
        return 31 + this.value;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeString(this.value);
    }

    @Override
    public Object asObjectCopy() {
        return Character.valueOf(this.value);
    }

    @Override
    public String prettyPrint() {
        return String.format("'%s'", Character.valueOf(this.value));
    }

    @Override
    public String stringValue() {
        return Character.toString(this.value);
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public TextValue substring(int start, int length) {
        if (length != 1 && start != 0) {
            return StringValue.EMTPY;
        }
        return this;
    }

    @Override
    public TextValue trim() {
        if (Character.isWhitespace(this.value)) {
            return StringValue.EMTPY;
        }
        return this;
    }

    @Override
    public TextValue ltrim() {
        return this.trim();
    }

    @Override
    public TextValue rtrim() {
        return this.trim();
    }

    @Override
    public TextValue toLower() {
        return new CharValue(Character.toLowerCase(this.value));
    }

    @Override
    public TextValue toUpper() {
        return new CharValue(Character.toUpperCase(this.value));
    }

    @Override
    public TextArray split(String separator) {
        if (separator.equals(this.stringValue())) {
            return Values.EMPTY_TEXT_ARRAY;
        }
        return Values.stringArray(this.stringValue());
    }

    @Override
    public TextValue replace(String find, String replace) {
        assert (find != null);
        assert (replace != null);
        if (this.stringValue().equals(find)) {
            return Values.stringValue(replace);
        }
        return this;
    }

    @Override
    public TextValue reverse() {
        return this;
    }

    public char value() {
        return this.value;
    }

    @Override
    public int compareTo(TextValue other) {
        return TextValues.compareCharToString(this.value, other.stringValue());
    }

    public String toString() {
        return String.format("Char('%s')", Character.valueOf(this.value));
    }
}

