/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public final class BooleanValue
extends ScalarValue {
    private final boolean value;

    BooleanValue(boolean value) {
        this.value = value;
    }

    @Override
    public boolean eq(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(boolean x) {
        return this.value == x;
    }

    @Override
    public boolean equals(char x) {
        return false;
    }

    @Override
    public boolean equals(String x) {
        return false;
    }

    @Override
    public int computeHash() {
        return this.value ? -1 : 0;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public int compareTo(BooleanValue other) {
        return Boolean.compare(this.value, other.booleanValue());
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeBoolean(this.value);
    }

    @Override
    public Object asObjectCopy() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Boolean.toString(this.value);
    }

    public String toString() {
        return String.format("Boolean('%s')", Boolean.toString(this.value));
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.BOOLEAN;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }
}

