/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Comparator;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ValueTuple {
    private final Value[] values;
    public static Comparator<ValueTuple> COMPARATOR = (left, right) -> {
        if (left.values.length != right.values.length) {
            throw new IllegalStateException("Comparing two ValueTuples of different lengths!");
        }
        int compare = 0;
        for (int i = 0; i < left.values.length; ++i) {
            compare = Values.COMPARATOR.compare(left.valueAt(i), right.valueAt(i));
            if (compare == 0) continue;
            return compare;
        }
        return compare;
    };

    public static ValueTuple of(Value ... values) {
        assert (values.length > 0) : "Empty ValueTuple is not allowed";
        assert (ValueTuple.noNulls(values));
        return new ValueTuple(values);
    }

    public static ValueTuple of(Object ... objects) {
        assert (objects.length > 0) : "Empty ValueTuple is not allowed";
        assert (ValueTuple.noNulls(objects));
        Value[] values = new Value[objects.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Values.of(objects[i]);
        }
        return new ValueTuple(values);
    }

    private ValueTuple(Value[] values) {
        this.values = values;
    }

    public int size() {
        return this.values.length;
    }

    public Value valueAt(int offset) {
        return this.values[offset];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueTuple that = (ValueTuple)o;
        if (that.values.length != this.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(that.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (Value value : this.values) {
            result = 31 * result + ((Object)value).hashCode();
        }
        return result;
    }

    public Value getOnlyValue() {
        assert (this.values.length == 1) : "Assumed single value tuple, but had " + this.values.length;
        return this.values[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "( ";
        for (Value value : this.values) {
            sb.append(sep);
            sep = ", ";
            sb.append(value);
        }
        sb.append(" )");
        return sb.toString();
    }

    private static boolean noNulls(Object[] values) {
        for (Object v : values) {
            if (v != null) continue;
            return false;
        }
        return true;
    }
}

