/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;

abstract class StringValue
extends TextValue {
    StringValue() {
    }

    abstract String value();

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value value) {
        return value.equals(this.value());
    }

    @Override
    public boolean equals(char x) {
        return this.value().length() == 1 && this.value().charAt(0) == x;
    }

    @Override
    public boolean equals(String x) {
        return this.value().equals(x);
    }

    @Override
    public int hashCode() {
        return this.value().hashCode();
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeString(this.value());
    }

    @Override
    public Object asObjectCopy() {
        return this.value();
    }

    public String toString() {
        return String.format("String(\"%s\")", this.value());
    }

    @Override
    public int compareTo(TextValue other) {
        return this.value().compareTo(other.stringValue());
    }

    @Override
    public String stringValue() {
        return this.value();
    }

    @Override
    public String prettyPrint() {
        return String.format("'%s'", this.value());
    }

    static final class Direct
    extends StringValue {
        final String value;

        Direct(String value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        String value() {
            return this.value;
        }
    }
}

