/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.HashMap;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.EdgeReference;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeReference;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.PointValue;

public final class VirtualValues {
    private VirtualValues() {
    }

    public static ListValue list(AnyValue ... values) {
        return new ListValue(values);
    }

    public static MapValue emptyMap() {
        return new MapValue(new HashMap<String, AnyValue>());
    }

    public static MapValue map(String[] keys, AnyValue[] values) {
        assert (keys.length == values.length);
        HashMap<String, AnyValue> map = new HashMap<String, AnyValue>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return new MapValue(map);
    }

    public static MapValue map(HashMap<String, AnyValue> map) {
        return new MapValue(map);
    }

    public static TextValue[] labels(TextValue ... labels) {
        return labels;
    }

    public static NodeReference node(long id) {
        return new NodeReference(id);
    }

    public static EdgeReference edge(long id) {
        return new EdgeReference(id);
    }

    public static PathValue path(NodeValue[] nodes, EdgeValue[] edges) {
        return new PathValue(nodes, edges);
    }

    public static VirtualValue pointCartesian(double x, double y) {
        return new PointValue.CarthesianPointValue(x, y);
    }

    public static VirtualValue pointGeographic(double latitude, double longitude) {
        return new PointValue.GeographicPointValue(latitude, longitude);
    }

    public static NodeValue nodeValue(long id, TextValue[] labels, MapValue properties) {
        return new NodeValue(id, labels, properties);
    }

    public static EdgeValue edgeValue(long id, long startNodeId, long endNodeId, TextValue type, MapValue properties) {
        return new EdgeValue(id, startNodeId, endNodeId, type, properties);
    }
}

