/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

abstract class DoubleArray
extends FloatingPointArray {
    DoubleArray() {
    }

    abstract double[] value();

    @Override
    public int length() {
        return this.value().length;
    }

    @Override
    public double doubleValue(int index) {
        return this.value()[index];
    }

    @Override
    public int hashCode() {
        return NumberValues.hash(this.value());
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value());
    }

    @Override
    public boolean equals(byte[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(short[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(int[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(long[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(float[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(double[] x) {
        return Arrays.equals(x, this.value());
    }

    @Override
    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof SequenceValue) {
            return this.equals((SequenceValue)other);
        }
        return other instanceof Value && this.equals((Value)other);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public Object asObjectCopy() {
        return this.value().clone();
    }

    @Override
    @Deprecated
    public Object asObject() {
        return this.value();
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value());
    }

    @Override
    public AnyValue value(int position) {
        return Values.doubleValue(this.doubleValue(position));
    }

    static final class Direct
    extends DoubleArray {
        final double[] value;

        Direct(double[] value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        double[] value() {
            return this.value;
        }

        public String toString() {
            return String.format("DoubleArray%s", Arrays.toString(this.value()));
        }
    }
}

