/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.virtual.VirtualValueGroup;

class AnyValueComparator
implements Comparator<AnyValue> {
    private final Comparator<Value> valueComparator;
    private final Comparator<VirtualValueGroup> virtualValueGroupComparator;

    AnyValueComparator(Comparator<Value> valueComparator, Comparator<VirtualValueGroup> virtualValueGroupComparator) {
        this.valueComparator = valueComparator;
        this.virtualValueGroupComparator = virtualValueGroupComparator;
    }

    @Override
    public int compare(AnyValue v1, AnyValue v2) {
        assert (v1 != null && v2 != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        boolean isValue1 = v1 instanceof Value;
        boolean isValue2 = v2 instanceof Value;
        int x = -Boolean.compare(isValue1, isValue2);
        if (x == 0) {
            return isValue1 ? this.valueComparator.compare((Value)v1, (Value)v2) : this.compareVirtualValues((VirtualValue)v1, (VirtualValue)v2);
        }
        return x;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof AnyValueComparator;
    }

    public int hashCode() {
        return 1;
    }

    private int compareVirtualValues(VirtualValue v1, VirtualValue v2) {
        VirtualValueGroup id2;
        VirtualValueGroup id1 = v1.valueGroup();
        int x = this.virtualValueGroupComparator.compare(id1, id2 = v2.valueGroup());
        if (x == 0) {
            return v1.compareTo(v2, this);
        }
        return x;
    }
}

