/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

public interface ValueWriter<E extends Exception> {
    public void writeNull() throws E;

    public void writeBoolean(boolean var1) throws E;

    public void writeInteger(byte var1) throws E;

    public void writeInteger(short var1) throws E;

    public void writeInteger(int var1) throws E;

    public void writeInteger(long var1) throws E;

    public void writeFloatingPoint(float var1) throws E;

    public void writeFloatingPoint(double var1) throws E;

    public void writeString(String var1) throws E;

    public void writeString(char var1) throws E;

    default public void writeString(char[] value) throws E {
        this.writeString(value, 0, value.length);
    }

    public void writeString(char[] var1, int var2, int var3) throws E;

    public void beginUTF8(int var1) throws E;

    public void copyUTF8(long var1, int var3) throws E;

    public void endUTF8() throws E;

    public void beginArray(int var1, ArrayType var2) throws E;

    public void endArray() throws E;

    public void writeByteArray(byte[] var1) throws E;

    public static class Adapter<E extends Exception>
    implements ValueWriter<E> {
        @Override
        public void writeNull() throws E {
        }

        @Override
        public void writeBoolean(boolean value) throws E {
        }

        @Override
        public void writeInteger(byte value) throws E {
        }

        @Override
        public void writeInteger(short value) throws E {
        }

        @Override
        public void writeInteger(int value) throws E {
        }

        @Override
        public void writeInteger(long value) throws E {
        }

        @Override
        public void writeFloatingPoint(float value) throws E {
        }

        @Override
        public void writeFloatingPoint(double value) throws E {
        }

        @Override
        public void writeString(String value) throws E {
        }

        @Override
        public void writeString(char value) throws E {
        }

        @Override
        public void writeString(char[] value, int offset, int length) throws E {
        }

        @Override
        public void beginUTF8(int size) throws E {
        }

        @Override
        public void copyUTF8(long fromAddress, int length) throws E {
        }

        @Override
        public void endUTF8() throws E {
        }

        @Override
        public void beginArray(int size, ArrayType arrayType) throws E {
        }

        @Override
        public void endArray() throws E {
        }

        @Override
        public void writeByteArray(byte[] value) throws E {
        }
    }

    public static enum ArrayType {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        STRING,
        CHAR;

    }
}

