/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;

abstract class StringArray
extends TextArray {
    StringArray() {
    }

    abstract String[] value();

    @Override
    public int length() {
        return this.value().length;
    }

    @Override
    public String stringValue(int offset) {
        return this.value()[offset];
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value());
    }

    @Override
    public boolean equals(char[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(String[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public int hashCode() {
        return TextValues.hash(this.value());
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public Object asObjectCopy() {
        return this.value().clone();
    }

    @Override
    @Deprecated
    public Object asObject() {
        return this.value();
    }

    @Override
    public int compareTo(TextArray other) {
        return TextValues.compareTextArrays(this, other);
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value());
    }

    static final class Direct
    extends StringArray {
        final String[] value;

        Direct(String[] value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        String[] value() {
            return this.value;
        }

        public String toString() {
            return String.format("StringArray%s", Arrays.toString(this.value()));
        }
    }
}

