/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Value;
import org.neo4j.values.Values;
import org.neo4j.values.VirtualValue;

final class ArrayHelpers {
    private ArrayHelpers() {
    }

    static boolean isSortedSet(int[] keys) {
        for (int i = 0; i < keys.length - 1; ++i) {
            if (keys[i] < keys[i + 1]) continue;
            return false;
        }
        return true;
    }

    static boolean isSortedSet(VirtualValue[] keys, Comparator<AnyValue> comparator) {
        for (int i = 0; i < keys.length - 1; ++i) {
            if (comparator.compare(keys[i], keys[i + 1]) < 0) continue;
            return false;
        }
        return true;
    }

    static boolean isSortedSet(Value[] keys, Comparator<AnyValue> comparator) {
        for (int i = 0; i < keys.length - 1; ++i) {
            if (comparator.compare(keys[i], keys[i + 1]) < 0) continue;
            return false;
        }
        return true;
    }

    static boolean hasNullOrNoValue(AnyValue[] values) {
        for (AnyValue value : values) {
            if (value != null && value != Values.NO_VALUE) continue;
            return true;
        }
        return false;
    }

    static <T> Iterator<T> asIterator(final T[] array) {
        assert (array != null);
        return new Iterator<T>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < array.length;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return array[this.index++];
            }
        };
    }
}

