/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.values.ArrayValue;
import org.neo4j.values.BooleanArray;
import org.neo4j.values.BooleanValue;
import org.neo4j.values.ByteArray;
import org.neo4j.values.ByteValue;
import org.neo4j.values.CharArray;
import org.neo4j.values.CharValue;
import org.neo4j.values.DoubleArray;
import org.neo4j.values.DoubleValue;
import org.neo4j.values.FloatArray;
import org.neo4j.values.FloatValue;
import org.neo4j.values.FloatingPointValue;
import org.neo4j.values.IntArray;
import org.neo4j.values.IntValue;
import org.neo4j.values.IntegralValue;
import org.neo4j.values.LongArray;
import org.neo4j.values.LongValue;
import org.neo4j.values.NoValue;
import org.neo4j.values.NumberValue;
import org.neo4j.values.ShortArray;
import org.neo4j.values.ShortValue;
import org.neo4j.values.StringArray;
import org.neo4j.values.StringValue;
import org.neo4j.values.TextValue;
import org.neo4j.values.Value;
import org.neo4j.values.ValueComparator;

public final class Values {
    public static final Value MIN_NUMBER = Values.doubleValue(Double.NEGATIVE_INFINITY);
    public static final Value MAX_NUMBER = Values.doubleValue(Double.NaN);
    public static final Value MIN_STRING = Values.stringValue("");
    public static final Value MAX_STRING = Values.booleanValue(false);
    public static final Comparator<Value> COMPARATOR = new ValueComparator(Enum::compareTo);
    public static final Value NO_VALUE = NoValue.NO_VALUE;

    private Values() {
    }

    public static boolean isNumberValue(Object value) {
        return value instanceof NumberValue;
    }

    public static boolean isBooleanValue(Object value) {
        return value instanceof BooleanValue;
    }

    public static boolean isTextValue(Object value) {
        return value instanceof TextValue;
    }

    public static boolean isArrayValue(Value value) {
        return value instanceof ArrayValue;
    }

    public static double coerceToDouble(Value value) {
        if (value instanceof IntegralValue) {
            return ((IntegralValue)value).longValue();
        }
        if (value instanceof FloatingPointValue) {
            return ((FloatingPointValue)value).doubleValue();
        }
        throw new UnsupportedOperationException(String.format("Cannot coerce %s to double", value));
    }

    public static TextValue stringValue(String value) {
        return new StringValue.Direct(value);
    }

    public static Value stringOrNoValue(String value) {
        if (value == null) {
            return NO_VALUE;
        }
        return new StringValue.Direct(value);
    }

    public static Value numberValue(Number number) {
        if (number instanceof Long) {
            return Values.longValue(number.longValue());
        }
        if (number instanceof Integer) {
            return Values.intValue(number.intValue());
        }
        if (number instanceof Double) {
            return Values.doubleValue(number.doubleValue());
        }
        if (number instanceof Byte) {
            return Values.byteValue(number.byteValue());
        }
        if (number instanceof Float) {
            return Values.floatValue(number.floatValue());
        }
        if (number instanceof Short) {
            return Values.shortValue(number.shortValue());
        }
        if (number == null) {
            return NO_VALUE;
        }
        throw new UnsupportedOperationException("Unsupported type of Number " + number.toString());
    }

    public static Value longValue(long value) {
        return new LongValue(value);
    }

    public static Value intValue(int value) {
        return new IntValue(value);
    }

    public static Value shortValue(short value) {
        return new ShortValue(value);
    }

    public static Value byteValue(byte value) {
        return new ByteValue(value);
    }

    public static Value booleanValue(boolean value) {
        return new BooleanValue(value);
    }

    public static Value charValue(char value) {
        return new CharValue(value);
    }

    public static Value doubleValue(double value) {
        return new DoubleValue(value);
    }

    public static Value floatValue(float value) {
        return new FloatValue(value);
    }

    public static Value stringArray(String[] value) {
        return new StringArray.Direct(value);
    }

    public static Value byteArray(byte[] value) {
        return new ByteArray.Direct(value);
    }

    public static Value longArray(long[] value) {
        return new LongArray.Direct(value);
    }

    public static Value intArray(int[] value) {
        return new IntArray.Direct(value);
    }

    public static Value doubleArray(double[] value) {
        return new DoubleArray.Direct(value);
    }

    public static Value floatArray(float[] value) {
        return new FloatArray.Direct(value);
    }

    public static Value booleanArray(boolean[] value) {
        return new BooleanArray.Direct(value);
    }

    public static Value charArray(char[] value) {
        return new CharArray.Direct(value);
    }

    public static Value shortArray(short[] value) {
        return new ShortArray.Direct(value);
    }

    public static Value of(Object value) {
        return Values.of(value, true);
    }

    public static Value of(Object value, boolean allowNull) {
        if (value instanceof String) {
            return Values.stringValue((String)value);
        }
        if (value instanceof Object[]) {
            return Values.arrayValue((Object[])value);
        }
        if (value instanceof Long) {
            return Values.longValue((Long)value);
        }
        if (value instanceof Integer) {
            return Values.intValue((Integer)value);
        }
        if (value instanceof Boolean) {
            return Values.booleanValue((Boolean)value);
        }
        if (value instanceof Double) {
            return Values.doubleValue((Double)value);
        }
        if (value instanceof Float) {
            return Values.floatValue(((Float)value).floatValue());
        }
        if (value instanceof Short) {
            return Values.shortValue((Short)value);
        }
        if (value instanceof Byte) {
            return Values.byteValue((Byte)value);
        }
        if (value instanceof Character) {
            return Values.charValue(((Character)value).charValue());
        }
        if (value instanceof byte[]) {
            return Values.byteArray((byte[])((byte[])value).clone());
        }
        if (value instanceof long[]) {
            return Values.longArray((long[])((long[])value).clone());
        }
        if (value instanceof int[]) {
            return Values.intArray((int[])((int[])value).clone());
        }
        if (value instanceof double[]) {
            return Values.doubleArray((double[])((double[])value).clone());
        }
        if (value instanceof float[]) {
            return Values.floatArray((float[])((float[])value).clone());
        }
        if (value instanceof boolean[]) {
            return Values.booleanArray((boolean[])((boolean[])value).clone());
        }
        if (value instanceof char[]) {
            return Values.charArray((char[])((char[])value).clone());
        }
        if (value instanceof short[]) {
            return Values.shortArray((short[])((short[])value).clone());
        }
        if (value == null) {
            if (allowNull) {
                return NoValue.NO_VALUE;
            }
            throw new IllegalArgumentException("[null] is not a supported property value");
        }
        if (value instanceof Value) {
            throw new UnsupportedOperationException("Converting a Value to a Value using Values.of() is not supported.");
        }
        throw new IllegalArgumentException(String.format("[%s:%s] is not a supported property value", value, value.getClass().getName()));
    }

    public static Value[] values(Object ... objects) {
        return (Value[])Arrays.stream(objects).map(Values::of).toArray(Value[]::new);
    }

    @Deprecated
    public static Object asObject(Value value) {
        return value == null ? null : value.asObject();
    }

    public static Object[] asObjects(Value[] propertyValues) {
        Object[] legacy = new Object[propertyValues.length];
        for (int i = 0; i < propertyValues.length; ++i) {
            legacy[i] = propertyValues[i].asObjectCopy();
        }
        return legacy;
    }

    private static Value arrayValue(Object[] value) {
        if (value instanceof String[]) {
            return Values.stringArray(Values.copy(value, new String[value.length]));
        }
        if (value instanceof Byte[]) {
            return Values.byteArray(Values.copy(value, new byte[value.length]));
        }
        if (value instanceof Long[]) {
            return Values.longArray(Values.copy(value, new long[value.length]));
        }
        if (value instanceof Integer[]) {
            return Values.intArray(Values.copy(value, new int[value.length]));
        }
        if (value instanceof Double[]) {
            return Values.doubleArray(Values.copy(value, new double[value.length]));
        }
        if (value instanceof Float[]) {
            return Values.floatArray(Values.copy(value, new float[value.length]));
        }
        if (value instanceof Boolean[]) {
            return Values.booleanArray(Values.copy(value, new boolean[value.length]));
        }
        if (value instanceof Character[]) {
            return Values.charArray(Values.copy(value, new char[value.length]));
        }
        if (value instanceof Short[]) {
            return Values.shortArray(Values.copy(value, new short[value.length]));
        }
        throw new IllegalArgumentException(String.format("%s[] is not a supported property value type", value.getClass().getComponentType().getName()));
    }

    private static <T> T copy(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException("Property array value elements may not be null.");
            }
            Array.set(target, i, value[i]);
        }
        return target;
    }
}

