/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Arrays;
import org.neo4j.values.IntegralArray;
import org.neo4j.values.NumberValues;
import org.neo4j.values.PrimitiveArrayValues;
import org.neo4j.values.PrimitiveArrayWriting;
import org.neo4j.values.Value;
import org.neo4j.values.ValueWriter;

abstract class LongArray
extends IntegralArray {
    LongArray() {
    }

    abstract long[] value();

    @Override
    public int length() {
        return this.value().length;
    }

    @Override
    public long longValue(int index) {
        return this.value()[index];
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public int hashCode() {
        return NumberValues.hash(this.value());
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value());
    }

    @Override
    public boolean equals(byte[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(short[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(int[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(long[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public boolean equals(float[] x) {
        return PrimitiveArrayValues.equals(this.value(), x);
    }

    @Override
    public boolean equals(double[] x) {
        return PrimitiveArrayValues.equals(this.value(), x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public Object asObjectCopy() {
        return this.value().clone();
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value());
    }

    @Override
    @Deprecated
    public Object asObject() {
        return this.value();
    }

    static final class Direct
    extends LongArray {
        final long[] value;

        Direct(long[] value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        long[] value() {
            return this.value;
        }

        public String toString() {
            return String.format("LongArray%s", Arrays.toString(this.value()));
        }
    }
}

